/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.grid.layer;

import net.sourceforge.nattable.columnRename.DisplayColumnRenameDialogCommandHandler;
import net.sourceforge.nattable.columnRename.RenameColumnHeaderCommandHandler;
import net.sourceforge.nattable.columnRename.RenameColumnHelper;
import net.sourceforge.nattable.grid.layer.ColumnHeaderSelectionListener;
import net.sourceforge.nattable.grid.layer.DimensionallyDependentLayer;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.layer.IUniqueIndexLayer;
import net.sourceforge.nattable.layer.LabelStack;
import net.sourceforge.nattable.layer.LayerUtil;
import net.sourceforge.nattable.layer.config.DefaultColumnHeaderLayerConfiguration;
import net.sourceforge.nattable.painter.layer.CellLayerPainter;
import net.sourceforge.nattable.painter.layer.ILayerPainter;
import net.sourceforge.nattable.selection.SelectionLayer;

public class ColumnHeaderLayer
extends DimensionallyDependentLayer {
    private final SelectionLayer selectionLayer;
    private final ILayerPainter layerPainter = new CellLayerPainter();
    private final RenameColumnHelper renameColumnHelper;

    public ColumnHeaderLayer(IUniqueIndexLayer baseLayer, ILayer horizontalLayerDependency, SelectionLayer selectionLayer) {
        this(baseLayer, horizontalLayerDependency, selectionLayer, true);
    }

    public ColumnHeaderLayer(IUniqueIndexLayer baseLayer, ILayer horizontalLayerDependency, SelectionLayer selectionLayer, boolean useDefaultConfiguration) {
        super(baseLayer, horizontalLayerDependency, baseLayer);
        this.selectionLayer = selectionLayer;
        this.renameColumnHelper = new RenameColumnHelper(this);
        this.registerPersistable(this.renameColumnHelper);
        selectionLayer.addLayerListener(new ColumnHeaderSelectionListener(this));
        this.registerCommandHandler(new RenameColumnHeaderCommandHandler(this));
        this.registerCommandHandler(new DisplayColumnRenameDialogCommandHandler(this));
        if (useDefaultConfiguration) {
            this.addConfiguration(new DefaultColumnHeaderLayerConfiguration());
        }
    }

    public String getDisplayModeByPosition(int columnPosition, int rowPosition) {
        int selectionLayerColumnPosition = LayerUtil.convertColumnPosition(this, columnPosition, this.selectionLayer);
        if (this.selectionLayer.isColumnPositionSelected(selectionLayerColumnPosition)) {
            return "SELECT";
        }
        return super.getDisplayModeByPosition(columnPosition, rowPosition);
    }

    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        LabelStack labelStack = super.getConfigLabelsByPosition(columnPosition, rowPosition);
        int selectionLayerColumnPosition = LayerUtil.convertColumnPosition(this, columnPosition, this.selectionLayer);
        if (this.selectionLayer.isColumnFullySelected(selectionLayerColumnPosition)) {
            labelStack.addLabel("COLUMN_HEADER_FULL");
        }
        return labelStack;
    }

    public SelectionLayer getSelectionLayer() {
        return this.selectionLayer;
    }

    public ILayerPainter getLayerPainter() {
        return this.layerPainter;
    }

    public Object getDataValueByPosition(int columnPosition, int rowPosition) {
        int columnIndex = this.getColumnIndexByPosition(columnPosition);
        if (this.isColumnRenamed(columnIndex)) {
            return this.getRenamedColumnLabelByIndex(columnIndex);
        }
        return super.getDataValueByPosition(columnPosition, rowPosition);
    }

    public String getOriginalColumnLabel(int columnPosition) {
        return super.getDataValueByPosition(columnPosition, 0).toString();
    }

    public String getRenamedColumnLabel(int columnPosition) {
        int index = this.getColumnIndexByPosition(columnPosition);
        return this.getRenamedColumnLabelByIndex(index);
    }

    public String getRenamedColumnLabelByIndex(int columnIndex) {
        return this.renameColumnHelper.getRenamedColumnLabel(columnIndex);
    }

    public boolean isColumnRenamed(int columnIndex) {
        return this.renameColumnHelper.isColumnRenamed(columnIndex);
    }

    public boolean renameColumnPosition(int columnPosition, String customColumnName) {
        return this.renameColumnHelper.renameColumnPosition(columnPosition, customColumnName);
    }
}

