/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.edit.gui;

import net.sourceforge.nattable.data.convert.IDisplayConverter;
import net.sourceforge.nattable.data.validate.IDataValidator;
import net.sourceforge.nattable.edit.ActiveCellEditor;
import net.sourceforge.nattable.edit.EditTypeEnum;
import net.sourceforge.nattable.edit.ICellEditHandler;
import net.sourceforge.nattable.edit.editor.ICellEditor;
import net.sourceforge.nattable.selection.SelectionLayer;
import net.sourceforge.nattable.style.IStyle;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class MultiCellEditDialog
extends Dialog {
    private static final String SET = "Set";
    private static final String INCREASE_BY = "Increase by";
    private static final String DECREASE_BY = "Decrease by";
    private static final String[] OPTIONS = new String[]{"Set", "Increase by", "Decrease by"};
    private final ICellEditor cellEditor;
    private final Object originalCanonicalValue;
    private final Character initialEditValue;
    private final IDisplayConverter dataTypeConverter;
    private final IStyle cellStyle;
    private final IDataValidator dataValidator;
    private final boolean allowIncrementDecrement;
    private Combo updateCombo;
    private int lastSelectedIndex = 0;
    private Object editorValue;

    public MultiCellEditDialog(Shell parentShell, ICellEditor cellEditor, IDisplayConverter dataTypeConverter, IStyle cellStyle, IDataValidator dataValidator, Object originalCanonicalValue, Character initialEditValue, boolean allowIncrementDecrement) {
        super(parentShell);
        this.setShellStyle(67696);
        this.cellEditor = cellEditor;
        this.dataTypeConverter = dataTypeConverter;
        this.cellStyle = cellStyle;
        this.dataValidator = dataValidator;
        this.originalCanonicalValue = originalCanonicalValue;
        this.initialEditValue = initialEditValue;
        this.allowIncrementDecrement = allowIncrementDecrement;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Enter new value");
    }

    protected Control createDialogArea(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)panel);
        GridLayout panelLayout = new GridLayout(this.allowIncrementDecrement ? 2 : 1, false);
        panel.setLayout((Layout)panelLayout);
        if (this.allowIncrementDecrement) {
            this.createUpdateCombo(panel);
        }
        ActiveCellEditor.close();
        ActiveCellEditor.activate(this.cellEditor, panel, this.originalCanonicalValue, this.initialEditValue, this.dataTypeConverter, this.cellStyle, this.dataValidator, new MultiEditHandler(), 0, 0, 0, 0);
        Control editorControl = ActiveCellEditor.getControl();
        editorControl.addKeyListener(this.getEscKeyListener());
        GridDataFactory layoutData = GridDataFactory.fillDefaults().grab(true, false).hint(100, 20);
        if (this.allowIncrementDecrement) {
            layoutData.indent(5, 0);
        }
        layoutData.applyTo(editorControl);
        return panel;
    }

    private KeyListener getEscKeyListener() {
        return new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 27) {
                    this.closeDialog();
                }
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 27) {
                    this.closeDialog();
                }
            }

            private void closeDialog() {
                MultiCellEditDialog.this.setReturnCode(256);
                MultiCellEditDialog.this.close();
            }
        };
    }

    private void createUpdateCombo(Composite composite) {
        this.updateCombo = new Combo(composite, 2060);
        String[] stringArray = OPTIONS;
        int n = OPTIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String option = stringArray[n2];
            this.updateCombo.add(option);
            ++n2;
        }
        this.updateCombo.select(0);
        this.updateCombo.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                MultiCellEditDialog.this.lastSelectedIndex = MultiCellEditDialog.this.updateCombo.getSelectionIndex();
            }
        });
        GridDataFactory.swtDefaults().applyTo((Control)this.updateCombo);
    }

    protected void okPressed() {
        if (ActiveCellEditor.isValid()) {
            Object canonicalValue = ActiveCellEditor.getCanonicalValue();
            if (ActiveCellEditor.validateCanonicalValue()) {
                this.editorValue = canonicalValue;
                super.okPressed();
            }
        }
    }

    public EditTypeEnum getEditType() {
        if (this.allowIncrementDecrement && this.updateCombo != null) {
            int selectionIndex = this.updateCombo.isDisposed() ? this.lastSelectedIndex : this.updateCombo.getSelectionIndex();
            switch (selectionIndex) {
                case 0: {
                    return EditTypeEnum.SET;
                }
                case 1: {
                    return EditTypeEnum.INCREASE;
                }
                case 2: {
                    return EditTypeEnum.DECREASE;
                }
            }
        }
        return EditTypeEnum.SET;
    }

    public Object getEditorValue() {
        return this.editorValue;
    }

    class MultiEditHandler
    implements ICellEditHandler {
        MultiEditHandler() {
        }

        public boolean commit(SelectionLayer.MoveDirectionEnum direction, boolean closeAfterCommit) {
            if (direction == SelectionLayer.MoveDirectionEnum.NONE && closeAfterCommit) {
                MultiCellEditDialog.this.okPressed();
                return true;
            }
            return false;
        }
    }
}

