/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.command;

import java.util.Collection;
import java.util.HashSet;
import net.sourceforge.nattable.command.ILayerCommand;
import net.sourceforge.nattable.command.LayerCommandUtil;
import net.sourceforge.nattable.coordinate.ColumnPositionCoordinate;
import net.sourceforge.nattable.layer.ILayer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMultiColumnCommand
implements ILayerCommand {
    protected Collection<ColumnPositionCoordinate> columnPositionCoordinates;

    protected AbstractMultiColumnCommand(ILayer layer, int ... columnPositions) {
        this.setColumnPositions(layer, columnPositions);
    }

    protected AbstractMultiColumnCommand(AbstractMultiColumnCommand command) {
        this.columnPositionCoordinates = new HashSet<ColumnPositionCoordinate>(command.columnPositionCoordinates);
    }

    public Collection<Integer> getColumnPositions() {
        HashSet<Integer> columnPositions = new HashSet<Integer>();
        for (ColumnPositionCoordinate columnPositionCoordinate : this.columnPositionCoordinates) {
            columnPositions.add(columnPositionCoordinate.columnPosition);
        }
        return columnPositions;
    }

    protected final void setColumnPositions(ILayer layer, int ... columnPositions) {
        this.columnPositionCoordinates = new HashSet<ColumnPositionCoordinate>();
        int[] nArray = columnPositions;
        int n = columnPositions.length;
        int n2 = 0;
        while (n2 < n) {
            int columnPosition = nArray[n2];
            this.columnPositionCoordinates.add(new ColumnPositionCoordinate(layer, columnPosition));
            ++n2;
        }
    }

    @Override
    public boolean convertToTargetLayer(ILayer targetLayer) {
        HashSet<ColumnPositionCoordinate> convertedColumnPositionCoordinates = new HashSet<ColumnPositionCoordinate>();
        for (ColumnPositionCoordinate columnPositionCoordinate : this.columnPositionCoordinates) {
            ColumnPositionCoordinate convertedColumnPositionCoordinate = LayerCommandUtil.convertColumnPositionToTargetContext(columnPositionCoordinate, targetLayer);
            if (convertedColumnPositionCoordinate == null) continue;
            convertedColumnPositionCoordinates.add(convertedColumnPositionCoordinate);
        }
        this.columnPositionCoordinates = convertedColumnPositionCoordinates;
        return this.columnPositionCoordinates.size() > 0;
    }
}

