/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.columnCategories;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.nattable.columnCategories.ChooseColumnsFromCategoriesCommand;
import net.sourceforge.nattable.columnCategories.ColumnCategoriesModel;
import net.sourceforge.nattable.columnCategories.IColumnCategoriesDialogListener;
import net.sourceforge.nattable.columnCategories.gui.ColumnCategoriesDialog;
import net.sourceforge.nattable.columnChooser.ColumnChooserUtils;
import net.sourceforge.nattable.command.AbstractLayerCommandHandler;
import net.sourceforge.nattable.command.ILayerCommand;
import net.sourceforge.nattable.coordinate.PositionUtil;
import net.sourceforge.nattable.grid.layer.ColumnHeaderLayer;
import net.sourceforge.nattable.hideshow.ColumnHideShowLayer;
import net.sourceforge.nattable.layer.DataLayer;
import net.sourceforge.nattable.reorder.command.ColumnReorderCommand;
import net.sourceforge.nattable.reorder.command.MultiColumnReorderCommand;
import net.sourceforge.nattable.selection.SelectionLayer;
import net.sourceforge.nattable.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChooseColumnsFromCategoriesCommandHandler
extends AbstractLayerCommandHandler<ChooseColumnsFromCategoriesCommand>
implements IColumnCategoriesDialogListener {
    private final ColumnHideShowLayer columnHideShowLayer;
    private final ColumnHeaderLayer columnHeaderLayer;
    private final DataLayer columnHeaderDataLayer;
    private final ColumnCategoriesModel model;
    private ColumnCategoriesDialog dialog;

    public ChooseColumnsFromCategoriesCommandHandler(ColumnHideShowLayer columnHideShowLayer, ColumnHeaderLayer columnHeaderLayer, DataLayer columnHeaderDataLayer, ColumnCategoriesModel model) {
        this.columnHideShowLayer = columnHideShowLayer;
        this.columnHeaderLayer = columnHeaderLayer;
        this.columnHeaderDataLayer = columnHeaderDataLayer;
        this.model = model;
    }

    @Override
    protected boolean doCommand(ChooseColumnsFromCategoriesCommand command) {
        this.dialog = new ColumnCategoriesDialog(command.getShell(), this.model, ColumnChooserUtils.getHiddenColumnEntries(this.columnHideShowLayer, this.columnHeaderLayer, this.columnHeaderDataLayer), ColumnChooserUtils.getVisibleColumnsEntries(this.columnHideShowLayer, this.columnHeaderLayer, this.columnHeaderDataLayer));
        this.dialog.addListener(this);
        this.dialog.open();
        return true;
    }

    @Override
    public Class<ChooseColumnsFromCategoriesCommand> getCommandClass() {
        return ChooseColumnsFromCategoriesCommand.class;
    }

    @Override
    public void itemsRemoved(List<Integer> removedColumnPositions) {
        ColumnChooserUtils.hideColumnPositions(removedColumnPositions, this.columnHideShowLayer);
        this.refreshDialog();
    }

    @Override
    public void itemsSelected(List<Integer> addedColumnIndexes) {
        ColumnChooserUtils.showColumnIndexes(addedColumnIndexes, this.columnHideShowLayer);
        this.refreshDialog();
    }

    @Override
    public void itemsMoved(SelectionLayer.MoveDirectionEnum direction, List<Integer> selectedPositions) {
        List<List<Integer>> fromPositions = PositionUtil.getGroupedByContiguous(selectedPositions);
        List<Integer> toPositions = this.getDestinationPositions(direction, fromPositions);
        int i = 0;
        while (i < fromPositions.size()) {
            boolean multipleColumnsMoved = fromPositions.get(i).size() > 1;
            ILayerCommand command = null;
            if (!multipleColumnsMoved) {
                int fromPosition = fromPositions.get(i).get(0);
                int toPosition = toPositions.get(i);
                command = new ColumnReorderCommand(this.columnHideShowLayer, fromPosition, toPosition);
            } else if (multipleColumnsMoved) {
                command = new MultiColumnReorderCommand(this.columnHideShowLayer, fromPositions.get(i), toPositions.get(i));
            }
            this.columnHideShowLayer.doCommand(command);
            ++i;
        }
        this.refreshDialog();
    }

    protected List<Integer> getDestinationPositions(SelectionLayer.MoveDirectionEnum direction, List<List<Integer>> selectedPositions) {
        ArrayList<Integer> destinationPositions = new ArrayList<Integer>();
        for (List<Integer> contiguousPositions : selectedPositions) {
            switch (direction) {
                case UP: {
                    destinationPositions.add(ObjectUtils.getFirstElement(contiguousPositions) - 1);
                    break;
                }
                case DOWN: {
                    destinationPositions.add(ObjectUtils.getLastElement(contiguousPositions) + 2);
                }
            }
        }
        return destinationPositions;
    }

    private void refreshDialog() {
        if (ObjectUtils.isNotNull((Object)this.dialog)) {
            this.dialog.refresh(ColumnChooserUtils.getHiddenColumnEntries(this.columnHideShowLayer, this.columnHeaderLayer, this.columnHeaderDataLayer), ColumnChooserUtils.getVisibleColumnsEntries(this.columnHideShowLayer, this.columnHeaderLayer, this.columnHeaderDataLayer));
        }
    }
}

