/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.search;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.photran.internal.core.util.Pair;
import org.eclipse.photran.internal.ui.WorkbenchSelectionInfo;
import org.eclipse.photran.internal.ui.search.Messages;
import org.eclipse.photran.internal.ui.vpg.Activator;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IWorkingSet;

public abstract class SearchPage
extends DialogPage
implements ISearchPage {
    private static final String STORE_PREVIOUS_PATTERNS = "previousPatterns";
    private static final String STORE_REGEX_SEARCH = "regexSearch";
    private static final String STORE_SEARCH_FLAGS = "searchFlags";
    private Combo patternCombo;
    private String[] previousPatterns;
    private MessageBox errorBox;
    private Button regexButton;
    private boolean isRegex;
    private boolean firstTime = true;
    private IStructuredSelection structuredSelection;
    private ITextSelection textSelection;
    private ISearchPageContainer pageContainer;
    private Label patternLabel;
    private final String globPatternString = Messages.SearchPage_AnyStringAnyCharLabel;
    private String[] searchForText;
    private Integer[] searchForData;
    private String[] limitToText;
    private Integer[] limitToData;
    private Button[] searchForButtons;
    private Button[] limitToButtons;

    protected abstract String PAGE_NAME();

    protected IResource getResource(Object obj) {
        if (obj instanceof IResource) {
            return (IResource)obj;
        }
        if (obj instanceof IAdaptable) {
            Object res = ((IAdaptable)obj).getAdapter(IResource.class);
            return res == null ? null : (IResource)res;
        }
        return null;
    }

    public boolean performAction() {
        ISearchQuery job;
        String patternStr = this.patternCombo.getText();
        ArrayList<IResource> scope = new ArrayList<IResource>();
        String scopeDescription = this.determineScope(scope);
        int searchFlags = this.getSearchFlagsFromSelectedButtons();
        try {
            patternStr = patternStr.trim();
            job = this.createSearchQuery(scope, scopeDescription, patternStr, this.convertPattern(this.isRegex, patternStr), searchFlags);
        }
        catch (PatternSyntaxException e) {
            this.errorBox = new MessageBox(this.getShell(), 33);
            this.errorBox.setText(Messages.SearchPage_InvalidSearchPatternTitle);
            this.errorBox.setMessage(String.valueOf(Messages.SearchPage_SearchPatternIsInvalid) + e.getMessage());
            this.errorBox.open();
            return false;
        }
        NewSearchUI.activateSearchResultView();
        NewSearchUI.runQueryInBackground((ISearchQuery)job);
        this.saveDialogSettings(patternStr, searchFlags);
        return true;
    }

    protected String convertPattern(boolean isRegex, String patternStr) throws PatternSyntaxException {
        if (isRegex) {
            Pattern.compile(patternStr);
            return patternStr;
        }
        return SearchPage.convertGlobToRegex(patternStr);
    }

    public static String convertGlobToRegex(String patternStr) {
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (i < patternStr.length()) {
            char c = patternStr.charAt(i);
            switch (c) {
                case '*': {
                    buff.append(".*");
                    break;
                }
                case '?': {
                    buff.append(".");
                    break;
                }
                case '$': {
                    buff.append("\\$");
                    break;
                }
                default: {
                    if (!Character.toString(c).matches("[0-9a-zA-Z._]")) {
                        throw new PatternSyntaxException(Messages.SearchPage_IllegalCharacterInPatternString, patternStr, i + 1);
                    }
                    buff.append(String.valueOf(Messages.SearchPage_11) + c);
                }
            }
            ++i;
        }
        return buff.toString();
    }

    protected abstract ISearchQuery createSearchQuery(List<IResource> var1, String var2, String var3, String var4, int var5);

    private String determineScope(List<IResource> scope) {
        String scopeDescription;
        switch (this.getContainer().getSelectedScope()) {
            case 3: {
                scopeDescription = Messages.SearchPage_ScopeDescription_EnclosingProjects;
                if (this.structuredSelection != null) {
                    Iterator i = this.structuredSelection.iterator();
                    while (i.hasNext()) {
                        IResource res = this.getResource(i.next());
                        if (res == null) continue;
                        scope.add(res);
                    }
                    break;
                }
                IFile fileInEditor = new WorkbenchSelectionInfo().getFileInEditor();
                if (fileInEditor == null) break;
                scope.add((IResource)fileInEditor.getProject());
                break;
            }
            case 1: {
                scopeDescription = Messages.SearchPage_ScopeDescription_SelectedResources;
                if (this.structuredSelection == null) break;
                Iterator i = this.structuredSelection.iterator();
                while (i.hasNext()) {
                    IResource res = this.getResource(i.next());
                    if (res == null) continue;
                    scope.add(res);
                }
                break;
            }
            case 2: {
                IWorkingSet[] workingSets = this.getContainer().getSelectedWorkingSets();
                scopeDescription = String.valueOf(Messages.SearchPage_ScopeDescription_WorkingSet) + SearchPage.toString(workingSets);
                int i = 0;
                while (i < workingSets.length) {
                    IAdaptable[] wsElements;
                    IAdaptable[] iAdaptableArray = wsElements = workingSets[i].getElements();
                    int n = wsElements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IAdaptable elem = iAdaptableArray[n2];
                        IResource res = this.getResource(elem);
                        if (res != null) {
                            scope.add(res);
                        }
                        ++n2;
                    }
                    ++i;
                }
                break;
            }
            default: {
                scope.add((IResource)ResourcesPlugin.getWorkspace().getRoot());
                scopeDescription = Messages.SearchPage_ScopeDescription_Workspace;
            }
        }
        return scopeDescription;
    }

    private void saveDialogSettings(String patternStr, int searchFlags) {
        IDialogSettings settings = this.getDialogSettings();
        settings.put(STORE_REGEX_SEARCH, this.isRegex);
        if (this.previousPatterns == null) {
            this.previousPatterns = new String[]{patternStr};
        } else {
            boolean addit = true;
            int i = 0;
            while (i < this.previousPatterns.length) {
                if (patternStr.equals(this.previousPatterns[i])) {
                    String tmpPattern = this.previousPatterns[i];
                    System.arraycopy(this.previousPatterns, 0, this.previousPatterns, 1, i);
                    this.previousPatterns[0] = tmpPattern;
                    addit = false;
                    break;
                }
                ++i;
            }
            if (addit) {
                String[] newPatterns = new String[this.previousPatterns.length + 1];
                System.arraycopy(this.previousPatterns, 0, newPatterns, 1, this.previousPatterns.length);
                newPatterns[0] = patternStr;
                this.previousPatterns = newPatterns;
            }
        }
        settings.put(STORE_PREVIOUS_PATTERNS, this.previousPatterns);
        settings.put(STORE_SEARCH_FLAGS, searchFlags);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        result.setLayout((Layout)layout);
        result.setLayoutData((Object)new GridData(768));
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 18;
        gd.horizontalSpan = 2;
        Label label = new Label(result, 16384);
        label.setText(Messages.SearchPage_SearchPatternLabel);
        label.setLayoutData((Object)gd);
        this.patternCombo = new Combo(result, 2052);
        this.patternCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SearchPage.this.setPerformActionEnabled();
            }
        });
        gd = new GridData(768);
        this.regexButton = new Button(result, 32);
        this.regexButton.setText(Messages.SearchPage_RegularExpressionLabel);
        gd = new GridData();
        this.regexButton.setLayoutData((Object)gd);
        this.regexButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchPage.this.isRegex = SearchPage.this.regexButton.getSelection();
                SearchPage.this.setPerformActionEnabled();
            }
        });
        gd = new GridData(768);
        gd.horizontalIndent = -gd.horizontalIndent;
        this.patternCombo.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 18;
        gd.horizontalSpan = 2;
        this.patternLabel = new Label(result, 16384);
        this.patternLabel.setText(this.globPatternString);
        this.patternLabel.setLayoutData((Object)gd);
        Composite groupsComposite = new Composite(result, 0);
        layout = new GridLayout(2, false);
        groupsComposite.setLayout((Layout)layout);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        groupsComposite.setLayoutData((Object)gd);
        this.prepareToCreateSearchAndLimitButtons(groupsComposite);
        Group group = new Group(groupsComposite, 0);
        group.setText(Messages.SearchPage_SearchForLabel);
        layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(770));
        this.addSelectionListener(this.createSearchForButtons(group));
        group = new Group(groupsComposite, 0);
        group.setText(Messages.SearchPage_LimitToLabel);
        layout = new GridLayout();
        layout.numColumns = 1;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(770));
        this.addSelectionListener(this.createLimitToButtons(group));
        this.createAdditionalGroups(groupsComposite);
        this.setControl((Control)result);
        Dialog.applyDialogFont((Control)result);
    }

    private void addSelectionListener(Button[] buttons) {
        Button[] buttonArray = buttons;
        int n = buttons.length;
        int n2 = 0;
        while (n2 < n) {
            Button button = buttonArray[n2];
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SearchPage.this.setPerformActionEnabled();
                }
            });
            ++n2;
        }
    }

    protected void createAdditionalGroups(Composite groupsComposite) {
    }

    public void setContainer(ISearchPageContainer container) {
        this.pageContainer = container;
    }

    private ISearchPageContainer getContainer() {
        return this.pageContainer;
    }

    protected void setPerformActionEnabled() {
        boolean enable = true;
        this.patternLabel.setVisible(!this.isRegex);
        if (this.patternCombo.getText().length() == 0) {
            enable = false;
        }
        if (!this.isAtLeastOneSearchForButtonChecked()) {
            enable = false;
        }
        this.getContainer().setPerformActionEnabled(enable);
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings searchSettings = settings.getSection(this.PAGE_NAME());
        if (searchSettings == null) {
            searchSettings = settings.addNewSection(this.PAGE_NAME());
        }
        return searchSettings;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (this.firstTime) {
                this.firstTime = false;
                this.restoreDialogSettings();
            }
            this.patternCombo.setFocus();
            this.setPerformActionEnabled();
        }
        super.setVisible(visible);
    }

    private void restoreDialogSettings() {
        ISelection selection;
        IDialogSettings settings = this.getDialogSettings();
        int searchFlags = this.defaultSearchFlags();
        try {
            searchFlags = settings.getInt(STORE_SEARCH_FLAGS);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.previousPatterns = settings.getArray(STORE_PREVIOUS_PATTERNS);
        if (this.previousPatterns != null) {
            this.patternCombo.setItems(this.previousPatterns);
        }
        if ((selection = this.getContainer().getSelection()) instanceof IStructuredSelection) {
            this.structuredSelection = (IStructuredSelection)selection;
        } else if (selection instanceof ITextSelection) {
            this.textSelection = (ITextSelection)selection;
            this.patternCombo.setText(this.textSelection.getText());
        }
        this.checkButtonsCorrespondingTo(searchFlags);
        this.isRegex = settings.getBoolean(STORE_REGEX_SEARCH);
        this.regexButton.setSelection(this.isRegex);
    }

    protected abstract int defaultSearchFlags();

    public static String toString(IWorkingSet[] workingSets) {
        if (workingSets != null && workingSets.length > 0) {
            String string = new String();
            int i = 0;
            while (i < workingSets.length) {
                if (i > 0) {
                    string = String.valueOf(string) + ", ";
                }
                string = String.valueOf(string) + workingSets[i].getName();
                ++i;
            }
            return string;
        }
        return null;
    }

    protected void prepareToCreateSearchAndLimitButtons(Composite groupsComposite) {
        List<Pair<String, Integer>> searchFor = this.searchFor();
        this.searchForText = new String[searchFor.size()];
        this.searchForData = new Integer[searchFor.size()];
        int i = 0;
        for (Pair<String, Integer> pair : searchFor) {
            this.searchForText[i] = (String)pair.fst;
            this.searchForData[i] = (Integer)pair.snd;
            ++i;
        }
        List<Pair<String, Integer>> limitTo = this.limitTo();
        this.limitToText = new String[limitTo.size()];
        this.limitToData = new Integer[limitTo.size()];
        i = 0;
        for (Pair<String, Integer> pair : limitTo) {
            this.limitToText[i] = (String)pair.fst;
            this.limitToData[i] = (Integer)pair.snd;
            ++i;
        }
    }

    protected Button[] createSearchForButtons(Group group) {
        this.searchForButtons = new Button[this.searchForText.length];
        int i = 0;
        while (i < this.searchForText.length) {
            Button button = new Button((Composite)group, 32);
            button.setText(this.searchForText[i]);
            button.setData((Object)this.searchForData[i]);
            this.searchForButtons[i] = button;
            ++i;
        }
        return this.searchForButtons;
    }

    protected Button[] createLimitToButtons(Group group) {
        this.limitToButtons = new Button[this.limitToText.length];
        int i = 0;
        while (i < this.limitToText.length) {
            Button button = new Button((Composite)group, 16);
            button.setText(this.limitToText[i]);
            button.setData((Object)this.limitToData[i]);
            this.limitToButtons[i] = button;
            ++i;
        }
        return this.limitToButtons;
    }

    protected boolean isAtLeastOneSearchForButtonChecked() {
        int i = 0;
        while (i < this.searchForButtons.length) {
            if (this.searchForButtons[i].getSelection()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected int getSearchFlagsFromSelectedButtons() {
        int searchFlags = 0;
        int i = 0;
        while (i < this.searchForButtons.length) {
            if (this.searchForButtons[i].getSelection()) {
                searchFlags |= ((Integer)this.searchForButtons[i].getData()).intValue();
            }
            ++i;
        }
        i = 0;
        while (i < this.limitToButtons.length) {
            if (this.limitToButtons[i].getSelection()) {
                searchFlags |= ((Integer)this.limitToButtons[i].getData()).intValue();
            }
            ++i;
        }
        return searchFlags;
    }

    protected void checkButtonsCorrespondingTo(int searchFlags) {
        this.checkAllSearchForButtonsCorrespondingTo(searchFlags);
        this.selectFirstLimitToButtonCorrespondingTo(searchFlags);
    }

    protected void checkAllSearchForButtonsCorrespondingTo(int searchFlags) {
        int i = 0;
        while (i < this.searchForButtons.length) {
            boolean shouldCheck = (searchFlags & (Integer)this.searchForButtons[i].getData()) != 0;
            this.searchForButtons[i].setSelection(shouldCheck);
            ++i;
        }
    }

    protected void selectFirstLimitToButtonCorrespondingTo(int searchFlags) {
        boolean buttonHasBeenSelected = false;
        int i = 0;
        while (i < this.limitToButtons.length) {
            if (buttonHasBeenSelected) {
                this.limitToButtons[i].setSelection(false);
            } else {
                buttonHasBeenSelected = (searchFlags & (Integer)this.limitToButtons[i].getData()) != 0;
                this.limitToButtons[i].setSelection(buttonHasBeenSelected);
            }
            ++i;
        }
    }

    protected abstract List<Pair<String, Integer>> searchFor();

    protected abstract List<Pair<String, Integer>> limitTo();
}

