/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.activestatedebugger.preferences;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.compiler.util.Util;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.tcl.activestatedebugger.InstrumentationConfigProcessor;
import org.eclipse.dltk.tcl.activestatedebugger.InstrumentationSetup;
import org.eclipse.dltk.tcl.activestatedebugger.InstrumentationUtils;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.ContainerPattern;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.ContainerType;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.InstrumentationConfig;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.InstrumentationContentProvider;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.InstrumentationLabelProvider;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.InstrumentationMode;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.LibraryContainerElement;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.ModelElementPattern;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.PackageContainerElement;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.PackageElement;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.PackagePattern;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.Pattern;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.PreferenceMessages;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.PreferencesFactory;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.ProjectSelectionDialogInput;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.SelectionDialogComparator;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.SelectionDialogInput;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.SourceContainerElement;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.SourceElement;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.SourcePattern;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.TreeSelectionControl;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.WorkbenchAdaptable;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.WorkspaceSelectionDialogInput;
import org.eclipse.dltk.ui.util.PixelConverter;
import org.eclipse.dltk.ui.util.SWTFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class InstrumentationPatternList {
    private final IProject parentProject;
    private Composite fMode;
    private Button fDefaultMode;
    private Button fSourceModulesMode;
    private Button fSelectionMode;
    private CheckboxTreeViewer fViewer;
    private TreeSelectionControl fSelectionControl;
    private int updateCount = 0;

    public InstrumentationPatternList(IProject parentProject) {
        this.parentProject = parentProject;
    }

    public Control createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 1;
        topLayout.marginHeight = 0;
        topLayout.marginWidth = 0;
        comp.setLayout((Layout)topLayout);
        GridData gd = new GridData(1808);
        comp.setLayoutData((Object)gd);
        boolean useShowPatterns = true;
        this.fMode = new Composite(comp, 0);
        this.fMode.setLayoutData((Object)new GridData(768));
        GridLayout modeLayout = new GridLayout(3, false);
        ++modeLayout.numColumns;
        modeLayout.marginHeight = 0;
        this.fMode.setLayout((Layout)modeLayout);
        this.fSourceModulesMode = SWTFactory.createRadioButtonNoLayoutData((Composite)this.fMode, (String)PreferenceMessages.InstrumentationPatternList_ModeSources);
        this.fSelectionMode = SWTFactory.createRadioButtonNoLayoutData((Composite)this.fMode, (String)PreferenceMessages.InstrumentationPatternList_ModeSelection);
        this.fDefaultMode = SWTFactory.createRadioButtonNoLayoutData((Composite)this.fMode, (String)PreferenceMessages.InstrumentationPatternList_ModeDefault);
        SelectionAdapter modeListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!InstrumentationPatternList.this.isUpdate()) {
                    boolean newEnabled = InstrumentationPatternList.this.fSelectionMode.getSelection();
                    if (InstrumentationPatternList.this.fViewer.getControl().isEnabled() != newEnabled) {
                        InstrumentationPatternList.this.fViewer.getControl().setEnabled(newEnabled);
                    }
                }
            }
        };
        this.fDefaultMode.addSelectionListener((SelectionListener)modeListener);
        this.fSourceModulesMode.addSelectionListener((SelectionListener)modeListener);
        this.fSelectionMode.addSelectionListener((SelectionListener)modeListener);
        final Button btnShowPatterns = SWTFactory.createPushButtonNoLayoutData((Composite)this.fMode, (String)PreferenceMessages.InstrumentationPatternList_ButtonShowPatterns);
        btnShowPatterns.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        btnShowPatterns.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstrumentationConfig instrumentation = PreferencesFactory.eINSTANCE.createInstrumentationConfig();
                InstrumentationPatternList.this.getValue(instrumentation);
                InstrumentationConfigProcessor processor = new InstrumentationConfigProcessor(InstrumentationPatternList.this.parentProject);
                processor.configure(instrumentation);
                StringBuilder sb = new StringBuilder();
                for (InstrumentationSetup.PatternEntry pattern : processor.getPatterns()) {
                    if (sb.length() != 0) {
                        sb.append(Util.LINE_SEPARATOR);
                    }
                    sb.append(pattern.toString());
                }
                MessageDialog.openInformation((Shell)btnShowPatterns.getShell(), (String)PreferenceMessages.InstrumentationPatternList_PatternsMessageDialogitle, (String)sb.toString());
            }
        });
        this.fViewer = new CheckboxTreeViewer(comp, 2048);
        GridData viewerLayoutData = new GridData(1808);
        viewerLayoutData.heightHint = new PixelConverter((Control)parent).convertHeightInCharsToPixels(15);
        this.fViewer.getTree().setLayoutData((Object)viewerLayoutData);
        InstrumentationContentProvider cp = new InstrumentationContentProvider();
        this.fViewer.setContentProvider((IContentProvider)cp);
        this.fViewer.setLabelProvider((IBaseLabelProvider)new InstrumentationLabelProvider(cp));
        this.fViewer.setComparator((ViewerComparator)new SelectionDialogComparator());
        this.fSelectionControl = new TreeSelectionControl(this.fViewer){

            protected String getLabelOf(Object element) {
                if (element instanceof IModelElement) {
                    return ((IModelElement)element).getPath().toString();
                }
                return super.getLabelOf(element);
            }
        };
        this.fSelectionControl.install();
        return comp;
    }

    private boolean isUpdate() {
        return this.updateCount != 0;
    }

    private void beginUpdate() {
        ++this.updateCount;
    }

    private void endUpdate() {
        --this.updateCount;
    }

    public void setValue(InstrumentationConfig config) {
        this.beginUpdate();
        try {
            InstrumentationMode mode = InstrumentationUtils.getMode(config);
            SelectionDialogInput treeInput = this.parentProject == null ? new WorkspaceSelectionDialogInput() : new ProjectSelectionDialogInput(this.parentProject);
            this.fSelectionControl.setInput(treeInput);
            if (InstrumentationMode.SOURCES.equals((Object)mode)) {
                this.fSourceModulesMode.setSelection(true);
                this.fViewer.getControl().setEnabled(false);
                this.fSelectionControl.resetState();
            } else if (InstrumentationMode.SELECTION.equals((Object)mode)) {
                this.fSelectionMode.setSelection(true);
                this.fViewer.getControl().setEnabled(true);
                ArrayList<Object> includes = new ArrayList<Object>();
                ArrayList excludes = new ArrayList();
                for (Pattern pattern : config.getModelElements()) {
                    ArrayList<Object> output = pattern.isInclude() ? includes : excludes;
                    Object element = InstrumentationPatternList.convert(pattern, treeInput);
                    if (element == null) continue;
                    output.add(element);
                }
                this.fSelectionControl.setInitialState(includes, excludes);
            } else {
                this.fDefaultMode.setSelection(true);
                this.fViewer.getControl().setEnabled(false);
                this.fSelectionControl.resetState();
            }
            this.fSelectionControl.aboutToOpen();
        }
        finally {
            this.endUpdate();
        }
    }

    protected static Object convert(Pattern pattern, SelectionDialogInput treeInput) {
        if (pattern instanceof ModelElementPattern) {
            return DLTKCore.create((String)((ModelElementPattern)pattern).getHandleIdentifier());
        }
        if (pattern instanceof ContainerPattern) {
            ContainerType containerType = ((ContainerPattern)pattern).getType();
            if (containerType == ContainerType.PACKAGES) {
                return new PackageContainerElement(treeInput);
            }
            if (containerType == ContainerType.SOURCES) {
                return new SourceContainerElement(treeInput);
            }
            return new LibraryContainerElement(treeInput);
        }
        if (pattern instanceof PackagePattern) {
            return new PackageElement(((PackagePattern)pattern).getPackageName());
        }
        if (pattern instanceof SourcePattern) {
            return new SourceElement(((SourcePattern)pattern).getSourcePath());
        }
        return null;
    }

    protected static Pattern unconvert(Object object) {
        if (object instanceof IModelElement) {
            ModelElementPattern pattern = PreferencesFactory.eINSTANCE.createModelElementPattern();
            pattern.setHandleIdentifier(((IModelElement)object).getHandleIdentifier());
            return pattern;
        }
        if (object instanceof PackageElement) {
            PackagePattern pattern = PreferencesFactory.eINSTANCE.createPackagePattern();
            pattern.setPackageName(((PackageElement)object).packageName);
            return pattern;
        }
        if (object instanceof SourceElement) {
            SourcePattern pattern = PreferencesFactory.eINSTANCE.createSourcePattern();
            pattern.setSourcePath(((SourceElement)object).path.toString());
            return pattern;
        }
        if (object instanceof WorkbenchAdaptable) {
            ContainerPattern pattern = PreferencesFactory.eINSTANCE.createContainerPattern();
            pattern.setType(((WorkbenchAdaptable)object).getContainerType());
            return pattern;
        }
        return null;
    }

    public void getValue(InstrumentationConfig configValue) {
        if (this.fSelectionMode.getSelection()) {
            Pattern pattern;
            configValue.setMode(InstrumentationMode.SELECTION);
            final HashSet includes = new HashSet();
            final HashSet excludes = new HashSet();
            this.fSelectionControl.collectCheckedItems(new TreeSelectionControl.ICollector(){

                public void include(Object object) {
                    includes.add(object);
                }

                public void exclude(Object object) {
                    excludes.add(object);
                }
            });
            ProjectSelectionDialogInput treeInput = new ProjectSelectionDialogInput(this.parentProject);
            ArrayList<Pattern> toRemove = new ArrayList<Pattern>();
            for (Pattern pattern2 : configValue.getModelElements()) {
                Object oldItem;
                HashSet input = pattern2.isInclude() ? includes : excludes;
                if (input.remove(oldItem = InstrumentationPatternList.convert(pattern2, treeInput))) continue;
                toRemove.add(pattern2);
            }
            for (Pattern pattern2 : toRemove) {
                configValue.getModelElements().remove((Object)pattern2);
            }
            for (Object include : includes) {
                pattern = InstrumentationPatternList.unconvert(include);
                if (pattern == null) continue;
                pattern.setInclude(true);
                configValue.getModelElements().add((Object)pattern);
            }
            for (Object exclude : excludes) {
                pattern = InstrumentationPatternList.unconvert(exclude);
                if (pattern == null) continue;
                pattern.setInclude(false);
                configValue.getModelElements().add((Object)pattern);
            }
        } else if (this.fSourceModulesMode.getSelection()) {
            configValue.setMode(InstrumentationMode.SOURCES);
            configValue.getModelElements().clear();
        } else {
            configValue.setMode(InstrumentationMode.DEFAULT);
            configValue.getModelElements().clear();
        }
    }
}

