/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.core.internal.board;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.arduino.core.internal.Activator;
import org.eclipse.cdt.arduino.core.internal.ArduinoPreferences;
import org.eclipse.cdt.arduino.core.internal.HierarchicalProperties;
import org.eclipse.cdt.arduino.core.internal.LinkedProperties;
import org.eclipse.cdt.arduino.core.internal.Messages;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoBoard;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoHelp;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoLibrary;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoManager;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoPackage;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoTool;
import org.eclipse.cdt.arduino.core.internal.board.ToolDependency;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public class ArduinoPlatform {
    private String name;
    private String architecture;
    private String version;
    private String category;
    private String url;
    private String archiveFileName;
    private String checksum;
    private String size;
    private List<ArduinoBoard> boards;
    private List<ToolDependency> toolsDependencies;
    private Path installPath;
    private ArduinoPackage pkg;
    private HierarchicalProperties boardsProperties;
    private LinkedProperties platformProperties;
    private HierarchicalProperties programmerProperties;
    private Map<String, String> menus = new HashMap<String, String>();
    private Map<String, ArduinoLibrary> libraries;

    void init(ArduinoPackage pkg) {
        this.pkg = pkg;
        for (ArduinoBoard board : this.boards) {
            if (board == null) continue;
            board.setOwners(this);
        }
    }

    public ArduinoPackage getPackage() {
        return this.pkg;
    }

    public String getName() {
        return this.name;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public String getVersion() {
        return this.version.replace('+', '_');
    }

    public String getCategory() {
        return this.category;
    }

    public String getUrl() {
        return this.url;
    }

    public String getArchiveFileName() {
        return this.archiveFileName;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public String getSize() {
        return this.size;
    }

    public void setPlatformProperties(LinkedProperties platformProperties) {
        this.platformProperties = platformProperties;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ArduinoBoard> getBoards() {
        Iterator<Map.Entry<String, HierarchicalProperties>> iterator;
        LinkedProperties boardProps;
        block18: {
            if (this.boardsProperties != null) return this.boards;
            boardProps = new LinkedProperties();
            if (!Files.exists(this.getInstallPath(), new LinkOption[0])) return this.boards;
            try {
                Throwable throwable = null;
                iterator = null;
                try {
                    FileInputStream is = new FileInputStream(this.getInstallPath().resolve("boards.txt").toFile());
                    try {
                        try (InputStreamReader reader = new InputStreamReader((InputStream)is, "UTF-8");){
                            boardProps.load(reader);
                        }
                        if (is == null) break block18;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (is == null) throw throwable;
                        ((InputStream)is).close();
                        throw throwable;
                    }
                    ((InputStream)is).close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            catch (IOException e) {
                Activator.log(e);
            }
        }
        this.boardsProperties = new HierarchicalProperties(boardProps);
        this.boards = new ArrayList<ArduinoBoard>();
        iterator = this.boardsProperties.getChildren().entrySet().iterator();
        while (true) {
            if (!iterator.hasNext()) break;
            Map.Entry<String, HierarchicalProperties> entry = iterator.next();
            if (entry.getValue().getChild("name") == null) continue;
            this.boards.add(new ArduinoBoard(entry.getKey(), entry.getValue()).setOwners(this));
        }
        HierarchicalProperties menuProp = this.boardsProperties.getChild("menu");
        if (menuProp == null) return this.boards;
        Iterator<Map.Entry<String, HierarchicalProperties>> iterator2 = menuProp.getChildren().entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, HierarchicalProperties> entry = iterator2.next();
            this.menus.put(entry.getKey(), entry.getValue().getValue());
        }
        return this.boards;
    }

    public HierarchicalProperties getBoardsProperties() {
        return this.boardsProperties;
    }

    public ArduinoBoard getBoard(String id) throws CoreException {
        for (ArduinoBoard board : this.getBoards()) {
            if (!id.equals(board.getId())) continue;
            return board;
        }
        return null;
    }

    public ArduinoBoard getBoardByName(String name) throws CoreException {
        for (ArduinoBoard board : this.getBoards()) {
            if (!name.equals(board.getName())) continue;
            return board;
        }
        return null;
    }

    public String getMenuText(String id) {
        return this.menus.get(id);
    }

    public List<ToolDependency> getToolsDependencies() {
        return this.toolsDependencies;
    }

    public ArduinoTool getTool(String name) throws CoreException {
        for (ToolDependency toolDep : this.toolsDependencies) {
            if (!toolDep.getName().equals(name)) continue;
            return toolDep.getTool();
        }
        return null;
    }

    public LinkedProperties getPlatformProperties() throws CoreException {
        if (this.platformProperties == null) {
            this.platformProperties = new LinkedProperties();
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (BufferedReader reader = new BufferedReader(new FileReader(this.getInstallPath().resolve("platform.txt").toFile()));){
                    StringBuilder buffer = new StringBuilder();
                    String line = reader.readLine();
                    while (line != null) {
                        buffer.append(line.replace("\\", "\\\\"));
                        buffer.append('\n');
                        line = reader.readLine();
                    }
                    Throwable throwable2 = null;
                    Object var6_10 = null;
                    try (StringReader reader1 = new StringReader(buffer.toString());){
                        this.platformProperties.load(reader1);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw Activator.coreException(e);
            }
        }
        return this.platformProperties;
    }

    public HierarchicalProperties getProgrammers() throws CoreException {
        block14: {
            if (this.programmerProperties == null) {
                ArduinoPlatform arduinoPlat;
                LinkedProperties props = new LinkedProperties();
                Path programmersTxt = this.getInstallPath().resolve("programmers.txt");
                if (Files.exists(programmersTxt, new LinkOption[0])) {
                    try {
                        Throwable throwable = null;
                        Object var4_7 = null;
                        try (FileInputStream in = new FileInputStream(programmersTxt.toFile());){
                            props.load(in);
                            this.programmerProperties = new HierarchicalProperties(props);
                            break block14;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        throw Activator.coreException(e);
                    }
                }
                ArduinoManager manager = Activator.getService(ArduinoManager.class);
                ArduinoPackage arduinoPkg = manager.getPackage("arduino");
                if (arduinoPkg != null && (arduinoPlat = arduinoPkg.getInstalledPlatform(this.getArchitecture())) != null) {
                    this.programmerProperties = arduinoPlat.getProgrammers();
                }
            }
        }
        return this.programmerProperties;
    }

    public Path getInstallPath() {
        if (this.installPath == null) {
            Path oldPath = this.getPackage().getInstallPath().resolve("hardware").resolve(this.getPackage().getName()).resolve(this.getArchitecture()).resolve(this.getVersion());
            this.installPath = Files.exists(oldPath, new LinkOption[0]) ? oldPath : this.getPackage().getInstallPath().resolve("hardware").resolve(this.getArchitecture()).resolve(this.getVersion());
        }
        return this.installPath;
    }

    private void initLibraries() throws CoreException {
        if (this.libraries == null) {
            File[] libraryDirs;
            this.libraries = new HashMap<String, ArduinoLibrary>();
            if (Files.exists(this.getInstallPath(), new LinkOption[0]) && (libraryDirs = this.getInstallPath().resolve("libraries").toFile().listFiles()) != null) {
                File[] fileArray = libraryDirs;
                int n = libraryDirs.length;
                int n2 = 0;
                while (n2 < n) {
                    File libraryDir = fileArray[n2];
                    Path propsPath = libraryDir.toPath().resolve("library.properties");
                    if (propsPath.toFile().exists()) {
                        ArduinoLibrary lib = new ArduinoLibrary(propsPath, this);
                        this.libraries.put(lib.getName(), lib);
                    }
                    ++n2;
                }
            }
        }
    }

    public synchronized Collection<ArduinoLibrary> getLibraries() throws CoreException {
        this.initLibraries();
        return this.libraries.values();
    }

    public synchronized ArduinoLibrary getLibrary(String name) throws CoreException {
        this.initLibraries();
        return this.libraries != null ? this.libraries.get(name) : null;
    }

    public void install(IProgressMonitor monitor) throws CoreException {
        boolean needMake;
        int work = 1 + this.toolsDependencies.size();
        boolean exists = Files.exists(this.getInstallPath(), new LinkOption[0]);
        if (exists) {
            ++work;
        }
        Path makePath = ArduinoPreferences.getArduinoHome().resolve("make.exe");
        boolean bl = needMake = Platform.getOS().equals("win32") && !Files.exists(makePath, new LinkOption[0]);
        if (needMake) {
            ++work;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)work);
        if (exists) {
            try {
                sub.setTaskName(String.format("Removing old package %s", this.getName()));
                ArduinoManager.recursiveDelete(this.getInstallPath());
                sub.worked(1);
            }
            catch (IOException e) {
                Activator.log(e);
            }
        }
        for (ToolDependency toolDep : this.toolsDependencies) {
            sub.setTaskName(String.format("Installing tool %s", toolDep.getName()));
            toolDep.install(monitor);
            sub.worked(1);
        }
        if (needMake) {
            try {
                sub.setTaskName("Installing make");
                Files.createDirectories(makePath.getParent(), new FileAttribute[0]);
                URL makeUrl = new URL("https://bintray.com/artifact/download/cdtdoug/tools/make.exe");
                Files.copy(makeUrl.openStream(), makePath, new CopyOption[0]);
                makePath.toFile().setExecutable(true, false);
                sub.worked(1);
            }
            catch (IOException e) {
                throw Activator.coreException(e);
            }
        }
        sub.setTaskName(String.format("Downloading and installing %s", this.getName()));
        try {
            ArduinoManager.downloadAndInstall(this.url, this.archiveFileName, this.getInstallPath(), monitor);
        }
        catch (IOException e) {
            throw Activator.coreException(e);
        }
        sub.done();
        this.pkg.platformInstalled(this);
    }

    public IStatus uninstall(IProgressMonitor monitor) {
        try {
            ArduinoManager.recursiveDelete(this.getInstallPath());
            this.pkg.platformUninstalled(this);
            return Status.OK_STATUS;
        }
        catch (IOException e) {
            return new Status(4, Activator.getId(), Messages.ArduinoPlatform_1, (Throwable)e);
        }
    }

    public String toString() {
        return this.name;
    }

    private String fixText(String text) {
        String fixed = text.replaceAll("&", "&amp;");
        fixed = fixed.replaceAll("<", "&gt;");
        fixed = fixed.replaceAll("<", "&lt;");
        return fixed;
    }

    public String toFormText() {
        StringBuilder text = new StringBuilder();
        text.append("<form>");
        text.append(String.format("<p><b>%s: %s</b></p>", "Package", this.getName()));
        text.append(String.format("<p>%s: %s</p>", "Maintainer", this.fixText(this.getPackage().getMaintainer())));
        ArduinoHelp help = this.getPackage().getHelp();
        if (help != null && help.getOnline() != null) {
            text.append(String.format("<p><a href=\"%s\">%s</a></p>", help.getOnline(), "Online help"));
        }
        text.append(String.format("<p>%s:</p>", "Supported boards"));
        for (ArduinoBoard board : this.getBoards()) {
            text.append(String.format("<li>%s</li>", this.fixText(board.getName())));
        }
        text.append("</form>");
        return text.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.pkg == null ? 0 : this.pkg.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArduinoPlatform other = (ArduinoPlatform)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.pkg == null ? other.pkg != null : !this.pkg.equals(other.pkg)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }
}

