/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.editparts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpel.ui.editparts.BPELEditPart;
import org.eclipse.bpel.ui.editparts.SequenceEditPart;
import org.eclipse.bpel.ui.editparts.borders.PickBorder;
import org.eclipse.bpel.ui.editparts.figures.CollapsablePickContainerFigure;
import org.eclipse.bpel.ui.editparts.policies.BPELOrderedLayoutEditPolicy;
import org.eclipse.bpel.ui.figures.CenteredConnectionAnchor;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.gef.EditPolicy;

public class PickEditPart
extends SequenceEditPart {
    @Override
    protected void createEditPolicies() {
        if (ModelHelper.isHorizontalLayout(this.getModel())) {
            this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new PickOrderedLayoutEditPolicy());
        } else {
            super.createEditPolicies();
        }
    }

    @Override
    protected void configureExpandedFigure(IFigure figure) {
        super.configureExpandedFigure(figure);
        boolean horizontal = ModelHelper.isHorizontalLayout(this.getModel());
        FlowLayout layout = (FlowLayout)figure.getLayoutManager();
        layout.setHorizontal(!horizontal);
        layout.setMinorAlignment(1);
        layout.setStretchMinorAxis(true);
        ((PickBorder)figure.getBorder()).setHorizontal(horizontal);
    }

    @Override
    protected IFigure getNewContentPane(Layer layer) {
        CollapsablePickContainerFigure fig = new CollapsablePickContainerFigure(this.getModel(), this.image, this.getLabel());
        fig.addMouseMotionListener(this.getMouseMotionListener());
        fig.setEditPart(this);
        return fig;
    }

    @Override
    public ConnectionAnchor getConnectionAnchor(int location) {
        if (location == 2) {
            return new CenteredConnectionAnchor(this.getContentPane(), 6, 0);
        }
        return super.getConnectionAnchor(location);
    }

    @Override
    public void switchLayout(boolean horizontal) {
        this.removeEditPolicy("LayoutEditPolicy");
        BPELOrderedLayoutEditPolicy newPolicy = null;
        newPolicy = horizontal ? new PickOrderedLayoutEditPolicy() : new BPELOrderedLayoutEditPolicy();
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)newPolicy);
        ((FlowLayout)this.contentFigure.getLayoutManager()).setHorizontal(!horizontal);
        ((PickBorder)this.contentFigure.getBorder()).setHorizontal(horizontal);
    }

    private class PickOrderedLayoutEditPolicy
    extends BPELOrderedLayoutEditPolicy {
        private PickOrderedLayoutEditPolicy() {
        }

        protected ArrayList createVerticalConnections(BPELEditPart parent) {
            ArrayList<PolylineConnection> connections = new ArrayList<PolylineConnection>();
            List<BPELEditPart> children = this.getConnectionChildren(parent);
            BPELEditPart sourcePart = parent;
            ConnectionAnchor sourceAnchor = sourcePart.getConnectionAnchor(2);
            if (children != null) {
                int i = 0;
                while (i < children.size()) {
                    BPELEditPart targetPart = children.get(i);
                    ConnectionAnchor targetAnchor = targetPart.getConnectionAnchor(2);
                    connections.add(this.createConnection(sourceAnchor, targetAnchor, this.arrowColor));
                    ++i;
                }
            }
            return connections;
        }
    }
}

