/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XNIException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.ITextContentDescriber;
import org.xml.sax.InputSource;

public class BPELContentDescriber
implements ITextContentDescriber {
    private static final String WSBPEL_2_NAMESPACE = "http://docs.oasis-open.org/wsbpel/2.0/process/executable";
    private static final String WSBPEL_2_ABSTRACT_NAMESPACE = "http://docs.oasis-open.org/wsbpel/2.0/process/abstract";
    private static final String ROOT_ELEMENT = "process";
    private RootElementParser parser;

    public int describe(Reader contents, IContentDescription description) throws IOException {
        return this.doDescribe(contents) == null ? 0 : 2;
    }

    public int describe(InputStream contents, IContentDescription description) throws IOException {
        return this.describe(new InputStreamReader(contents), description);
    }

    /*
     * Loose catch block
     */
    private synchronized String doDescribe(Reader contents) throws IOException {
        try {
            try {
                InputSource source = new InputSource(contents);
                this.parser = new RootElementParser();
                this.parser.parse(source);
            }
            catch (AcceptedException e) {
                String string = e.acceptedRootElement;
                this.parser = null;
                return string;
            }
            catch (RejectedException rejectedException) {
                this.parser = null;
                return null;
            }
            catch (Exception exception) {
                this.parser = null;
                return null;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        finally {
            this.parser = null;
        }
        return null;
    }

    public QualifiedName[] getSupportedOptions() {
        return null;
    }

    private class AcceptedException
    extends RuntimeException {
        public String acceptedRootElement;
        private static final long serialVersionUID = 1L;

        public AcceptedException(String acceptedRootElement) {
            this.acceptedRootElement = acceptedRootElement;
        }
    }

    private class RejectedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private RejectedException() {
        }
    }

    private class RootElementParser
    extends SAXParser {
        private RootElementParser() {
        }

        public void startElement(QName qName, XMLAttributes attributes, Augmentations augmentations) throws XNIException {
            super.startElement(qName, attributes, augmentations);
            if (BPELContentDescriber.ROOT_ELEMENT.equals(qName.localpart)) {
                String namespace = this.fNamespaceContext.getURI(qName.prefix);
                if (BPELContentDescriber.WSBPEL_2_NAMESPACE.equals(namespace) || BPELContentDescriber.WSBPEL_2_ABSTRACT_NAMESPACE.equals(namespace)) {
                    throw new AcceptedException(qName.localpart);
                }
                throw new RejectedException();
            }
            throw new RejectedException();
        }
    }
}

