/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.PrototypeObjectType;
import com.google.javascript.rhino.jstype.RecordTypeBuilder;
import com.google.javascript.rhino.jstype.UnionTypeBuilder;
import java.util.Map;

public class RecordType
extends PrototypeObjectType {
    private static final long serialVersionUID = 1L;
    private final boolean declared;
    private boolean isFrozen = false;

    RecordType(JSTypeRegistry registry, Map<String, RecordTypeBuilder.RecordProperty> properties) {
        this(registry, properties, true);
    }

    RecordType(JSTypeRegistry registry, Map<String, RecordTypeBuilder.RecordProperty> properties, boolean declared) {
        super(registry, null, null);
        this.setPrettyPrint(true);
        this.declared = declared;
        for (String property : properties.keySet()) {
            RecordTypeBuilder.RecordProperty prop = properties.get(property);
            if (prop == null) {
                throw new IllegalStateException("RecordProperty associated with a property should not be null!");
            }
            if (declared) {
                this.defineDeclaredProperty(property, prop.getType(), prop.getPropertyNode());
                continue;
            }
            this.defineSynthesizedProperty(property, prop.getType(), prop.getPropertyNode());
        }
        this.isFrozen = true;
    }

    boolean isSynthetic() {
        return !this.declared;
    }

    @Override
    public ObjectType getImplicitPrototype() {
        return this.registry.getNativeObjectType(JSTypeNative.OBJECT_TYPE);
    }

    @Override
    boolean defineProperty(String propertyName, JSType type, boolean inferred, Node propertyNode) {
        if (this.isFrozen) {
            return false;
        }
        return super.defineProperty(propertyName, type, inferred, propertyNode);
    }

    JSType getGreatestSubtypeHelper(JSType that) {
        if (that.isRecordType()) {
            RecordType thatRecord = that.toMaybeRecordType();
            RecordTypeBuilder builder = new RecordTypeBuilder(this.registry);
            builder.setSynthesized(true);
            ObjectType noType = this.registry.getNativeObjectType(JSTypeNative.NO_TYPE);
            for (String property : this.getOwnPropertyNames()) {
                JSType thisPropertyType = this.getPropertyType(property);
                JSType propType = null;
                if (thatRecord.hasProperty(property)) {
                    JSType thatPropertyType = thatRecord.getPropertyType(property);
                    propType = thisPropertyType.getGreatestSubtype(thatPropertyType);
                    if (propType.isEquivalentTo(noType)) {
                        return noType;
                    }
                } else {
                    propType = thisPropertyType;
                }
                builder.addProperty(property, propType, this.getPropertyNode(property));
            }
            for (String property : thatRecord.getOwnPropertyNames()) {
                if (this.hasProperty(property)) continue;
                builder.addProperty(property, thatRecord.getPropertyType(property), thatRecord.getPropertyNode(property));
            }
            return builder.build();
        }
        JSType greatestSubtype = this.registry.getNativeType(JSTypeNative.NO_OBJECT_TYPE);
        JSType thatRestrictedToObj = this.registry.getNativeType(JSTypeNative.OBJECT_TYPE).getGreatestSubtype(that);
        if (!thatRestrictedToObj.isEmptyType()) {
            for (String propName : this.getOwnPropertyNames()) {
                JSType propType = this.getPropertyType(propName);
                UnionTypeBuilder builder = new UnionTypeBuilder(this.registry);
                for (ObjectType alt : this.registry.getEachReferenceTypeWithProperty(propName)) {
                    JSType altPropType = alt.getPropertyType(propName);
                    if (altPropType == null || alt.isEquivalentTo(this) || !alt.isSubtype(that) || !altPropType.isSubtype(propType)) continue;
                    builder.addAlternate(alt);
                }
                greatestSubtype = greatestSubtype.getLeastSupertype(builder.build());
            }
        }
        return greatestSubtype;
    }

    @Override
    public RecordType toMaybeRecordType() {
        return this;
    }

    @Override
    public boolean isStructuralType() {
        return true;
    }

    @Override
    public boolean isSubtype(JSType that) {
        return this.isSubtype(that, JSType.ImplCache.create());
    }

    @Override
    protected boolean isSubtype(JSType that, JSType.ImplCache implicitImplCache) {
        if (JSType.isSubtypeHelper(this, that, implicitImplCache)) {
            return true;
        }
        if (this.registry.getNativeObjectType(JSTypeNative.OBJECT_TYPE).isSubtype(that, implicitImplCache)) {
            return true;
        }
        if (!that.isRecordType()) {
            return false;
        }
        return this.isStructuralSubtype(that.toMaybeRecordType(), implicitImplCache);
    }
}

