/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation.join;

import java.util.List;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.federated.algebra.CheckStatementPattern;
import org.eclipse.rdf4j.federated.evaluation.FederationEvalStrategy;
import org.eclipse.rdf4j.federated.evaluation.concurrent.ParallelExecutor;
import org.eclipse.rdf4j.federated.evaluation.concurrent.ParallelTaskBase;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;

public class ParallelCheckJoinTask
extends ParallelTaskBase<BindingSet> {
    protected final FederationEvalStrategy strategy;
    protected final CheckStatementPattern expr;
    protected final List<BindingSet> bindings;
    protected final ParallelExecutor<BindingSet> joinControl;

    public ParallelCheckJoinTask(ParallelExecutor<BindingSet> joinControl, FederationEvalStrategy strategy, CheckStatementPattern expr, List<BindingSet> bindings) {
        this.strategy = strategy;
        this.expr = expr;
        this.bindings = bindings;
        this.joinControl = joinControl;
    }

    @Override
    protected CloseableIteration<BindingSet, QueryEvaluationException> performTaskInternal() throws Exception {
        return this.strategy.evaluateGroupedCheck(this.expr, this.bindings);
    }

    @Override
    public ParallelExecutor<BindingSet> getControl() {
        return this.joinControl;
    }
}

