/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.sherlock.core.info;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.rcptt.sherlock.core.SherlockCore;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.Preferences;

public class EclipseInfoProvider {
    private static final String PROPERTY_ECLIPSE_BUILD_ID = "eclipse.buildId";
    private static final String PROPERTY_ECLIPSE_START_TIME = "eclipse.startTime";

    public static String getWorkspaceLocation() {
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IPath path = root.getLocation();
            if (path != null) {
                return path.toFile().getAbsolutePath();
            }
            URI uri = root.getLocationURI();
            if (uri != null) {
                return uri.toString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static String getProductId() {
        IProduct product = Platform.getProduct();
        return product != null ? product.getId() : null;
    }

    public static String getApplicationId() {
        IProduct product = Platform.getProduct();
        return product != null ? product.getApplication() : null;
    }

    public static String[] getApplicationArgs() {
        return Platform.getApplicationArgs();
    }

    public static String getBuildId() {
        return System.getProperty(PROPERTY_ECLIPSE_BUILD_ID);
    }

    public static long getUptime() {
        return System.currentTimeMillis() - Long.parseLong(System.getProperty(PROPERTY_ECLIPSE_START_TIME));
    }

    public static List<Bundle> getPlugins() {
        return Arrays.asList(SherlockCore.getDefault().getBundle().getBundleContext().getBundles());
    }

    public static List<IBundleGroup> getFeatures() {
        ArrayList<IBundleGroup> features = new ArrayList<IBundleGroup>();
        IBundleGroupProvider[] iBundleGroupProviderArray = Platform.getBundleGroupProviders();
        int n = iBundleGroupProviderArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBundleGroupProvider provider = iBundleGroupProviderArray[n2];
            IBundleGroup[] iBundleGroupArray = provider.getBundleGroups();
            int n3 = iBundleGroupArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IBundleGroup group = iBundleGroupArray[n4];
                features.add(group);
                ++n4;
            }
            ++n2;
        }
        return features;
    }

    public static Preferences getPreferencesRoot() {
        IPreferencesService service = Platform.getPreferencesService();
        return service.getRootNode();
    }
}

