/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.parser;

import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.rcptt.ecl.core.Block;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.core.ExecutableParameter;
import org.eclipse.rcptt.ecl.core.Parameter;
import org.eclipse.rcptt.ecl.core.util.ScriptletFactory;
import org.eclipse.rcptt.ecl.gen.ast.AstExec;
import org.eclipse.rcptt.ecl.gen.ast.AstLiteral;
import org.eclipse.rcptt.ecl.internal.parser.EclLexer;
import org.eclipse.rcptt.ecl.internal.parser.EclParser;
import org.eclipse.rcptt.ecl.internal.parser.EclParserPlugin;
import org.eclipse.rcptt.ecl.internal.parser.SyntaxErrorException;
import org.eclipse.rcptt.ecl.parser.ScriptErrorStatus;

public class EclCoreParser {
    public static Command newCommand(String content) throws CoreException {
        return EclCoreParser.newCommand(content, null);
    }

    public static Command newCommand(String content, String resource) throws CoreException {
        return EclCoreParser.newCommand(content, resource, 1, 1);
    }

    public static Command newCommand(String content, String resource, int line, int pos) throws CoreException {
        if (content == null || content.trim().length() == 0) {
            return ScriptletFactory.makeSeq((Command[])new Command[0]);
        }
        ANTLRStringStream input = new ANTLRStringStream(content);
        input.setLine(line);
        input.setCharPositionInLine(pos - 1);
        EclLexer lexer = new EclLexer((CharStream)input);
        CommonTokenStream stream = new CommonTokenStream((TokenSource)lexer);
        EclParser parser = new EclParser((TokenStream)stream);
        try {
            return EclCoreParser.setResource(parser.commands(), resource);
        }
        catch (RecognitionException e) {
            throw EclCoreParser.emitErr(resource, e.line, e.charPositionInLine, 1, e);
        }
        catch (SyntaxErrorException e) {
            throw EclCoreParser.emitErr(resource, e.line, e.col, 1, e);
        }
        catch (Throwable t) {
            EclParserPlugin.logErr(t.getMessage(), t);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.ecl.parser", "Parse error"));
        }
    }

    public static Command newCommand(String content, int line, int pos) throws CoreException {
        return EclCoreParser.newCommand(content, null, line, pos);
    }

    private static Command setResource(Command cmd, String id) {
        block5: {
            block4: {
                if (id == null) {
                    return cmd;
                }
                if (!(cmd instanceof AstExec)) break block4;
                ((AstExec)cmd).setResourceID(id);
                EList parameters = ((AstExec)cmd).getParameters();
                for (Parameter param : parameters) {
                    if (param instanceof AstLiteral) {
                        ((AstLiteral)param).setResourceID(id);
                        continue;
                    }
                    if (!(param instanceof ExecutableParameter)) continue;
                    Command cmdParam = ((ExecutableParameter)param).getCommand();
                    EclCoreParser.setResource(cmdParam, id);
                }
                break block5;
            }
            if (!(cmd instanceof Block)) break block5;
            EList commands = ((Block)cmd).getCommands();
            for (Command command : commands) {
                EclCoreParser.setResource(command, id);
            }
        }
        return cmd;
    }

    private static CoreException emitErr(String resource, int line, int pos, int len, Throwable e) throws CoreException {
        ScriptErrorStatus status = new ScriptErrorStatus("org.eclipse.rcptt.ecl.parser", "Syntax error", resource, line, pos, len);
        status.add(EclParserPlugin.createStatus(e));
        return new CoreException((IStatus)status);
    }
}

