/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.wizards.plain;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.rcptt.ui.commons.SWTFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public abstract class DestinationsBox {
    private DataBindingContext dbc;
    private WritableValue<Selection> fsSelected = new WritableValue((Object)Selection.Clipboard, Selection.class);
    private WritableValue<String> filesystemPathValue = new WritableValue((Object)"", String.class);
    private Shell shell;

    public DestinationsBox(DataBindingContext dbc) {
        this.dbc = dbc;
    }

    public Composite create(Composite tab) {
        this.shell = tab.getShell();
        Composite cp = new Composite(tab, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(cp);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)cp);
        Button clipboardRadio = new Button(cp, 16);
        clipboardRadio.setText(this.getClipboardTitle());
        clipboardRadio.setSelection(true);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)clipboardRadio);
        Button filesystemRadio = new Button(cp, 16);
        filesystemRadio.setText(this.getFileTitle());
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)filesystemRadio);
        Text filesystemPath = new Text(cp, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)filesystemPath);
        Button browseFilesystem = new Button(cp, 8);
        browseFilesystem.setText("Browse...");
        browseFilesystem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DestinationsBox.this.handleBrowseFilesystem();
            }
        });
        GridDataFactory.swtDefaults().applyTo((Control)browseFilesystem);
        SWTFactory.setButtonDimensionHint(browseFilesystem);
        this.dbc.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)filesystemRadio), this.fsSelected, (UpdateValueStrategy)new SelectionToModel(Selection.Filesystem), (UpdateValueStrategy)new ModelToSelection(Selection.Filesystem));
        this.dbc.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)clipboardRadio), this.fsSelected, (UpdateValueStrategy)new SelectionToModel(Selection.Clipboard), (UpdateValueStrategy)new ModelToSelection(Selection.Clipboard));
        this.dbc.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)browseFilesystem), this.fsSelected, (UpdateValueStrategy)new SelectionToModel(Selection.Filesystem), (UpdateValueStrategy)new ModelToSelection(Selection.Filesystem));
        this.dbc.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)filesystemPath), this.fsSelected, (UpdateValueStrategy)new SelectionToModel(Selection.Filesystem), (UpdateValueStrategy)new ModelToSelection(Selection.Filesystem));
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)filesystemPath), this.filesystemPathValue);
        return cp;
    }

    protected abstract String getFileTitle();

    protected abstract String getClipboardTitle();

    protected void handleBrowseFilesystem() {
        FileDialog fileDialog = new FileDialog(this.shell, this.getFileKind());
        fileDialog.setFilterExtensions(new String[]{"*.test", "*.*"});
        fileDialog.setFilterNames(new String[]{"RCPTT Testcase", "All files"});
        fileDialog.setFilterPath(new Path((String)this.filesystemPathValue.getValue()).removeLastSegments(1).toOSString());
        String fileName = fileDialog.open();
        if (fileName != null) {
            this.filesystemPathValue.setValue((Object)fileName);
        }
    }

    protected abstract int getFileKind();

    public void addChangeListener(final Runnable runnable) {
        IChangeListener listener = new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                DestinationsBox.this.shell.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        runnable.run();
                    }
                });
            }
        };
        this.fsSelected.addChangeListener(listener);
        this.filesystemPathValue.addChangeListener(listener);
    }

    public Selection getKind() {
        return (Selection)((Object)this.fsSelected.getValue());
    }

    public String getFileSystemPath() {
        return (String)this.filesystemPathValue.getValue();
    }

    private final class ModelToSelection
    extends UpdateValueStrategy<Selection, Boolean> {
        private Selection sel;

        public ModelToSelection(Selection sel) {
            this.sel = sel;
        }

        public Boolean convert(Selection value) {
            if (this.sel.equals((Object)value)) {
                return true;
            }
            return false;
        }
    }

    static enum Selection {
        Filesystem,
        Clipboard;

    }

    private final class SelectionToModel
    extends UpdateValueStrategy<Boolean, Selection> {
        private Selection sel;

        public SelectionToModel(Selection sel) {
            this.sel = sel;
        }

        public Selection convert(Boolean value) {
            return this.sel;
        }
    }
}

