/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.reporting.util;

import java.io.Closeable;
import java.io.File;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.reporting.Q7Info;
import org.eclipse.rcptt.reporting.core.ReportHelper;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Node;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Report;
import org.eclipse.rcptt.sherlock.core.streams.SherlockReportIterator;

public class Q7ReportIterator
implements Iterable<Report>,
Closeable {
    private final SherlockReportIterator sherlock;

    public Q7ReportIterator(File file) {
        this.sherlock = new SherlockReportIterator(file);
    }

    @Override
    public Iterator<Report> iterator() {
        this.sherlock.reset();
        return new Iterator<Report>(){

            @Override
            public boolean hasNext() {
                return Q7ReportIterator.this.sherlock.hasNext();
            }

            @Override
            public Report next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Report rv = Q7ReportIterator.this.sherlock.next();
                if (rv == null) {
                    return null;
                }
                Q7Info info = ReportHelper.getInfo((Node)rv.getRoot());
                if (info.getResult() == null) {
                    info.setResult(RcpttPlugin.createProcessStatus((int)4, (String)"Empty result"));
                }
                return rv;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void close() {
        this.sherlock.close();
    }

    public File getReportFile() {
        return this.sherlock.getReportFile();
    }
}

