/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.search;

import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.search.Matcher;

public class NamedMatcher
implements Matcher {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean matches(IQ7NamedElement object, String query, SubMonitor monitor) {
        try {
            String[] tags;
            String name = Q7SearchCore.findNameByDocument((IQ7Element)object);
            if (name == null) {
                name = object.getElementName();
            }
            if (name != null && name.toLowerCase().contains(query)) {
                return true;
            }
            if (object.getDescription() != null && object.getDescription().toLowerCase().contains(query)) {
                return true;
            }
            String[] stringArray = tags = Q7SearchCore.findTagsByDocument((IQ7Element)object);
            int n = tags.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                String t = stringArray[n2];
                if (t.toLowerCase().contains(query)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (ModelException e) {
            Q7UIPlugin.log(e);
        }
        return false;
    }
}

