/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.patch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.compare.internal.core.Messages;
import org.eclipse.compare.internal.core.patch.DiffProject;
import org.eclipse.compare.internal.core.patch.FilePatch2;
import org.eclipse.compare.internal.core.patch.Hunk;
import org.eclipse.compare.internal.core.patch.PatchReader;
import org.eclipse.compare.internal.patch.LineReader;
import org.eclipse.compare.internal.patch.Patcher;
import org.eclipse.compare.internal.patch.Utilities;
import org.eclipse.compare.patch.IHunk;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;

public class WorkspacePatcher
extends Patcher {
    private DiffProject[] fDiffProjects;
    private boolean fIsWorkspacePatch = false;
    private boolean fIsGitPatch = false;
    private final Map<Object, IPath> retargetedDiffs = new HashMap<Object, IPath>();

    public WorkspacePatcher() {
    }

    public WorkspacePatcher(IResource target) {
        this.setTarget(target);
    }

    @Override
    protected void patchParsed(PatchReader patchReader) {
        super.patchParsed(patchReader);
        this.fDiffProjects = patchReader.getDiffProjects();
        this.fIsWorkspacePatch = patchReader.isWorkspacePatch();
        this.fIsGitPatch = patchReader.isGitPatch() && this.calculateStripGitPrefixSegments() > -1;
    }

    public DiffProject[] getDiffProjects() {
        return this.fDiffProjects;
    }

    public boolean isWorkspacePatch() {
        return this.fIsWorkspacePatch;
    }

    public boolean isGitPatch() {
        return this.fIsGitPatch;
    }

    @Override
    public void applyAll(IProgressMonitor pm, Patcher.IFileValidator validator) throws CoreException {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        if (!this.fIsWorkspacePatch) {
            super.applyAll(pm, validator);
        } else {
            ArrayList<IFile> list = new ArrayList<IFile>();
            DiffProject[] diffProjectArray = this.fDiffProjects;
            int n = this.fDiffProjects.length;
            int n2 = 0;
            while (n2 < n) {
                DiffProject diffProject = diffProjectArray[n2];
                if (Utilities.getProject(diffProject).isAccessible()) {
                    list.addAll(Arrays.asList(this.getTargetFiles(diffProject)));
                }
                ++n2;
            }
            if (!validator.validateResources(list.toArray(new IFile[list.size()]))) {
                return;
            }
            FilePatch2[] diffs = this.getDiffs();
            if (pm != null) {
                String message = Messages.WorkspacePatcher_0;
                pm.beginTask(message, diffs.length * 10);
            }
            FilePatch2[] filePatch2Array = diffs;
            int n3 = diffs.length;
            n = 0;
            while (n < n3) {
                FilePatch2 diff = filePatch2Array[n];
                int workTicks = 10;
                if (this.isAccessible(diff)) {
                    IFile file = this.getTargetFile(diff);
                    IPath path = file.getProjectRelativePath();
                    if (pm != null) {
                        pm.subTask(path.toString());
                    }
                    this.createPath((IContainer)file.getProject(), path);
                    ArrayList<Hunk> failed = new ArrayList<Hunk>();
                    int type = diff.getDiffType(this.isReversed());
                    switch (type) {
                        case 1: {
                            List<String> result = this.apply(diff, file, true, failed);
                            if (result != null) {
                                this.store(LineReader.createString(this.isPreserveLineDelimeters(), result), file, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)pm, (int)workTicks));
                            }
                            workTicks -= 10;
                            break;
                        }
                        case 2: {
                            file.delete(true, true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)pm, (int)workTicks));
                            workTicks -= 10;
                            break;
                        }
                        case 3: {
                            List<String> result = this.apply(diff, file, false, failed);
                            if (result != null) {
                                this.store(LineReader.createString(this.isPreserveLineDelimeters(), result), file, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)pm, (int)workTicks));
                            }
                            workTicks -= 10;
                        }
                    }
                    if (this.isGenerateRejectFile() && failed.size() > 0) {
                        IPath pp = null;
                        if (path.segmentCount() > 1) {
                            pp = path.removeLastSegments(1);
                            pp = pp.append(String.valueOf(path.lastSegment()) + ".rej");
                        } else {
                            pp = new Path(String.valueOf(path.lastSegment()) + ".rej");
                        }
                        file = this.createPath((IContainer)file.getProject(), pp);
                        if (file != null) {
                            this.store(WorkspacePatcher.getRejected(failed), file, pm);
                            try {
                                IMarker marker = file.createMarker("org.eclipse.compare.rejectedPatchMarker");
                                marker.setAttribute("message", (Object)Messages.WorkspacePatcher_1);
                                marker.setAttribute("priority", 2);
                            }
                            catch (CoreException coreException) {}
                        }
                    }
                }
                if (pm != null) {
                    if (pm.isCanceled()) break;
                    if (workTicks > 0) {
                        pm.worked(workTicks);
                    }
                }
                ++n;
            }
        }
    }

    private boolean isAccessible(FilePatch2 diff) {
        return this.isEnabled(diff) && Utilities.getProject(diff.getProject()).isAccessible();
    }

    public IFile[] getTargetFiles(DiffProject project) {
        FilePatch2[] diffs;
        ArrayList<IFile> files = new ArrayList<IFile>();
        FilePatch2[] filePatch2Array = diffs = project.getFileDiffs();
        int n = diffs.length;
        int n2 = 0;
        while (n2 < n) {
            FilePatch2 diff = filePatch2Array[n2];
            if (this.isEnabled(diff)) {
                files.add(this.getTargetFile(diff));
            }
            ++n2;
        }
        return files.toArray(new IFile[files.size()]);
    }

    @Override
    public IFile getTargetFile(FilePatch2 diff) {
        IPath path = diff.getStrippedPath(this.getStripPrefixSegments(), this.isReversed());
        DiffProject project = this.getProject(diff);
        if (project != null) {
            return Utilities.getProject(project).getFile(path);
        }
        return super.getTargetFile(diff);
    }

    private IPath getFullPath(FilePatch2 diff) {
        IPath path = diff.getStrippedPath(this.getStripPrefixSegments(), this.isReversed());
        DiffProject project = this.getProject(diff);
        if (project != null) {
            return Utilities.getProject(project).getFile(path).getFullPath();
        }
        return this.getTarget().getFullPath().append(path);
    }

    public ISchedulingRule[] getTargetProjects() {
        ArrayList<MultiRule> projects = new ArrayList<MultiRule>();
        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        DiffProject[] diffProjectArray = this.fDiffProjects;
        int n = this.fDiffProjects.length;
        int n2 = 0;
        while (n2 < n) {
            DiffProject diffProject = diffProjectArray[n2];
            IProject tempProject = Utilities.getProject(diffProject);
            ISchedulingRule scheduleRule = ruleFactory.modifyRule((IResource)tempProject.getFile(".project"));
            MultiRule multiRule = new MultiRule(new ISchedulingRule[]{scheduleRule, tempProject});
            projects.add(multiRule);
            ++n2;
        }
        return projects.toArray(new ISchedulingRule[projects.size()]);
    }

    public void setDiffProjects(DiffProject[] newProjectArray) {
        this.fDiffProjects = new DiffProject[newProjectArray.length];
        System.arraycopy(newProjectArray, 0, this.fDiffProjects, 0, newProjectArray.length);
    }

    public void removeProject(DiffProject project) {
        DiffProject[] temp = new DiffProject[this.fDiffProjects.length - 1];
        int counter = 0;
        DiffProject[] diffProjectArray = this.fDiffProjects;
        int n = this.fDiffProjects.length;
        int n2 = 0;
        while (n2 < n) {
            DiffProject diffProject = diffProjectArray[n2];
            if (diffProject != project) {
                temp[counter++] = diffProject;
            }
            ++n2;
        }
        this.fDiffProjects = temp;
    }

    @Override
    protected Object getElementParent(Object element) {
        if (element instanceof FilePatch2 && this.fDiffProjects != null) {
            FilePatch2 diff = (FilePatch2)element;
            DiffProject[] diffProjectArray = this.fDiffProjects;
            int n = this.fDiffProjects.length;
            int n2 = 0;
            while (n2 < n) {
                DiffProject project = diffProjectArray[n2];
                if (project.contains(diff)) {
                    return project;
                }
                ++n2;
            }
        }
        return null;
    }

    public boolean isRetargeted(Object object) {
        return this.retargetedDiffs.containsKey(object);
    }

    public IPath getOriginalPath(Object object) {
        return this.retargetedDiffs.get(object);
    }

    public void retargetDiff(FilePatch2 diff, IFile file) {
        this.retargetedDiffs.put(diff, diff.getPath(false));
        IHunk[] hunks = diff.getHunks();
        if (this.isWorkspacePatch()) {
            diff.getProject().remove(diff);
        }
        this.removeDiff(diff);
        FilePatch2 newDiff = this.getDiffForFile(file);
        IHunk[] iHunkArray = hunks;
        int n = hunks.length;
        int n2 = 0;
        while (n2 < n) {
            IHunk h = iHunkArray[n2];
            Hunk hunk = (Hunk)h;
            newDiff.add(hunk);
            ++n2;
        }
    }

    private FilePatch2 getDiffForFile(IFile file) {
        FilePatch2[] diffsToCheck;
        DiffProject diffProject = null;
        if (this.isWorkspacePatch()) {
            DiffProject[] diffProjects;
            IProject project = file.getProject();
            DiffProject[] diffProjectArray = diffProjects = this.getDiffProjects();
            int n = diffProjects.length;
            int n2 = 0;
            while (n2 < n) {
                DiffProject d = diffProjectArray[n2];
                if (Utilities.getProject(d).equals((Object)project)) {
                    diffProject = d;
                    break;
                }
                ++n2;
            }
            if (diffProject == null) {
                diffProject = this.addDiffProjectForProject(project);
            }
            diffsToCheck = diffProject.getFileDiffs();
        } else {
            diffsToCheck = this.getDiffs();
        }
        FilePatch2[] filePatch2Array = diffsToCheck;
        int n = diffsToCheck.length;
        int diffProjects = 0;
        while (diffProjects < n) {
            FilePatch2 fileDiff = filePatch2Array[diffProjects];
            if (this.isDiffForFile(fileDiff, file)) {
                return fileDiff;
            }
            ++diffProjects;
        }
        IPath path = this.getDiffPath(file);
        FilePatch2 newDiff = new FilePatch2(path, 0L, path, 0L);
        if (diffProject != null) {
            diffProject.add(newDiff);
        }
        this.addDiff(newDiff);
        return newDiff;
    }

    private IPath getDiffPath(IFile file) {
        DiffProject project = this.getDiffProject(file.getProject());
        if (project != null) {
            return file.getProjectRelativePath();
        }
        return file.getFullPath().removeFirstSegments(this.getTarget().getFullPath().segmentCount());
    }

    private boolean isDiffForFile(FilePatch2 fileDiff, IFile file) {
        return this.getFullPath(fileDiff).equals((Object)file.getFullPath());
    }

    private DiffProject addDiffProjectForProject(IProject project) {
        DiffProject[] diffProjects = this.getDiffProjects();
        DiffProject diffProject = new DiffProject(project.getName());
        DiffProject[] newProjectArray = new DiffProject[diffProjects.length + 1];
        System.arraycopy(diffProjects, 0, newProjectArray, 0, diffProjects.length);
        newProjectArray[diffProjects.length] = diffProject;
        this.setDiffProjects(newProjectArray);
        return diffProject;
    }

    public void retargetHunk(Hunk hunk, IFile file) {
        FilePatch2 newDiff = this.getDiffForFile(file);
        newDiff.add(hunk);
    }

    public void retargetProject(DiffProject project, IProject targetProject) {
        this.retargetedDiffs.put(project, Utilities.getProject(project).getFullPath());
        FilePatch2[] diffs = project.getFileDiffs();
        DiffProject selectedProject = this.getDiffProject(targetProject);
        if (selectedProject == null) {
            selectedProject = this.addDiffProjectForProject(targetProject);
        }
        FilePatch2[] filePatch2Array = diffs;
        int n = diffs.length;
        int n2 = 0;
        while (n2 < n) {
            FilePatch2 diff = filePatch2Array[n2];
            selectedProject.add(diff);
            ++n2;
        }
        this.removeProject(project);
    }

    private DiffProject getDiffProject(IProject project) {
        DiffProject[] projects;
        if (!this.isWorkspacePatch()) {
            return null;
        }
        DiffProject[] diffProjectArray = projects = this.getDiffProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            DiffProject p = diffProjectArray[n2];
            if (Utilities.getProject(p).equals((Object)project)) {
                return p;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public int getStripPrefixSegments() {
        if (this.isWorkspacePatch()) {
            return 0;
        }
        return super.getStripPrefixSegments();
    }

    int calculateStripGitPrefixSegments() {
        FilePatch2[] diffs = this.getDiffs();
        if (diffs.length == 0) {
            return -1;
        }
        int skip = -1;
        FilePatch2[] filePatch2Array = diffs;
        int n = diffs.length;
        int n2 = 0;
        while (n2 < n) {
            IPath newPath;
            FilePatch2 diff = filePatch2Array[n2];
            IPath oldPath = diff.getPath(false);
            if (this.checkFirstSegments(new IPath[]{oldPath, newPath = diff.getPath(true)}, new String[][]{{"a", "b"}, {"b", "b"}, {"a", "a"}}) && oldPath.segmentCount() > 2 && newPath.segmentCount() > 2) {
                int j = 1;
                while (j < Math.min(oldPath.segmentCount(), newPath.segmentCount())) {
                    if (this.projectExists(oldPath.segment(j)) || this.projectExists(newPath.segment(j))) {
                        if (skip == -1) {
                            skip = j;
                        } else if (skip != j) {
                            return -1;
                        }
                        break;
                    }
                    ++j;
                }
            } else {
                return -1;
            }
            ++n2;
        }
        return skip;
    }

    private boolean checkFirstSegments(IPath[] paths, String[][] segments) {
        String[][] stringArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            block3: {
                String[] segment = stringArray[n2];
                int j = 0;
                while (j < paths.length) {
                    if (paths[j].segment(0).equals(segment[j])) {
                        ++j;
                        continue;
                    }
                    break block3;
                }
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean projectExists(String name) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(name).exists();
    }
}

