/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.product;

import java.util.Arrays;
import java.util.Objects;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.iproduct.IArgumentsInfo;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.parts.ComboViewerPart;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ArgumentsSection
extends PDESection {
    private static final String[] TAB_LABELS = new String[4];
    private static final String[] TAB_ARCHLABELS;
    private FormEntry fVMArgs;
    private FormEntry fProgramArgs;
    private FormEntry fPreviewArgs;
    private CTabFolder fTabFolder;
    private ComboViewerPart fArchCombo;
    private int fLastTab;
    private int[] fLastArch = new int[5];

    static {
        ArgumentsSection.TAB_LABELS[0] = PDEUIMessages.ArgumentsSection_allPlatforms;
        ArgumentsSection.TAB_LABELS[1] = "linux";
        ArgumentsSection.TAB_LABELS[2] = "macosx";
        ArgumentsSection.TAB_LABELS[3] = "win32";
        TAB_ARCHLABELS = new String[8];
        ArgumentsSection.TAB_ARCHLABELS[0] = PDEUIMessages.ArgumentsSection_allArch;
        ArgumentsSection.TAB_ARCHLABELS[1] = "x86";
        ArgumentsSection.TAB_ARCHLABELS[2] = "x86_64";
    }

    public ArgumentsSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128);
        this.createClient(this.getSection(), page.getEditor().getToolkit());
    }

    @Override
    protected void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData data = new GridData(1808);
        section.setLayoutData((Object)data);
        section.setText(PDEUIMessages.ArgumentsSection_title);
        section.setDescription(PDEUIMessages.ArgumentsSection_desc);
        Composite client = toolkit.createComposite((Composite)section);
        client.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 1));
        client.setLayoutData((Object)new GridData(1808));
        this.fTabFolder = new CTabFolder(client, 0x800080);
        toolkit.adapt((Control)this.fTabFolder, true, true);
        GridData gd = new GridData(256);
        this.fTabFolder.setLayoutData((Object)gd);
        gd.heightHint = 2;
        toolkit.getColors().initializeSectionToolBarColors();
        Color selectedColor = toolkit.getColors().getColor("org.eclipse.ui.forms.TB_BG");
        this.fTabFolder.setSelectionBackground(new Color[]{selectedColor, toolkit.getColors().getBackground()}, new int[]{100}, true);
        this.fTabFolder.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (this.fProgramArgs.isDirty()) {
                this.fProgramArgs.commit();
            }
            if (this.fVMArgs.isDirty()) {
                this.fVMArgs.commit();
            }
            this.refresh();
            this.fArchCombo.select(this.fLastArch[this.fLastTab]);
        }));
        this.createTabs();
        Composite archParent = toolkit.createComposite(client);
        archParent.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 2));
        archParent.setLayoutData((Object)new GridData(768));
        toolkit.createLabel(archParent, PDEUIMessages.ArgumentsSection_architecture);
        this.fArchCombo = new ComboViewerPart();
        this.fArchCombo.createControl(archParent, toolkit, 2060);
        this.fArchCombo.getControl().setLayoutData((Object)new GridData(16384, 128, false, false));
        this.fArchCombo.setItems(Arrays.stream(TAB_ARCHLABELS).filter(Objects::nonNull).toArray(String[]::new));
        Control archComboControl = this.fArchCombo.getControl();
        if (archComboControl instanceof Combo) {
            ((Combo)archComboControl).select(this.fLastArch[this.fLastTab]);
        } else {
            ((CCombo)archComboControl).select(this.fLastArch[this.fLastTab]);
        }
        this.fArchCombo.addSelectionChangedListener(event -> {
            Control fArchComboControl;
            if (this.fProgramArgs.isDirty()) {
                this.fProgramArgs.commit();
            }
            if (this.fVMArgs.isDirty()) {
                this.fVMArgs.commit();
            }
            this.fLastArch[this.fLastTab] = (fArchComboControl = this.fArchCombo.getControl()) instanceof Combo ? ((Combo)fArchComboControl).getSelectionIndex() : ((CCombo)fArchComboControl).getSelectionIndex();
            this.refresh();
        });
        IActionBars actionBars = this.getPage().getPDEEditor().getEditorSite().getActionBars();
        this.fProgramArgs = new FormEntry(client, toolkit, PDEUIMessages.ArgumentsSection_program, 66);
        this.fProgramArgs.getText().setLayoutData((Object)new GridData(1808));
        this.fProgramArgs.setFormEntryListener(new FormEntryAdapter(this, actionBars){

            @Override
            public void textValueChanged(FormEntry entry) {
                IArgumentsInfo info = ArgumentsSection.this.getLauncherArguments();
                info.setProgramArguments(entry.getValue().trim(), ArgumentsSection.this.fLastTab, ArgumentsSection.this.fLastArch[ArgumentsSection.this.fLastTab]);
                ArgumentsSection.this.updateArgumentPreview(info);
            }
        });
        this.fProgramArgs.setEditable(this.isEditable());
        this.fVMArgs = new FormEntry(client, toolkit, PDEUIMessages.ArgumentsSection_vm, 66);
        this.fVMArgs.getText().setLayoutData((Object)new GridData(1808));
        this.fVMArgs.setFormEntryListener(new FormEntryAdapter(this, actionBars){

            @Override
            public void textValueChanged(FormEntry entry) {
                IArgumentsInfo info = ArgumentsSection.this.getLauncherArguments();
                info.setVMArguments(entry.getValue().trim(), ArgumentsSection.this.fLastTab, ArgumentsSection.this.fLastArch[ArgumentsSection.this.fLastTab]);
                ArgumentsSection.this.updateArgumentPreview(info);
            }
        });
        this.fVMArgs.setEditable(this.isEditable());
        this.fPreviewArgs = new FormEntry(client, toolkit, PDEUIMessages.ArgumentsSection_preview, 66);
        this.fPreviewArgs.getText().setLayoutData((Object)new GridData(1808));
        this.fPreviewArgs.setEditable(false);
        toolkit.paintBordersFor(client);
        section.setClient((Control)client);
        this.getModel().addModelChangedListener((IModelChangedListener)this);
    }

    private void createTabs() {
        String[] stringArray = TAB_LABELS;
        int n = TAB_LABELS.length;
        int n2 = 0;
        while (n2 < n) {
            String tabLabel = stringArray[n2];
            CTabItem item = new CTabItem(this.fTabFolder, 0);
            item.setText(tabLabel);
            item.setImage(PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_OPERATING_SYSTEM_OBJ));
            ++n2;
        }
        this.fLastTab = 0;
        this.fTabFolder.setSelection(this.fLastTab);
    }

    public void refresh() {
        this.fLastTab = this.fTabFolder.getSelectionIndex();
        IArgumentsInfo launcherArguments = this.getLauncherArguments();
        this.fProgramArgs.setValue(launcherArguments.getProgramArguments(this.fLastTab, this.fLastArch[this.fLastTab]), true);
        this.fVMArgs.setValue(launcherArguments.getVMArguments(this.fLastTab, this.fLastArch[this.fLastTab]), true);
        this.updateArgumentPreview(launcherArguments);
        super.refresh();
    }

    public void commit(boolean onSave) {
        this.fProgramArgs.commit();
        this.fVMArgs.commit();
        super.commit(onSave);
    }

    @Override
    public void cancelEdit() {
        this.fProgramArgs.cancelEdit();
        this.fVMArgs.cancelEdit();
        super.cancelEdit();
    }

    private IArgumentsInfo getLauncherArguments() {
        IArgumentsInfo info = this.getProduct().getLauncherArguments();
        if (info == null) {
            info = this.getModel().getFactory().createLauncherArguments();
            this.getProduct().setLauncherArguments(info);
        }
        return info;
    }

    private IProduct getProduct() {
        return this.getModel().getProduct();
    }

    private IProductModel getModel() {
        return (IProductModel)this.getPage().getPDEEditor().getAggregateModel();
    }

    @Override
    public boolean canPaste(Clipboard clipboard) {
        Display d = this.getSection().getDisplay();
        return d.getFocusControl() instanceof Text;
    }

    @Override
    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.handleModelEventWorldChanged(e);
        }
    }

    private void handleModelEventWorldChanged(IModelChangedEvent event) {
        this.refresh();
    }

    public void dispose() {
        IProductModel model = this.getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    private void updateArgumentPreview(IArgumentsInfo launcherArguments) {
        StringBuilder buffer = new StringBuilder();
        String delim = System.getProperty("line.separator");
        String args = launcherArguments.getCompleteProgramArguments(TAB_LABELS[this.fLastTab], TAB_ARCHLABELS[this.fLastArch[this.fLastTab]]);
        if (args.length() > 0) {
            buffer.append(PDEUIMessages.ArgumentsSection_program);
            buffer.append(delim);
            buffer.append(args);
            buffer.append(delim);
            buffer.append(delim);
        }
        if ((args = launcherArguments.getCompleteVMArguments(TAB_LABELS[this.fLastTab], TAB_ARCHLABELS[this.fLastArch[this.fLastTab]])).length() > 0) {
            buffer.append(PDEUIMessages.ArgumentsSection_vm);
            buffer.append(delim);
            buffer.append(args);
        }
        this.fPreviewArgs.setValue(buffer.toString());
    }
}

