/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.launching;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.ClasspathHelper;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.core.util.VersionUtil;
import org.eclipse.pde.internal.launching.launcher.BundleLauncherHelper;
import org.eclipse.pde.internal.launching.launcher.LaunchArgumentsHelper;
import org.eclipse.pde.internal.launching.launcher.LaunchConfigurationHelper;
import org.eclipse.pde.internal.launching.launcher.LauncherUtils;
import org.eclipse.pde.launching.AbstractPDELaunchConfiguration;
import org.osgi.framework.Version;

public class EclipseApplicationLaunchConfiguration
extends AbstractPDELaunchConfiguration {
    private Map<String, IPluginModelBase> fAllBundles;
    private Map<IPluginModelBase, String> fModels;
    private String fWorkspaceLocation;

    @Override
    public String[] getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        ArrayList<String> programArgs = new ArrayList<String>();
        if (configuration.getAttribute("useProduct", false)) {
            String product = configuration.getAttribute("product", "");
            if (product.length() > 0) {
                programArgs.add("-product");
                programArgs.add(product);
            } else {
                programArgs.add("-application");
                programArgs.add(configuration.getAttribute("application", ""));
            }
        } else {
            programArgs.add("-application");
            programArgs.add(configuration.getAttribute("application", TargetPlatform.getDefaultApplication()));
        }
        if (this.fWorkspaceLocation == null) {
            this.fWorkspaceLocation = LaunchArgumentsHelper.getWorkspaceLocation(configuration);
        }
        if (this.fWorkspaceLocation.length() > 0) {
            programArgs.add("-data");
            programArgs.add(this.fWorkspaceLocation);
        }
        boolean showSplash = true;
        String productID = LaunchConfigurationHelper.getProductID(configuration);
        Properties prop = LaunchConfigurationHelper.createConfigIniFile(configuration, productID, this.fAllBundles, this.fModels, this.getConfigDir(configuration));
        showSplash = prop.containsKey("osgi.splashPath") || prop.containsKey("splashLocation");
        TargetPlatformHelper.checkPluginPropertiesConsistency(this.fAllBundles, (File)this.getConfigDir(configuration));
        programArgs.add("-configuration");
        programArgs.add("file:" + new Path(this.getConfigDir(configuration).getPath()).addTrailingSeparator().toString());
        programArgs.add("-dev");
        programArgs.add(ClasspathHelper.getDevEntriesProperties((String)(String.valueOf(this.getConfigDir(configuration).toString()) + "/dev.properties"), this.fAllBundles));
        IPluginModelBase base = this.fAllBundles.get("org.eclipse.pde.core");
        if (base != null && VersionUtil.compareMacroMinorMicro((Version)base.getBundleDescription().getVersion(), (Version)new Version("3.3.1")) < 0) {
            programArgs.add("-pdelaunch");
        }
        String[] args = super.getProgramArguments(configuration);
        Collections.addAll(programArgs, args);
        if (!programArgs.contains("-nosplash") && showSplash) {
            if (TargetPlatformHelper.getTargetVersion() >= 3.1) {
                programArgs.add(0, "-launcher");
                IPath path = null;
                if (TargetPlatform.getOS().equals("macosx")) {
                    path = new Path(TargetPlatform.getLocation()).append("Eclipse.app/Contents/MacOS/eclipse");
                } else {
                    path = new Path(TargetPlatform.getLocation()).append("eclipse");
                    if (TargetPlatform.getOS().equals("win32")) {
                        path = path.addFileExtension("exe");
                    }
                }
                programArgs.add(1, path.toOSString());
                programArgs.add(2, "-name");
                programArgs.add(3, "Eclipse");
                programArgs.add(4, "-showsplash");
                programArgs.add(5, "600");
            } else {
                programArgs.add(0, "-showsplash");
                programArgs.add(1, this.computeShowsplashArgument());
            }
        }
        return programArgs.toArray(new String[programArgs.size()]);
    }

    private String computeShowsplashArgument() {
        Path eclipseHome = new Path(TargetPlatform.getLocation());
        IPath fullPath = eclipseHome.append("eclipse");
        return String.valueOf(fullPath.toOSString()) + " -showsplash 600";
    }

    @Override
    protected File getConfigDir(ILaunchConfiguration config) {
        if (this.fConfigDir == null) {
            this.fConfigDir = LaunchConfigurationHelper.getConfigurationArea(config);
        }
        return this.fConfigDir;
    }

    @Override
    protected void clear(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMon;
        if (this.fWorkspaceLocation == null) {
            this.fWorkspaceLocation = LaunchArgumentsHelper.getWorkspaceLocation(configuration);
        }
        if (!LauncherUtils.clearWorkspace(configuration, this.fWorkspaceLocation, (IProgressMonitor)(subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)50)).split(25))) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        subMon.setWorkRemaining(25);
        if (subMon.isCanceled()) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        if (configuration.getAttribute("clearConfig", false)) {
            CoreUtility.deleteContent((File)this.getConfigDir(configuration), (IProgressMonitor)subMon.split(25));
        }
        subMon.setWorkRemaining(0);
    }

    @Override
    protected void preLaunchCheck(ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.fWorkspaceLocation = null;
        this.fModels = BundleLauncherHelper.getMergedBundleMap(configuration, false);
        this.fAllBundles = new HashMap<String, IPluginModelBase>(this.fModels.size());
        for (IPluginModelBase model : this.fModels.keySet()) {
            this.fAllBundles.put(model.getPluginBase().getId(), model);
        }
        this.validateConfigIni(configuration);
        super.preLaunchCheck(configuration, launch, monitor);
    }

    private void validateConfigIni(ILaunchConfiguration configuration) throws CoreException {
        if (!configuration.getAttribute("useDefaultConfig", true)) {
            String templateLoc = configuration.getAttribute("templateConfig", "");
            IStringVariableManager mgr = VariablesPlugin.getDefault().getStringVariableManager();
            templateLoc = mgr.performStringSubstitution(templateLoc);
            File templateFile = new File(templateLoc);
            if (!templateFile.exists() && !LauncherUtils.generateConfigIni()) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
        }
    }

    @Override
    public String[] getVMArguments(ILaunchConfiguration configuration) throws CoreException {
        String[] vmArgs = super.getVMArguments(configuration);
        IPluginModelBase base = this.fAllBundles.get("org.eclipse.pde.core");
        if (base != null && VersionUtil.compareMacroMinorMicro((Version)base.getBundleDescription().getVersion(), (Version)new Version("3.3.1")) >= 0) {
            String[] result = new String[vmArgs.length + 1];
            System.arraycopy(vmArgs, 0, result, 0, vmArgs.length);
            result[vmArgs.length] = "-Declipse.pde.launch=true";
            return result;
        }
        return vmArgs;
    }
}

