/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.core.protocol;

import org.eclipse.rcptt.tesla.core.protocol.BasicUIElement;
import org.eclipse.rcptt.tesla.core.protocol.BooleanResponse;
import org.eclipse.rcptt.tesla.core.protocol.BoundsResponse;
import org.eclipse.rcptt.tesla.core.protocol.Check;
import org.eclipse.rcptt.tesla.core.protocol.Click;
import org.eclipse.rcptt.tesla.core.protocol.ClickColumn;
import org.eclipse.rcptt.tesla.core.protocol.ClickText;
import org.eclipse.rcptt.tesla.core.protocol.Close;
import org.eclipse.rcptt.tesla.core.protocol.DoubleClick;
import org.eclipse.rcptt.tesla.core.protocol.DoubleClickText;
import org.eclipse.rcptt.tesla.core.protocol.DragCommand;
import org.eclipse.rcptt.tesla.core.protocol.DragKind;
import org.eclipse.rcptt.tesla.core.protocol.ElementKind;
import org.eclipse.rcptt.tesla.core.protocol.GetBounds;
import org.eclipse.rcptt.tesla.core.protocol.GetText;
import org.eclipse.rcptt.tesla.core.protocol.GetTextResponse;
import org.eclipse.rcptt.tesla.core.protocol.IUIPlayer;
import org.eclipse.rcptt.tesla.core.protocol.IsDisposed;
import org.eclipse.rcptt.tesla.core.protocol.IsEnabled;
import org.eclipse.rcptt.tesla.core.protocol.Maximize;
import org.eclipse.rcptt.tesla.core.protocol.Minimize;
import org.eclipse.rcptt.tesla.core.protocol.Restore;
import org.eclipse.rcptt.tesla.core.protocol.RulerClick;
import org.eclipse.rcptt.tesla.core.protocol.RulerDoubleClick;
import org.eclipse.rcptt.tesla.core.protocol.RulerHover;
import org.eclipse.rcptt.tesla.core.protocol.SetFocus;
import org.eclipse.rcptt.tesla.core.protocol.SetSortColumn;
import org.eclipse.rcptt.tesla.core.protocol.Show;
import org.eclipse.rcptt.tesla.core.protocol.ShowTabList;
import org.eclipse.rcptt.tesla.core.protocol.Type;
import org.eclipse.rcptt.tesla.core.protocol.TypeAction;
import org.eclipse.rcptt.tesla.core.protocol.TypeText;
import org.eclipse.rcptt.tesla.core.protocol.UIPlayer;
import org.eclipse.rcptt.tesla.core.protocol.UISelector;
import org.eclipse.rcptt.tesla.core.protocol.diagram.DiagramFactory;
import org.eclipse.rcptt.tesla.core.protocol.diagram.MouseCommand;
import org.eclipse.rcptt.tesla.core.protocol.diagram.MouseCommandKind;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.core.protocol.raw.ResponseStatus;

public class ControlUIElement
extends BasicUIElement {
    private final Selector selector = new Selector();

    public ControlUIElement(Element e, UIPlayer player) {
        super(e, player);
        this.selector.menu = new UISelector<ControlUIElement>(ElementKind.Menu, (IUIPlayer)player, ControlUIElement.class).parent(this.getElement());
        this.selector.region = new UISelector<ControlUIElement>(ElementKind.Region, (IUIPlayer)player, ControlUIElement.class).parent(this.getElement());
    }

    protected void updateAfter(Element e) {
        this.selector.menu.after = e;
    }

    public void show() {
        Show cmd = this.factory.createShow();
        cmd.setElement(this.getElement());
        this.player.safeExecuteCommand(cmd);
    }

    public ControlUIElement menu(String[] path, Integer index) {
        return this.selector.menu.path(path).find(index);
    }

    public ControlUIElement region(byte[] image, int x, int y) {
        return this.selector.region.image(image).indexes(x, y).find();
    }

    public void executeMouseCommand(int x, int y, int button, MouseCommandKind kind, int width, int height, int stateMask) {
        MouseCommand command = DiagramFactory.eINSTANCE.createMouseCommand();
        command.setKind(kind);
        command.setButton(button);
        command.setElement(this.getElement());
        command.setX(x);
        command.setY(y);
        command.setBoundsHeight(height);
        command.setBoundsWidth(width);
        command.setStateMask(stateMask);
        this.player.safeExecuteCommand(command);
    }

    public String getText() {
        GetText cmd = this.factory.createGetText();
        cmd.setElement(this.getElement());
        GetTextResponse response = (GetTextResponse)this.player.safeExecuteCommand(cmd);
        this.player.clearFailures();
        if (response == null) {
            return null;
        }
        if (response.getStatus().equals((Object)ResponseStatus.OK)) {
            return response.getText();
        }
        return null;
    }

    public boolean isDisposed() {
        IsDisposed cmd = this.factory.createIsDisposed();
        cmd.setElement(this.getElement());
        BooleanResponse response = (BooleanResponse)this.player.safeExecuteCommand(cmd);
        this.player.clearFailures();
        if (response == null) {
            return false;
        }
        if (response.getStatus().equals((Object)ResponseStatus.OK)) {
            return response.isResult();
        }
        return false;
    }

    public boolean isDisabled() {
        IsEnabled cmd = this.factory.createIsEnabled();
        cmd.setElement(this.getElement());
        BooleanResponse response = (BooleanResponse)this.player.safeExecuteCommand(cmd);
        this.player.clearFailures();
        if (response == null) {
            return false;
        }
        if (response.getStatus().equals((Object)ResponseStatus.OK)) {
            return !response.isResult();
        }
        return true;
    }

    public void click() {
        this.click(false, false, false);
    }

    public void clickArrow() {
        this.click(false, false, true);
    }

    public void click(boolean defaultClick) {
        this.click(false, defaultClick, false);
    }

    public void click(boolean wait, boolean defaultClick, boolean arrow) {
        Click click = this.factory.createClick();
        click.setElement(this.getElement());
        click.setDefault(defaultClick);
        click.setWithWait(wait);
        click.setArrow(arrow);
        this.player.safeExecuteCommand(click);
    }

    public void check(boolean state) {
        Check check = this.factory.createCheck();
        check.setElement(this.getElement());
        check.setState(state);
        this.player.safeExecuteCommand(check);
    }

    public void clickAndWait() {
        this.clickAndWait(false);
    }

    public void clickAndWait(boolean defaultClick) {
        this.click(true, defaultClick, false);
    }

    public void clickArrowAndWait() {
        this.clickArrowAndWait(false);
    }

    public void clickArrowAndWait(boolean defaultClick) {
        this.click(true, defaultClick, true);
    }

    public void doubleClick() {
        this.doubleClick(false);
    }

    public void doubleClick(boolean wait) {
        DoubleClick click = this.factory.createDoubleClick();
        click.setElement(this.getElement());
        this.player.safeExecuteCommand(click);
    }

    public void doubleClickAndWait() {
        this.doubleClick(true);
    }

    public void type(String text, int modifier, boolean fromDisplay) {
        TypeText type = this.factory.createTypeText();
        type.setState(modifier);
        type.setText(text);
        type.setElement(this.getElement());
        type.setFromDisplay(fromDisplay);
        this.player.safeExecuteCommand(type);
    }

    public void typeAction(String actionId) {
        TypeAction typeAction = this.factory.createTypeAction();
        typeAction.setActionId(actionId);
        typeAction.setElement(this.getElement());
        this.player.safeExecuteCommand(typeAction);
    }

    public void press(int code, int modifier, boolean fromDisplay, char character, int meta, boolean isTraverse, int times) {
        Type type = this.factory.createType();
        type.setState(modifier);
        type.setCode(code);
        type.setElement(this.getElement());
        type.setFromDisplay(fromDisplay);
        type.setCharacter(character);
        type.setMeta(meta);
        type.setTraverse(isTraverse);
        type.setTimes(times);
        this.player.safeExecuteCommand(type);
    }

    public void press(int code, int modifier, boolean fromDisplay, char character, int meta, boolean isTraverse) {
        this.press(code, modifier, fromDisplay, character, meta, isTraverse, 1);
    }

    public void traverse(int code, char character) {
        this.press(code, 0, false, character, 0, true);
    }

    public void traverse(int code, char character, int times) {
        this.press(code, 0, false, character, 0, true, times);
    }

    public void press(int code, int modifier, boolean fromDisplay, char character, int meta) {
        this.press(code, modifier, fromDisplay, character, meta, false);
    }

    public void press(int code, int modifier, boolean fromDisplay, char character) {
        this.press(code, modifier, fromDisplay, character, 0);
    }

    public void type(String text, int modifier) {
        this.type(text, modifier, false);
    }

    public void press(int code, int modifier, char character) {
        this.press(code, modifier, false, character);
    }

    public void press(int code, int modifier) {
        this.press(code, modifier, false, (char)(code & 0xFF));
    }

    public void press(int code, int mask, int character) {
        this.press(code, mask, (char)(character & 0xFF));
    }

    public void type(String text) {
        this.type(text, 0, false);
    }

    public void press(int code, boolean fromDisplay, char character) {
        this.press(code, 0, fromDisplay, character);
    }

    public void type(String text, boolean fromDisplay) {
        this.type(text, 0, fromDisplay);
    }

    public boolean isKind(ElementKind text) {
        return this.getElement().getKind().equals(text.name());
    }

    public void drag(DragKind kind, Integer x, Integer y, String style) {
        DragCommand drag = this.factory.createDragCommand();
        drag.setElement(this.getElement());
        drag.setKind(kind);
        drag.setStyle(style);
        drag.setX(x);
        drag.setY(y);
        this.player.safeExecuteCommand(drag);
    }

    public void close() {
        Close cmd = this.factory.createClose();
        cmd.setElement(this.getElement());
        this.player.safeExecuteCommand(cmd);
    }

    public void minimize() {
        Minimize cmd = this.factory.createMinimize();
        cmd.setElement(this.getElement());
        this.player.safeExecuteCommand(cmd);
    }

    public void maximize() {
        Maximize cmd = this.factory.createMaximize();
        cmd.setElement(this.getElement());
        this.player.safeExecuteCommand(cmd);
    }

    public void restore() {
        Restore cmd = this.factory.createRestore();
        cmd.setElement(this.getElement());
        this.player.safeExecuteCommand(cmd);
    }

    public void showTabList() {
        ShowTabList cmd = this.factory.createShowTabList();
        cmd.setElement(this.getElement());
        this.player.safeExecuteCommand(cmd);
    }

    public void RulerClick(int line, int button, int stateMask) {
        RulerClick doubleClick = this.factory.createRulerClick();
        doubleClick.setElement(this.getElement());
        doubleClick.setLine(line);
        doubleClick.setButton(button);
        doubleClick.setStateMask(stateMask);
        this.player.safeExecuteCommand(doubleClick);
    }

    public void RulerDoubleClick(int line, int button, int stateMask) {
        RulerDoubleClick doubleClick = this.factory.createRulerDoubleClick();
        doubleClick.setElement(this.getElement());
        doubleClick.setLine(line);
        doubleClick.setButton(button);
        doubleClick.setStateMask(stateMask);
        this.player.safeExecuteCommand(doubleClick);
    }

    public void RulerHover(int line, int stateMask) {
        RulerHover rulerHover = this.factory.createRulerHover();
        rulerHover.setElement(this.getElement());
        rulerHover.setLine(line);
        rulerHover.setStateMask(stateMask);
        this.player.safeExecuteCommand(rulerHover);
    }

    public void setFocus() {
        SetFocus cmd = this.factory.createSetFocus();
        cmd.setValue(true);
        cmd.setElement(this.getElement());
        this.player.safeExecuteCommand(cmd);
    }

    public void unfocus() {
        SetFocus cmd = this.factory.createSetFocus();
        cmd.setValue(false);
        cmd.setElement(this.getElement());
        this.player.safeExecuteCommand(cmd);
    }

    public void clickText(String start, String end, String button) {
        ClickText cmd = this.factory.createClickText();
        cmd.setStart(start);
        cmd.setEnd(end);
        cmd.setButton(button);
        cmd.setElement(this.getElement());
        this.player.safeExecuteCommand(cmd);
    }

    public void doubleClickText(String position, String button) {
        DoubleClickText cmd = this.factory.createDoubleClickText();
        cmd.setPosition(position);
        cmd.setButton(button);
        cmd.setElement(this.getElement());
        this.player.safeExecuteCommand(cmd);
    }

    public BoundsResponse getBounds() {
        GetBounds cmd = this.factory.createGetBounds();
        cmd.setElement(this.getElement());
        return (BoundsResponse)this.player.safeExecuteCommand(cmd);
    }

    public void clickColumn(String name, int index) {
        ClickColumn cmd = this.factory.createClickColumn();
        cmd.setElement(this.getElement());
        cmd.setName(name);
        cmd.setIndex(index);
        this.player.safeExecuteCommand(cmd);
    }

    public void setSortColumn(String name, boolean descending) {
        SetSortColumn cmd = this.factory.createSetSortColumn();
        cmd.setName(name);
        cmd.setDescending(descending);
        this.player.safeExecuteCommand(cmd);
    }

    private static class Selector {
        public UISelector<ControlUIElement> menu;
        public UISelector<ControlUIElement> region;

        private Selector() {
        }
    }
}

