/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.ui.describers;

import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.ui.describers.IWidgetDescriber;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class WidgetDescriber
implements IWidgetDescriber {
    private Widget widget;

    public WidgetDescriber(Widget widget) {
        this.widget = widget;
    }

    @Override
    public Display getDisplay() {
        return this.widget.getDisplay();
    }

    @Override
    public Widget getWidget() {
        return this.widget;
    }

    @Override
    public Widget getItemWidget() {
        if (this.widget instanceof Item) {
            return this.widget;
        }
        return null;
    }

    @Override
    public void redraw() {
        Control parent = this.getParent();
        if (parent != null) {
            parent.redraw();
        }
    }

    @Override
    public Rectangle getBounds() {
        if (this.widget instanceof TreeItem) {
            TreeItem item = (TreeItem)this.widget;
            Rectangle bounds = item.getBounds();
            bounds.x = 5;
            Rectangle pBounds = item.getParent().getBounds();
            bounds.width = pBounds.width - 10;
            return bounds;
        }
        if (this.widget instanceof TableItem) {
            TableItem item = (TableItem)this.widget;
            Rectangle bounds = item.getBounds();
            bounds.x = 5;
            Rectangle pBounds = item.getParent().getBounds();
            bounds.width = pBounds.width - 10;
            return bounds;
        }
        return this.getRealBounds();
    }

    public Rectangle getRealBounds() {
        if (this.widget instanceof TreeItem) {
            return ((TreeItem)this.widget).getBounds();
        }
        if (this.widget instanceof TableItem) {
            return ((TableItem)this.widget).getBounds();
        }
        if (this.widget instanceof ToolItem) {
            return ((ToolItem)this.widget).getBounds();
        }
        if (this.widget instanceof CoolItem) {
            return ((CoolItem)this.widget).getBounds();
        }
        if (this.widget instanceof Control) {
            return ((Control)this.widget).getBounds();
        }
        return null;
    }

    @Override
    public Point getPoint() {
        Display display = this.widget.getDisplay();
        Control parent = this.getParent();
        Rectangle bounds = this.getBounds();
        if (this.widget instanceof Shell) {
            return new Point(bounds.x, bounds.y);
        }
        if (bounds != null) {
            return display.map(parent, null, bounds.x, bounds.y);
        }
        return null;
    }

    @Override
    public Point getRealPoint() {
        Display display = this.widget.getDisplay();
        Control parent = this.getParent();
        Rectangle bounds = this.getRealBounds();
        if (bounds == null) {
            return null;
        }
        return display.map(parent, null, bounds.x, bounds.y);
    }

    @Override
    public IWidgetDescriber getControl() {
        Tree control = null;
        if (this.widget instanceof TreeItem) {
            control = ((TreeItem)this.widget).getParent();
        }
        if (this.widget instanceof TableItem) {
            control = ((TableItem)this.widget).getParent();
        }
        if (this.widget instanceof ToolItem) {
            control = ((ToolItem)this.widget).getParent();
        }
        if (this.widget instanceof CoolItem) {
            control = ((CoolItem)this.widget).getParent();
        }
        if (control != null) {
            return new WidgetDescriber((Widget)control);
        }
        return this;
    }

    private Control getParent() {
        if (this.widget instanceof TreeItem) {
            return ((TreeItem)this.widget).getParent();
        }
        if (this.widget instanceof TableItem) {
            return ((TableItem)this.widget).getParent();
        }
        if (this.widget instanceof ToolItem) {
            return ((ToolItem)this.widget).getParent();
        }
        if (this.widget instanceof CoolItem) {
            return ((CoolItem)this.widget).getParent();
        }
        if (this.widget instanceof ScrollBar) {
            return ((ScrollBar)this.widget).getParent();
        }
        if (this.widget instanceof ToolTip) {
            return ((ToolTip)this.widget).getParent();
        }
        if (this.widget instanceof Control) {
            return ((Control)this.widget).getParent();
        }
        return null;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.widget == null ? 0 : this.widget.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WidgetDescriber other = (WidgetDescriber)obj;
        return !(this.widget == null ? other.widget != null : !this.widget.equals(other.widget));
    }

    @Override
    public Image captureImage() {
        Widget widget = this.getControl().getWidget();
        Rectangle bounds = this.getBounds();
        if (widget instanceof Control) {
            return SWTUIPlayer.captureControlImageRaw((Control)widget, bounds);
        }
        return null;
    }

    @Override
    public boolean supportsDND() {
        return this.widget instanceof Tree || this.widget instanceof TreeItem || this.widget instanceof Table || this.widget instanceof TableItem || this.widget instanceof ToolItem || this.widget instanceof CoolItem;
    }
}

