/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.target;

import java.io.File;
import java.net.URI;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.internal.core.target.AbstractTargetHandle;
import org.eclipse.pde.internal.core.target.TargetDefinition;

public class ExternalFileTargetHandle
extends AbstractTargetHandle {
    static final String SCHEME = "file";
    private URI fURI;
    private ITextFileBuffer fFileBuffer;

    static ITargetHandle restoreHandle(URI uri) {
        return new ExternalFileTargetHandle(uri);
    }

    protected ExternalFileTargetHandle(URI uri) {
        this.fURI = uri;
        File file = URIUtil.toFile((URI)this.fURI);
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        IPath path = Path.fromOSString((String)file.getAbsolutePath());
        try {
            manager.connect(path, LocationKind.LOCATION, null);
            this.fFileBuffer = manager.getTextFileBuffer(path, LocationKind.LOCATION);
        }
        catch (CoreException coreException) {
            this.fFileBuffer = null;
        }
    }

    @Override
    void delete() throws CoreException {
    }

    @Override
    protected ITextFileBuffer getTextFileBuffer() throws CoreException {
        return this.fFileBuffer;
    }

    @Override
    void save(ITargetDefinition definition) throws CoreException {
        ((TargetDefinition)definition).write(this.getTextFileBuffer());
    }

    @Override
    public boolean exists() {
        return this.fFileBuffer != null && this.fFileBuffer.getFileStore() != null && this.fFileBuffer.getFileStore().fetchInfo() != null && this.fFileBuffer.getFileStore().fetchInfo().exists();
    }

    @Override
    public String getMemento() throws CoreException {
        return this.fURI.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExternalFileTargetHandle) {
            ExternalFileTargetHandle target = (ExternalFileTargetHandle)obj;
            return target.getLocation().equals(this.fURI);
        }
        return super.equals(obj);
    }

    public URI getLocation() {
        return this.fURI;
    }

    public String toString() {
        return this.fURI.toString();
    }
}

