/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.ecl.model;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.rcptt.core.ecl.model.ArgDecl;
import org.eclipse.rcptt.core.ecl.model.IDeclContainer;
import org.eclipse.rcptt.core.ecl.model.ProcDecl;
import org.eclipse.rcptt.core.ecl.model.VarDecl;

public class BaseContainer
implements IDeclContainer {
    protected String resource;
    protected Map<String, ProcDecl> procs = new LinkedHashMap<String, ProcDecl>();
    protected Map<String, VarDecl> vars = new LinkedHashMap<String, VarDecl>();

    public void addProc(ProcDecl proc) {
        if (this.procs.containsKey(proc.name)) {
            return;
        }
        this.procs.put(proc.name, proc);
        proc.container = this;
        ArgDecl[] argDeclArray = proc.getArgs();
        int n = argDeclArray.length;
        int n2 = 0;
        while (n2 < n) {
            ArgDecl param = argDeclArray[n2];
            param.container = this;
            ++n2;
        }
    }

    public void addVar(VarDecl var) {
        if (this.vars.containsKey(var.name)) {
            return;
        }
        this.vars.put(var.name, var);
        var.container = this;
    }

    public void addAllVars(Iterable<VarDecl> vars) {
        for (VarDecl var : vars) {
            this.addVar(var);
        }
    }

    public void addAllProcs(Iterable<ProcDecl> procs) {
        for (ProcDecl proc : procs) {
            this.addProc(proc);
        }
    }

    @Override
    public ProcDecl[] getProcs() {
        return this.procs.values().toArray(new ProcDecl[this.procs.size()]);
    }

    @Override
    public VarDecl[] getVars() {
        return this.vars.values().toArray(new VarDecl[this.vars.size()]);
    }

    public int procCount() {
        return this.procs.size();
    }

    public int varCount() {
        return this.vars.size();
    }

    @Override
    public ProcDecl resolveProc(String name) {
        return this.procs.get(name);
    }

    @Override
    public VarDecl resolveVar(String name) {
        return this.vars.get(name);
    }

    @Override
    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }
}

