/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.rcptt.util.Predicate;

public class ListUtil {
    public static <T> List<T> filter(Iterable<? extends T> input, Predicate<T> predicate) {
        ArrayList<T> result = new ArrayList<T>();
        for (T element : input) {
            if (!predicate.apply(element)) continue;
            result.add(element);
        }
        return result;
    }

    public static <T> void excludeInPlace(Iterable<T> input, Predicate<T> predicate) {
        Iterator<T> iterator = input.iterator();
        while (iterator.hasNext()) {
            if (!predicate.apply(iterator.next())) continue;
            iterator.remove();
        }
    }

    public static <T> Iterable<T> reverse(final List<T> input) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    int i;
                    {
                        this.i = list.size() - 1;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i >= 0;
                    }

                    @Override
                    public T next() {
                        return input.get(this.i--);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }
}

