/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching.ext;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.rcptt.internal.launching.ext.Q7ExtLaunchingPlugin;
import org.osgi.framework.Bundle;

public enum Q7UpdateSiteExtensions {
    instance;

    private final Collection<Q7RuntimeInfo> bundles = Q7UpdateSiteExtensions.inializeProcessors();

    private static URI pathToUri(String path, Bundle bundle) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)path) ? 1 : 0) != 0);
        Preconditions.checkArgument((!path.trim().isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((bundle != null ? 1 : 0) != 0);
        URL url = bundle.getEntry(new Path(path).toString());
        try {
            if (url != null) {
                return url.toURI();
            }
            return new URI(path);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static Collection<Q7RuntimeInfo> inializeProcessors() {
        IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.rcptt.launching.ext.q7runtime");
        ImmutableList.Builder builder = ImmutableList.builder();
        IConfigurationElement[] iConfigurationElementArray = configurationElements;
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            block3: {
                Q7RuntimeInfo info;
                IConfigurationElement config = iConfigurationElementArray[n2];
                IContributor contributor = config.getContributor();
                try {
                    VersionRange version = new VersionRange(config.getAttribute("version"));
                    Bundle bundle = Platform.getBundle((String)contributor.getName());
                    URI path = Q7UpdateSiteExtensions.pathToUri(config.getAttribute("path"), bundle);
                    info = new Q7RuntimeInfo(config.getAttribute("kind"), path, bundle, version);
                }
                catch (IllegalArgumentException e) {
                    Q7ExtLaunchingPlugin.getDefault().log("Plugin " + contributor.getName() + " provides incorrect q7runtime extension point", e);
                    break block3;
                }
                builder.add((Object)info);
            }
            ++n2;
        }
        return builder.build();
    }

    public static Q7UpdateSiteExtensions getDefault() {
        return instance;
    }

    public Collection<Q7RuntimeInfo> getRuntimes() {
        if (this.bundles.isEmpty()) {
            throw new RuntimeException("No injection providers found. Make sure org.eclipse.rcptt.updates.* plugins are loaded");
        }
        return this.bundles;
    }

    public static class Q7RuntimeInfo {
        public final String kind;
        public final URI path;
        public final Bundle bundle;
        public final VersionRange version;

        public Q7RuntimeInfo(String kind, URI path, Bundle bundle, VersionRange version) {
            Preconditions.checkArgument((bundle != null ? 1 : 0) != 0);
            Preconditions.checkArgument((version != null ? 1 : 0) != 0);
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)kind) ? 1 : 0) != 0);
            Preconditions.checkArgument((path != null ? 1 : 0) != 0);
            this.kind = kind;
            this.path = path;
            this.bundle = bundle;
            this.version = version;
        }

        public String toString() {
            return this.bundle.toString();
        }
    }
}

