/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.bouncycastle.bcpg.FingerprintUtil;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

public class KeyIdentifier {
    private final byte[] fingerprint;
    private final long keyId;

    public KeyIdentifier(String string) {
        this(Hex.decode((String)string));
    }

    public KeyIdentifier(byte[] byArray) {
        if (byArray.length == 8) {
            this.keyId = FingerprintUtil.longFromRightMostBytes(byArray);
            this.fingerprint = null;
            return;
        }
        this.fingerprint = Arrays.clone((byte[])byArray);
        this.keyId = byArray.length == 20 ? FingerprintUtil.keyIdFromV4Fingerprint(byArray) : (byArray.length == 32 ? FingerprintUtil.keyIdFromV6Fingerprint(byArray) : 0L);
    }

    public KeyIdentifier(byte[] byArray, long l) {
        this.fingerprint = Arrays.clone((byte[])byArray);
        this.keyId = l;
    }

    public KeyIdentifier(long l) {
        if (l == 0L) {
            this.keyId = 0L;
            this.fingerprint = new byte[0];
        } else {
            this.keyId = l;
            this.fingerprint = null;
        }
    }

    private KeyIdentifier() {
        this(0L);
    }

    public static KeyIdentifier wildcard() {
        return new KeyIdentifier();
    }

    public byte[] getFingerprint() {
        return Arrays.clone((byte[])this.fingerprint);
    }

    public long getKeyId() {
        return this.keyId;
    }

    public boolean isWildcard() {
        return this.keyId == 0L && (this.fingerprint == null || this.fingerprint.length == 0);
    }

    public boolean hasFingerprint(byte[] byArray) {
        return Arrays.constantTimeAreEqual((byte[])this.fingerprint, (byte[])byArray);
    }

    public boolean matches(KeyIdentifier keyIdentifier) {
        if (this.isWildcard() || keyIdentifier.isWildcard()) {
            return true;
        }
        return this.matchesExplicit(keyIdentifier);
    }

    public boolean matchesExplicit(KeyIdentifier keyIdentifier) {
        if (this.fingerprint != null && keyIdentifier.fingerprint != null) {
            return Arrays.constantTimeAreEqual((byte[])this.fingerprint, (byte[])keyIdentifier.fingerprint);
        }
        return this.keyId == keyIdentifier.keyId;
    }

    public static boolean matches(List<KeyIdentifier> list, KeyIdentifier keyIdentifier, boolean bl) {
        Iterator<KeyIdentifier> iterator = list.iterator();
        if (iterator.hasNext()) {
            KeyIdentifier keyIdentifier2 = iterator.next();
            if (!bl && keyIdentifier2.isWildcard()) {
                return true;
            }
            if (keyIdentifier2.getFingerprint() != null && Arrays.constantTimeAreEqual((byte[])keyIdentifier2.getFingerprint(), (byte[])keyIdentifier.getFingerprint())) {
                return true;
            }
            return keyIdentifier2.getKeyId() == keyIdentifier.getKeyId();
        }
        return false;
    }

    public boolean isPresentIn(List<KeyIdentifier> list) {
        Iterator<KeyIdentifier> iterator = list.iterator();
        while (iterator.hasNext()) {
            if (!this.matchesExplicit(iterator.next())) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof KeyIdentifier)) {
            return false;
        }
        KeyIdentifier keyIdentifier = (KeyIdentifier)object;
        if (this.getFingerprint() != null && keyIdentifier.getFingerprint() != null) {
            return Arrays.constantTimeAreEqual((byte[])this.getFingerprint(), (byte[])keyIdentifier.getFingerprint());
        }
        return this.getKeyId() == keyIdentifier.getKeyId();
    }

    public int hashCode() {
        return (int)this.getKeyId();
    }

    public String toString() {
        if (this.isWildcard()) {
            return "*";
        }
        if (this.fingerprint == null) {
            return "" + this.keyId;
        }
        return Hex.toHexString((byte[])this.fingerprint).toUpperCase(Locale.getDefault());
    }

    public String toPrettyPrint() {
        if (this.isWildcard()) {
            return "*";
        }
        if (this.fingerprint == null) {
            return "0x" + Long.toHexString(this.keyId).toUpperCase(Locale.getDefault());
        }
        return FingerprintUtil.prettifyFingerprint(this.fingerprint);
    }
}

