/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.conditions.evaluation;

import java.util.Objects;
import org.eclipse.passage.lic.api.EvaluationType;
import org.eclipse.passage.lic.api.conditions.evaluation.ExpressionEvaluationException;
import org.eclipse.passage.lic.api.conditions.evaluation.ExpressionEvaluationService;
import org.eclipse.passage.lic.api.conditions.evaluation.ExpressionProtocol;
import org.eclipse.passage.lic.api.conditions.evaluation.ExpressionTokenAssessmentService;
import org.eclipse.passage.lic.api.conditions.evaluation.ParsedExpression;
import org.eclipse.passage.lic.base.conditions.evaluation.SimpleMapExpression;
import org.eclipse.passage.lic.internal.base.i18n.ConditionsEvaluationMessages;

public final class SimpleMapExpressionEvaluationService
implements ExpressionEvaluationService {
    private final ExpressionProtocol format = new ExpressionProtocol.Berlin();

    public ExpressionProtocol id() {
        return this.format;
    }

    public void evaluate(ParsedExpression expression, ExpressionTokenAssessmentService assessor) throws ExpressionEvaluationException {
        Objects.requireNonNull(expression);
        Objects.requireNonNull(assessor);
        this.verifyProtocol(expression);
        SimpleMapExpression map = this.map(expression);
        for (String key : map.keys()) {
            boolean passed = this.equal(key, map.expected(key), assessor);
            if (passed) continue;
            throw new ExpressionEvaluationException(String.format(ConditionsEvaluationMessages.getString("SimpleMapExpressionEvaluationService.segment_fails_evaluation"), ((EvaluationType)assessor.id()).identifier(), key, map.expected(key)));
        }
    }

    private boolean equal(String key, String value, ExpressionTokenAssessmentService assessor) throws ExpressionEvaluationException {
        try {
            return assessor.equal(key, value);
        }
        catch (ExpressionEvaluationException e) {
            throw new ExpressionEvaluationException(String.format(ConditionsEvaluationMessages.getString("SimpleMapExpressionEvaluationService.evaluation_fails"), key, value, ((EvaluationType)assessor.id()).identifier()), (Throwable)e);
        }
    }

    private SimpleMapExpression map(ParsedExpression expression) throws ExpressionEvaluationException {
        if (!SimpleMapExpression.class.isInstance(expression)) {
            throw new ExpressionEvaluationException(String.format(ConditionsEvaluationMessages.getString("SimpleMapExpressionEvaluationService.foreign_expression"), expression.protocol()));
        }
        SimpleMapExpression map = (SimpleMapExpression)expression;
        if (map.keys().isEmpty()) {
            throw new ExpressionEvaluationException(ConditionsEvaluationMessages.getString("SimpleMapExpressionEvaluationService.no_checks"));
        }
        return map;
    }

    private void verifyProtocol(ParsedExpression expression) throws ExpressionEvaluationException {
        if (!this.id().equals((Object)expression.protocol())) {
            throw new ExpressionEvaluationException(String.format(ConditionsEvaluationMessages.getString("SimpleMapExpressionEvaluationService.unexpected_expression_protocol"), expression.protocol(), this.id()));
        }
    }
}

