/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.io;

import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.base.BaseLicensedProduct;
import org.eclipse.passage.lic.base.io.PassageFileExtension;

public final class FileNameFromLicensedProduct
implements Supplier<String> {
    private final LicensedProduct product;
    private final PassageFileExtension extension;

    public FileNameFromLicensedProduct(String product, String version, PassageFileExtension extension) {
        this((LicensedProduct)new BaseLicensedProduct(product, version), extension);
    }

    public FileNameFromLicensedProduct(LicensedProduct product, PassageFileExtension extension) {
        Objects.requireNonNull(product, "FileNameFromLicensedProduct::product");
        Objects.requireNonNull(extension, "FileNameFromLicensedProduct::extension");
        this.product = product;
        this.extension = extension;
    }

    public FileNameFromLicensedProduct(LicensedProduct product, Supplier<String> extension) {
        this(product, new PassageFileExtension.Of(extension));
    }

    @Override
    public String get() {
        return String.format("%s_%s%s", this.product.identifier(), this.product.version(), this.extension.get());
    }
}

