/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.conditions.evaluation;

import java.util.Objects;
import org.eclipse.passage.lic.api.EvaluationInstructions;
import org.eclipse.passage.lic.api.EvaluationType;
import org.eclipse.passage.lic.api.LicensingException;
import org.eclipse.passage.lic.api.conditions.evaluation.ExpressionEvaluationException;
import org.eclipse.passage.lic.api.conditions.evaluation.ExpressionEvaluationService;
import org.eclipse.passage.lic.api.conditions.evaluation.ExpressionEvaluatorsRegistry;
import org.eclipse.passage.lic.api.conditions.evaluation.ExpressionParsingException;
import org.eclipse.passage.lic.api.conditions.evaluation.ExpressionParsingService;
import org.eclipse.passage.lic.api.conditions.evaluation.ExpressionPasringRegistry;
import org.eclipse.passage.lic.api.conditions.evaluation.ExpressionProtocol;
import org.eclipse.passage.lic.api.conditions.evaluation.ExpressionTokenAssessmentService;
import org.eclipse.passage.lic.api.conditions.evaluation.ExpressionTokenAssessorsRegistry;
import org.eclipse.passage.lic.api.conditions.evaluation.ParsedExpression;
import org.eclipse.passage.lic.api.registry.Registry;
import org.eclipse.passage.lic.api.registry.ServiceId;
import org.eclipse.passage.lic.base.conditions.evaluation.FormalizedExpression;
import org.eclipse.passage.lic.internal.base.i18n.ConditionsEvaluationMessages;

public final class Authentication {
    private final ExpressionPasringRegistry parsers;
    private final ExpressionTokenAssessorsRegistry assessors;
    private final ExpressionEvaluatorsRegistry evaluators;

    public Authentication(ExpressionPasringRegistry parsers, ExpressionTokenAssessorsRegistry assessors, ExpressionEvaluatorsRegistry evaluators) {
        Objects.requireNonNull(parsers);
        Objects.requireNonNull(assessors);
        Objects.requireNonNull(evaluators);
        this.parsers = parsers;
        this.assessors = assessors;
        this.evaluators = evaluators;
    }

    public void verify(EvaluationInstructions instructions) throws ExpressionParsingException, ExpressionEvaluationException, LicensingException {
        ParsedExpression expression = new FormalizedExpression(instructions.expression(), (Registry<ExpressionProtocol, ExpressionParsingService>)((Registry)this.parsers.get())).get();
        ExpressionEvaluationService evaluator = (ExpressionEvaluationService)((Registry)this.evaluators.get()).service((ServiceId)expression.protocol());
        evaluator.evaluate(expression, this.assessor(instructions.type()));
    }

    private ExpressionTokenAssessmentService assessor(EvaluationType type) throws LicensingException {
        if (!((Registry)this.assessors.get()).hasService((ServiceId)type)) {
            throw new LicensingException(String.format(ConditionsEvaluationMessages.getString("BasePermissionEmittingService.no_assessment_service"), type));
        }
        return (ExpressionTokenAssessmentService)((Registry)this.assessors.get()).service((ServiceId)type);
    }
}

