/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.dashboard.ui.wizards.floating;

import java.util.function.Supplier;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.passage.lic.internal.api.ServiceInvocationResult;
import org.eclipse.passage.lic.internal.base.diagnostic.NoSevereErrors;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.DiagnosticDialog;
import org.eclipse.passage.lic.licenses.model.api.FloatingLicensePack;
import org.eclipse.passage.loc.dashboard.ui.wizards.LicenseIssuedNotification;
import org.eclipse.passage.loc.dashboard.ui.wizards.floating.FloatingDataPack;
import org.eclipse.passage.loc.dashboard.ui.wizards.floating.IssueCommand;
import org.eclipse.passage.loc.dashboard.ui.wizards.floating.IssueLicensePackPage;
import org.eclipse.passage.loc.dashboard.ui.wizards.floating.IssueLicenseRequestPage;
import org.eclipse.passage.loc.dashboard.ui.wizards.floating.IssueUserConfigsRequestPage;
import org.eclipse.passage.loc.dashboard.ui.wizards.floating.ServerConfigsRequest;
import org.eclipse.passage.loc.dashboard.ui.wizards.license.WizardInfoBar;
import org.eclipse.passage.loc.internal.api.IssuedFloatingLicense;
import org.eclipse.passage.loc.internal.dashboard.ui.i18n.IssueLicensePageMessages;

public final class IssueFloatingLicenseWizard
extends Wizard {
    private final IEclipseContext context;
    private final FloatingDataPack initial;
    private Supplier<FloatingLicensePack> license;
    private Supplier<ServerConfigsRequest> personals;

    public IssueFloatingLicenseWizard(IEclipseContext context, FloatingDataPack initial) {
        this.context = context;
        this.initial = initial;
        this.setWindowTitle(IssueLicensePageMessages.IssueFloatingLicenseWizard_title);
    }

    public void addPages() {
        IssueLicenseRequestPage request = new IssueLicenseRequestPage(this.context, this.initial);
        this.addPage(request.get());
        IssueLicensePackPage pack = new IssueLicensePackPage("License information", request::request, this.context);
        this.addPage((IWizardPage)pack);
        IssueUserConfigsRequestPage configs = new IssueUserConfigsRequestPage(this.context);
        this.addPage(configs.get());
        this.personals = configs::request;
        this.license = pack::pack;
    }

    public boolean performFinish() {
        ServiceInvocationResult<IssuedFloatingLicense> result = new IssueCommand(this.context, this.license.get(), this.personals.get()).issue();
        if (!new NoSevereErrors().test(result.diagnostic())) {
            new WizardInfoBar((IWizard)this).installError(IssueLicensePageMessages.IssueFloatingLicenseWizard_failure);
            new DiagnosticDialog(this.getShell(), result.diagnostic()).open();
            return false;
        }
        new WizardInfoBar((IWizard)this).wipe();
        new LicenseIssuedNotification(this.getShell()).showFloating((IssuedFloatingLicense)result.data().get());
        return true;
    }
}

