/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.base.io;

import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.api.LicensingException;
import org.eclipse.passage.lic.internal.api.io.KeyKeeper;
import org.eclipse.passage.lic.internal.base.i18n.AccessCycleMessages;
import org.eclipse.passage.lic.internal.base.io.FileNameFromLicensedProduct;
import org.eclipse.passage.lic.internal.base.io.PassageFileExtension;
import org.eclipse.passage.lic.internal.base.io.PathFromLicensedProduct;

public final class PathKeyKeeper
implements KeyKeeper {
    private final LicensedProduct product;
    private final Supplier<Path> base;

    public PathKeyKeeper(LicensedProduct product, Supplier<Path> base) {
        Objects.requireNonNull(product, "PathKeyKeeper::product");
        Objects.requireNonNull(base, "PathKeyKeeper::base");
        this.product = product;
        this.base = new PathFromLicensedProduct(base, product);
    }

    public LicensedProduct id() {
        return this.product;
    }

    public InputStream productPublicKey() throws LicensingException {
        Path path = this.base.get().resolve(this.keyFile());
        try {
            return new FileInputStream(path.toFile());
        }
        catch (Exception e) {
            throw new LicensingException(AccessCycleMessages.getString("PathKeyKeeper_input_stream_error"), (Throwable)e);
        }
    }

    private String keyFile() {
        return new FileNameFromLicensedProduct(this.product, new PassageFileExtension.PublicKey()).get();
    }
}

