/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.products.edit.providers;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.passage.lic.products.edit.ProductsEditPlugin;
import org.eclipse.passage.lic.products.model.api.Product;
import org.eclipse.passage.lic.products.model.api.ProductVersion;
import org.eclipse.passage.lic.products.model.meta.ProductsFactory;
import org.eclipse.passage.lic.products.model.meta.ProductsPackage;

public class ProductVersionItemProvider
extends ItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    public ProductVersionItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addVersionPropertyDescriptor(object);
            this.addInstallationTokenPropertyDescriptor(object);
            this.addSecureTokenPropertyDescriptor(object);
            this.addNewsPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addVersionPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ProductVersion_version_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ProductVersion_version_feature", "_UI_ProductVersion_type"), (EStructuralFeature)ProductsPackage.Literals.PRODUCT_VERSION__VERSION, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addInstallationTokenPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ProductVersion_installationToken_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ProductVersion_installationToken_feature", "_UI_ProductVersion_type"), (EStructuralFeature)ProductsPackage.Literals.PRODUCT_VERSION__INSTALLATION_TOKEN, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addSecureTokenPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ProductVersion_secureToken_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ProductVersion_secureToken_feature", "_UI_ProductVersion_type"), (EStructuralFeature)ProductsPackage.Literals.PRODUCT_VERSION__SECURE_TOKEN, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addNewsPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ProductVersion_news_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ProductVersion_news_feature", "_UI_ProductVersion_type"), (EStructuralFeature)ProductsPackage.Literals.PRODUCT_VERSION__NEWS, true, true, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(ProductsPackage.Literals.PRODUCT_VERSION__PRODUCT_VERSION_FEATURES);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/product.png"));
    }

    protected boolean shouldComposeCreationImage() {
        return true;
    }

    public String getText(Object object) {
        ProductVersion productVersion = (ProductVersion)object;
        Product product = productVersion.getProduct();
        if (product == null) {
            return this.getString("_UI_ProductVersion_type");
        }
        String productName = product.getName();
        String version = productVersion.getVersion();
        if (version == null || version.length() == 0) {
            return productName;
        }
        return this.getString("_UI_ProductVersion_text_pattern", new Object[]{productName, version});
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(ProductVersion.class)) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 5: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(ProductsPackage.Literals.PRODUCT_VERSION__PRODUCT_VERSION_FEATURES, ProductsFactory.eINSTANCE.createProductVersionFeature()));
    }

    public ResourceLocator getResourceLocator() {
        return ProductsEditPlugin.INSTANCE;
    }
}

