/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.eclipse.passage.lic.internal.json.JsonTransport;
import org.eclipse.passage.lic.internal.json.LicensingConditionAggregator;
import org.eclipse.passage.lic.runtime.conditions.ConditionTransport;
import org.eclipse.passage.lic.runtime.conditions.LicensingCondition;
import org.osgi.service.component.annotations.Component;

@Component(property={"licensing.content.type=application/json"})
public class JsonConditionTransport
implements ConditionTransport {
    public Iterable<LicensingCondition> readConditions(InputStream input) throws IOException {
        ArrayList<LicensingCondition> descriptors = new ArrayList<LicensingCondition>();
        ObjectMapper mapper = JsonTransport.createObjectMapper();
        LicensingConditionAggregator transfer = (LicensingConditionAggregator)mapper.readValue(input, LicensingConditionAggregator.class);
        transfer.getLicensingConditions().forEach(descriptors::add);
        return descriptors;
    }

    public void writeConditions(Iterable<LicensingCondition> conditions, OutputStream output) throws IOException {
        if (conditions == null) {
            return;
        }
        LicensingConditionAggregator aggregator = new LicensingConditionAggregator();
        for (LicensingCondition c : conditions) {
            aggregator.addLicensingCondition(c);
        }
        ObjectMapper mapper = JsonTransport.createObjectMapper();
        byte[] byteValues = mapper.writeValueAsBytes((Object)aggregator);
        output.write(byteValues);
    }
}

