/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.features.edit.providers;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.passage.lic.features.edit.FeaturesEditPlugin;
import org.eclipse.passage.lic.features.model.api.Feature;
import org.eclipse.passage.lic.features.model.api.FeatureVersion;
import org.eclipse.passage.lic.features.model.meta.FeaturesPackage;

public class FeatureVersionItemProvider
extends ItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    public FeatureVersionItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addVersionPropertyDescriptor(object);
            this.addNewsPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addVersionPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_FeatureVersion_version_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_FeatureVersion_version_feature", "_UI_FeatureVersion_type"), (EStructuralFeature)FeaturesPackage.Literals.FEATURE_VERSION__VERSION, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addNewsPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_FeatureVersion_news_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_FeatureVersion_news_feature", "_UI_FeatureVersion_type"), (EStructuralFeature)FeaturesPackage.Literals.FEATURE_VERSION__NEWS, true, true, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/feature.png"));
    }

    protected boolean shouldComposeCreationImage() {
        return true;
    }

    public String getText(Object object) {
        FeatureVersion featureVersion = (FeatureVersion)object;
        Feature feature = featureVersion.getFeature();
        if (feature == null) {
            return this.getString("_UI_FeatureVersion_type");
        }
        String version = featureVersion.getVersion();
        String featureName = feature.getName();
        if (version == null || version.length() == 0) {
            return featureName;
        }
        return this.getString("_UI_FeatureVersion_text_pattern", new Object[]{featureName, version});
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(FeatureVersion.class)) {
            case 0: 
            case 2: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    public ResourceLocator getResourceLocator() {
        return FeaturesEditPlugin.INSTANCE;
    }
}

