/*
 * Decompiled with CFR 0.152.
 */
package org.ggf.drmaa;

import java.util.List;
import org.ggf.drmaa.DrmaaException;
import org.ggf.drmaa.JobInfo;
import org.ggf.drmaa.JobTemplate;
import org.ggf.drmaa.Version;

public interface Session {
    public static final int SUSPEND = 0;
    public static final int RESUME = 1;
    public static final int HOLD = 2;
    public static final int RELEASE = 3;
    public static final int TERMINATE = 4;
    public static final String JOB_IDS_SESSION_ALL = "DRMAA_JOB_IDS_SESSION_ALL";
    public static final String JOB_IDS_SESSION_ANY = "DRMAA_JOB_IDS_SESSION_ANY";
    public static final long TIMEOUT_WAIT_FOREVER = -1L;
    public static final long TIMEOUT_NO_WAIT = 0L;
    public static final int UNDETERMINED = 0;
    public static final int QUEUED_ACTIVE = 16;
    public static final int SYSTEM_ON_HOLD = 17;
    public static final int USER_ON_HOLD = 18;
    public static final int USER_SYSTEM_ON_HOLD = 19;
    public static final int RUNNING = 32;
    public static final int SYSTEM_SUSPENDED = 33;
    public static final int USER_SUSPENDED = 34;
    public static final int USER_SYSTEM_SUSPENDED = 35;
    public static final int DONE = 48;
    public static final int FAILED = 64;

    public void init(String var1) throws DrmaaException;

    public void exit() throws DrmaaException;

    public JobTemplate createJobTemplate() throws DrmaaException;

    public void deleteJobTemplate(JobTemplate var1) throws DrmaaException;

    public String runJob(JobTemplate var1) throws DrmaaException;

    public List<String> runBulkJobs(JobTemplate var1, int var2, int var3, int var4) throws DrmaaException;

    public void control(String var1, int var2) throws DrmaaException;

    public void synchronize(List<String> var1, long var2, boolean var4) throws DrmaaException;

    public JobInfo wait(String var1, long var2) throws DrmaaException;

    public int getJobProgramStatus(String var1) throws DrmaaException;

    public String getContact() throws DrmaaException;

    public Version getVersion() throws DrmaaException;

    public String getDrmSystem() throws DrmaaException;

    public String getDrmaaImplementation() throws DrmaaException;
}

