/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import org.jclouds.Fallback;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.KeyAlreadyExistsException;
import org.jclouds.blobstore.KeyNotFoundException;
import org.jclouds.http.HttpUtils;

public final class BlobStoreFallbacks {
    private BlobStoreFallbacks() {
    }

    public static final class FalseOnContainerNotFound
    implements Fallback<Boolean> {
        public ListenableFuture<Boolean> create(Throwable t) throws Exception {
            return Futures.immediateFuture((Object)this.createOrPropagate(t));
        }

        public Boolean createOrPropagate(Throwable t) throws Exception {
            if (Preconditions.checkNotNull((Object)t, (Object)"throwable") instanceof ContainerNotFoundException) {
                return false;
            }
            throw Throwables.propagate((Throwable)t);
        }
    }

    public static final class FalseOnKeyNotFound
    implements Fallback<Boolean> {
        public ListenableFuture<Boolean> create(Throwable t) throws Exception {
            return Futures.immediateFuture((Object)this.createOrPropagate(t));
        }

        public Boolean createOrPropagate(Throwable t) throws Exception {
            if (Preconditions.checkNotNull((Object)t, (Object)"throwable") instanceof KeyNotFoundException) {
                return false;
            }
            throw Throwables.propagate((Throwable)t);
        }
    }

    public static final class NullOnContainerNotFound
    implements Fallback<Object> {
        public ListenableFuture<Object> create(Throwable t) throws Exception {
            return Futures.immediateFuture((Object)this.createOrPropagate(t));
        }

        public Object createOrPropagate(Throwable t) throws Exception {
            if (Preconditions.checkNotNull((Object)t, (Object)"throwable") instanceof ContainerNotFoundException) {
                return null;
            }
            throw Throwables.propagate((Throwable)t);
        }
    }

    public static final class NullOnKeyAlreadyExists
    implements Fallback<Object> {
        public ListenableFuture<Object> create(Throwable t) throws Exception {
            return Futures.immediateFuture((Object)this.createOrPropagate(t));
        }

        public Object createOrPropagate(Throwable t) throws Exception {
            if (Preconditions.checkNotNull((Object)t, (Object)"throwable") instanceof KeyAlreadyExistsException) {
                return null;
            }
            throw Throwables.propagate((Throwable)t);
        }
    }

    public static final class NullOnKeyNotFound
    implements Fallback<Object> {
        public ListenableFuture<Object> create(Throwable t) throws Exception {
            return Futures.immediateFuture((Object)this.createOrPropagate(t));
        }

        public Object createOrPropagate(Throwable t) throws Exception {
            if (Preconditions.checkNotNull((Object)t, (Object)"throwable") instanceof KeyNotFoundException) {
                return null;
            }
            throw Throwables.propagate((Throwable)t);
        }
    }

    public static final class ThrowContainerNotFoundOn404
    implements Fallback<Object> {
        public ListenableFuture<Object> create(Throwable t) throws Exception {
            return Futures.immediateFuture((Object)this.createOrPropagate(t));
        }

        public Object createOrPropagate(Throwable t) throws Exception {
            if (HttpUtils.contains404((Throwable)((Throwable)Preconditions.checkNotNull((Object)t, (Object)"throwable")))) {
                throw new ContainerNotFoundException(t);
            }
            throw Throwables.propagate((Throwable)t);
        }
    }

    public static final class ThrowKeyNotFoundOn404
    implements Fallback<Object> {
        public ListenableFuture<Object> create(Throwable t) throws Exception {
            return Futures.immediateFuture((Object)this.createOrPropagate(t));
        }

        public Object createOrPropagate(Throwable t) throws Exception {
            if (HttpUtils.contains404((Throwable)((Throwable)Preconditions.checkNotNull((Object)t, (Object)"throwable")))) {
                throw new KeyNotFoundException(t);
            }
            throw Throwables.propagate((Throwable)t);
        }
    }
}

