/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.backend.system;

import com.google.common.flogger.AbstractLogger;
import com.google.common.flogger.LogSite;
import com.google.common.flogger.LoggingApi;
import com.google.common.flogger.backend.LoggerBackend;
import com.google.common.flogger.backend.Platform;
import com.google.common.flogger.backend.Tags;
import com.google.common.flogger.backend.system.BackendFactory;
import com.google.common.flogger.backend.system.Clock;
import com.google.common.flogger.backend.system.Configuration;
import com.google.common.flogger.backend.system.LoggingContext;
import com.google.common.flogger.backend.system.SimpleLoggerBackend;
import com.google.common.flogger.util.CallerFinder;
import com.google.common.flogger.util.StackBasedLogSite;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultPlatform
extends Platform {
    private final BackendFactory backendFactory;
    private final Platform.LogCallerFinder callerFinder;
    private final Clock clock;
    private final LoggingContext context;
    private final String configInfo;

    public DefaultPlatform() {
        Configuration config = new Configuration();
        this.configure(config);
        this.backendFactory = config.getBackendFactory() != null ? config.getBackendFactory() : new SimpleBackendFactory();
        this.callerFinder = config.getCallerFinder() != null ? config.getCallerFinder() : new StackBasedCallerFinder();
        this.clock = config.getClock() != null ? config.getClock() : new SystemClock();
        this.context = config.getLoggingContext() != null ? config.getLoggingContext() : new EmptyContext();
        this.configInfo = this.formatConfigInfo();
    }

    protected void configure(Configuration config) {
    }

    protected final Platform.LogCallerFinder getCallerFinderImpl() {
        return this.callerFinder;
    }

    protected final LoggerBackend getBackendImpl(String className) {
        return this.backendFactory.create(className);
    }

    protected final boolean shouldForceLoggingImpl(String loggerName, Level level, boolean isEnabled) {
        return this.context.shouldForceLogging(loggerName, level, isEnabled);
    }

    protected final Tags getInjectedTagsImpl() {
        return this.context.getTags();
    }

    protected final long getCurrentTimeNanosImpl() {
        return this.clock.getCurrentTimeNanos();
    }

    protected final String getConfigInfoImpl() {
        return this.configInfo;
    }

    private String formatConfigInfo() {
        StringBuilder out = new StringBuilder();
        out.append("Platform: ").append(((Object)((Object)this)).getClass().getName()).append("\n");
        out.append("BackendFactory: \"").append(this.backendFactory).append("\"\n");
        out.append("Clock: \"").append(this.clock).append("\"\n");
        out.append("LoggingContext: \"").append(this.context).append("\"\n");
        out.append("LogCallerFinder: \"").append(this.callerFinder).append("\"\n");
        return out.toString();
    }

    private static final class EmptyContext
    extends LoggingContext {
        private EmptyContext() {
        }

        @Override
        public boolean shouldForceLogging(String loggerName, Level level, boolean isEnabled) {
            return false;
        }

        @Override
        public Tags getTags() {
            return Tags.empty();
        }

        public String toString() {
            return "Empty logging context";
        }
    }

    private static final class SimpleBackendFactory
    extends BackendFactory {
        private SimpleBackendFactory() {
        }

        @Override
        public LoggerBackend create(String loggingClass) {
            Logger logger = Logger.getLogger(loggingClass.replace('$', '.'));
            return new SimpleLoggerBackend(logger);
        }

        public String toString() {
            return "Default logger backend factory";
        }
    }

    private static final class StackBasedCallerFinder
    extends Platform.LogCallerFinder {
        private StackBasedCallerFinder() {
        }

        public String findLoggingClass(Class<? extends AbstractLogger<?>> loggerClass) {
            StackTraceElement caller = CallerFinder.findCallerOf(loggerClass, (Throwable)new Throwable(), (int)1);
            if (caller != null) {
                return caller.getClassName();
            }
            throw new IllegalStateException("no caller found on the stack for: " + loggerClass.getName());
        }

        public LogSite findLogSite(Class<? extends LoggingApi<?>> loggerApi, int stackFramesToSkip) {
            StackTraceElement caller = CallerFinder.findCallerOf(loggerApi, (Throwable)new Throwable(), (int)(stackFramesToSkip + 1));
            return caller != null ? new StackBasedLogSite(caller) : LogSite.INVALID;
        }

        public String toString() {
            return "Default stack-based caller finder";
        }
    }

    private static final class SystemClock
    extends Clock {
        private SystemClock() {
        }

        @Override
        public long getCurrentTimeNanos() {
            return TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis());
        }

        public String toString() {
            return "Default millisecond precision clock";
        }
    }
}

