/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.util;

import com.google.api.client.util.ArrayMap;
import com.google.api.client.util.FieldInfo;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassInfo {
    private static final ThreadLocal<WeakHashMap<Class<?>, ClassInfo>> CACHE = new ThreadLocal<WeakHashMap<Class<?>, ClassInfo>>(){

        @Override
        protected WeakHashMap<Class<?>, ClassInfo> initialValue() {
            return new WeakHashMap();
        }
    };
    public final Class<?> clazz;
    private final IdentityHashMap<String, FieldInfo> keyNameToFieldInfoMap;

    public static ClassInfo of(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        WeakHashMap<Class<?>, ClassInfo> cache = CACHE.get();
        ClassInfo classInfo = cache.get(clazz);
        if (classInfo == null) {
            classInfo = new ClassInfo(clazz);
            cache.put(clazz, classInfo);
        }
        return classInfo;
    }

    public FieldInfo getFieldInfo(String keyName) {
        if (keyName == null) {
            return null;
        }
        IdentityHashMap<String, FieldInfo> keyNameToFieldInfoMap = this.keyNameToFieldInfoMap;
        if (keyNameToFieldInfoMap == null) {
            return null;
        }
        return keyNameToFieldInfoMap.get(keyName.intern());
    }

    public Field getField(String keyName) {
        FieldInfo fieldInfo = this.getFieldInfo(keyName);
        return fieldInfo == null ? null : fieldInfo.field;
    }

    public int getKeyCount() {
        IdentityHashMap<String, FieldInfo> keyNameToFieldInfoMap = this.keyNameToFieldInfoMap;
        if (keyNameToFieldInfoMap == null) {
            return 0;
        }
        return keyNameToFieldInfoMap.size();
    }

    public Collection<String> getKeyNames() {
        IdentityHashMap<String, FieldInfo> keyNameToFieldInfoMap = this.keyNameToFieldInfoMap;
        if (keyNameToFieldInfoMap == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(keyNameToFieldInfoMap.keySet());
    }

    public static <T> T newInstance(Class<T> clazz) {
        T newInstance;
        try {
            newInstance = clazz.newInstance();
        }
        catch (IllegalAccessException e) {
            throw ClassInfo.handleExceptionForNewInstance(e, clazz);
        }
        catch (InstantiationException e) {
            throw ClassInfo.handleExceptionForNewInstance(e, clazz);
        }
        return newInstance;
    }

    private static IllegalArgumentException handleExceptionForNewInstance(Exception e, Class<?> clazz) {
        StringBuilder buf = new StringBuilder("unable to create new instance of class ").append(clazz.getName());
        if (Modifier.isAbstract(clazz.getModifiers())) {
            buf.append(" (and) because it is abstract");
        }
        if (clazz.getEnclosingClass() != null && !Modifier.isStatic(clazz.getModifiers())) {
            buf.append(" (and) because it is not static");
        }
        if (!Modifier.isPublic(clazz.getModifiers())) {
            buf.append(" (and) because it is not public");
        } else {
            try {
                clazz.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e1) {
                buf.append(" (and) because it has no public default constructor");
            }
        }
        throw new IllegalArgumentException(buf.toString(), e);
    }

    public static Collection<Object> newCollectionInstance(Class<?> collectionClass) {
        if (collectionClass == null || collectionClass.isAssignableFrom(ArrayList.class)) {
            return new ArrayList<Object>();
        }
        if (0 == (collectionClass.getModifiers() & 0x600)) {
            Collection result = (Collection)ClassInfo.newInstance(collectionClass);
            return result;
        }
        if (collectionClass.isAssignableFrom(HashSet.class)) {
            return new HashSet<Object>();
        }
        if (collectionClass.isAssignableFrom(TreeSet.class)) {
            return new TreeSet<Object>();
        }
        throw new IllegalArgumentException("no default collection class defined for class: " + collectionClass.getName());
    }

    public static Map<String, Object> newMapInstance(Class<?> mapClass) {
        if (mapClass != null && 0 == (mapClass.getModifiers() & 0x600)) {
            Map result = (Map)ClassInfo.newInstance(mapClass);
            return result;
        }
        if (mapClass == null || mapClass.isAssignableFrom(ArrayMap.class)) {
            return ArrayMap.create();
        }
        if (mapClass.isAssignableFrom(TreeMap.class)) {
            return new TreeMap<String, Object>();
        }
        throw new IllegalArgumentException("no default map class defined for class: " + mapClass.getName());
    }

    public static Class<?> getCollectionParameter(Field field) {
        Type[] typeArgs;
        Type genericType;
        if (field != null && (genericType = field.getGenericType()) instanceof ParameterizedType && (typeArgs = ((ParameterizedType)genericType).getActualTypeArguments()).length == 1 && typeArgs[0] instanceof Class) {
            return (Class)typeArgs[0];
        }
        return null;
    }

    public static Class<?> getMapValueParameter(Field field) {
        if (field != null) {
            return ClassInfo.getMapValueParameter(field.getGenericType());
        }
        return null;
    }

    public static Class<?> getMapValueParameter(Type genericType) {
        Type[] typeArgs;
        if (genericType instanceof ParameterizedType && (typeArgs = ((ParameterizedType)genericType).getActualTypeArguments()).length == 2 && typeArgs[1] instanceof Class) {
            return (Class)typeArgs[1];
        }
        return null;
    }

    private ClassInfo(Class<?> clazz) {
        IdentityHashMap<String, FieldInfo> superKeyNameToFieldInfoMap;
        this.clazz = clazz;
        Class<?> superClass = clazz.getSuperclass();
        IdentityHashMap<String, FieldInfo> keyNameToFieldInfoMap = new IdentityHashMap<String, FieldInfo>();
        if (superClass != null && (superKeyNameToFieldInfoMap = ClassInfo.of(superClass).keyNameToFieldInfoMap) != null) {
            keyNameToFieldInfoMap.putAll(superKeyNameToFieldInfoMap);
        }
        for (Field field : clazz.getDeclaredFields()) {
            FieldInfo fieldInfo = FieldInfo.of(field);
            if (fieldInfo == null) continue;
            String fieldName = fieldInfo.name;
            FieldInfo conflictingFieldInfo = (FieldInfo)keyNameToFieldInfoMap.get(fieldName);
            if (conflictingFieldInfo != null) {
                throw new IllegalArgumentException("two fields have the same data key name: " + field + " and " + conflictingFieldInfo.field);
            }
            keyNameToFieldInfoMap.put(fieldName, fieldInfo);
        }
        this.keyNameToFieldInfoMap = keyNameToFieldInfoMap.isEmpty() ? null : keyNameToFieldInfoMap;
    }
}

