/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.qpack;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFieldPreEncoder;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http3.qpack.QpackEncoder;
import org.eclipse.jetty.http3.qpack.internal.EncodableEntry;
import org.eclipse.jetty.http3.qpack.internal.QpackContext;
import org.eclipse.jetty.http3.qpack.internal.table.Entry;
import org.eclipse.jetty.http3.qpack.internal.table.StaticTable;

public class QpackFieldPreEncoder
implements HttpFieldPreEncoder {
    public HttpVersion getHttpVersion() {
        return HttpVersion.HTTP_3;
    }

    public byte[] getEncodedField(HttpHeader header, String name, String value) {
        Entry nameEntry;
        Entry entry;
        boolean huffman;
        StaticTable staticTable = QpackContext.getStaticTable();
        HttpField httpField = new HttpField(header, name, value);
        boolean notIndexed = QpackEncoder.DO_NOT_INDEX.contains(header);
        boolean bl = huffman = !QpackEncoder.DO_NOT_HUFFMAN.contains(header);
        EncodableEntry encodableEntry = notIndexed ? EncodableEntry.getLiteralEntry(httpField, huffman) : ((entry = staticTable.get(httpField)) != null ? EncodableEntry.getReferencedEntry(entry) : ((nameEntry = staticTable.get(name)) != null ? EncodableEntry.getNameReferencedEntry(nameEntry, httpField, huffman) : EncodableEntry.getLiteralEntry(httpField, huffman)));
        int base = 0;
        byte[] preEncodedBytes = new byte[encodableEntry.getRequiredSize(base)];
        encodableEntry.encode(ByteBuffer.wrap(preEncodedBytes), base);
        return preEncodedBytes;
    }
}

