/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.internal;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import org.eclipse.jetty.http3.frames.Frame;
import org.eclipse.jetty.http3.internal.HTTP3ErrorCode;
import org.eclipse.jetty.http3.internal.VarLenInt;
import org.eclipse.jetty.http3.internal.generator.ControlGenerator;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.quic.common.QuicSession;
import org.eclipse.jetty.quic.common.QuicStreamEndPoint;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlFlusher
extends IteratingCallback {
    private static final Logger LOG = LoggerFactory.getLogger(ControlFlusher.class);
    private final AutoLock lock = new AutoLock();
    private final Queue<Entry> queue = new ArrayDeque<Entry>();
    private final ByteBufferPool.Lease lease;
    private final ControlGenerator generator;
    private final QuicStreamEndPoint endPoint;
    private boolean initialized;
    private Throwable terminated;
    private List<Entry> entries;
    private Invocable.InvocationType invocationType = Invocable.InvocationType.NON_BLOCKING;

    public ControlFlusher(QuicSession session, QuicStreamEndPoint endPoint, boolean useDirectByteBuffers) {
        this.lease = new ByteBufferPool.Lease(session.getByteBufferPool());
        this.endPoint = endPoint;
        this.generator = new ControlGenerator(useDirectByteBuffers);
    }

    public boolean offer(Frame frame, Callback callback) {
        Throwable closed;
        try (AutoLock l = this.lock.lock();){
            closed = this.terminated;
            if (closed == null) {
                this.queue.offer(new Entry(frame, callback));
            }
        }
        if (closed == null) {
            return true;
        }
        callback.failed(closed);
        return false;
    }

    protected IteratingCallback.Action process() {
        try (AutoLock l = this.lock.lock();){
            if (this.queue.isEmpty()) {
                IteratingCallback.Action action = IteratingCallback.Action.IDLE;
                return action;
            }
            this.entries = new ArrayList<Entry>(this.queue);
            this.queue.clear();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("flushing {} on {}", this.entries, (Object)this);
        }
        for (Entry entry : this.entries) {
            this.generator.generate(this.lease, this.endPoint.getStreamId(), entry.frame, null);
            this.invocationType = Invocable.combine((Invocable.InvocationType)this.invocationType, (Invocable.InvocationType)entry.callback.getInvocationType());
        }
        if (!this.initialized) {
            this.initialized = true;
            ByteBuffer buffer = ByteBuffer.allocate(VarLenInt.length(0L));
            VarLenInt.encode(buffer, 0L);
            buffer.flip();
            this.lease.insert(0, buffer, false);
        }
        List buffers = this.lease.getByteBuffers();
        if (LOG.isDebugEnabled()) {
            LOG.debug("writing {} buffers ({} bytes) on {}", new Object[]{buffers.size(), this.lease.getTotalLength(), this});
        }
        this.endPoint.write((Callback)this, (ByteBuffer[])buffers.toArray(ByteBuffer[]::new));
        return IteratingCallback.Action.SCHEDULED;
    }

    public void succeeded() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("succeeded to write {} on {}", this.entries, (Object)this);
        }
        this.lease.recycle();
        this.entries.forEach(e -> e.callback.succeeded());
        this.entries.clear();
        this.invocationType = Invocable.InvocationType.NON_BLOCKING;
        super.succeeded();
    }

    protected void onCompleteFailure(Throwable failure) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("failed to write {} on {}", new Object[]{this.entries, this, failure});
        }
        this.lease.recycle();
        ArrayList<Entry> allEntries = new ArrayList<Entry>(this.entries);
        this.entries.clear();
        try (AutoLock l = this.lock.lock();){
            this.terminated = failure;
            allEntries.addAll(this.queue);
            this.queue.clear();
        }
        allEntries.forEach(e -> e.callback.failed(failure));
        long error = HTTP3ErrorCode.INTERNAL_ERROR.code();
        this.endPoint.close(error, failure);
        this.endPoint.getQuicSession().getProtocolSession().outwardClose(error, "control_stream_failure");
    }

    public Invocable.InvocationType getInvocationType() {
        return this.invocationType;
    }

    public String toString() {
        return String.format("%s#%s", super.toString(), this.endPoint.getStreamId());
    }

    private static class Entry {
        private final Frame frame;
        private final Callback callback;

        private Entry(Frame frame, Callback callback) {
            this.frame = frame;
            this.callback = callback;
        }

        public String toString() {
            return this.frame.toString();
        }
    }
}

