/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.demos;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;

public class AsyncEchoServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
        asyncContext.setTimeout(0L);
        Echoer echoer = new Echoer(asyncContext);
        request.getInputStream().setReadListener((ReadListener)echoer);
        response.getOutputStream().setWriteListener((WriteListener)echoer);
    }

    private class Echoer
    implements ReadListener,
    WriteListener {
        private final byte[] buffer = new byte[4096];
        private final AsyncContext asyncContext;
        private final ServletInputStream input;
        private final ServletOutputStream output;
        private final AtomicBoolean complete = new AtomicBoolean(false);

        private Echoer(AsyncContext asyncContext) throws IOException {
            this.asyncContext = asyncContext;
            this.input = asyncContext.getRequest().getInputStream();
            this.output = asyncContext.getResponse().getOutputStream();
        }

        public void onDataAvailable() throws IOException {
            this.handleAsyncIO();
        }

        public void onAllDataRead() throws IOException {
            this.handleAsyncIO();
        }

        public void onWritePossible() throws IOException {
            this.handleAsyncIO();
        }

        private void handleAsyncIO() throws IOException {
            while (this.output.isReady() && this.input.isReady()) {
                int read = this.input.read(this.buffer);
                if (read < 0) {
                    if (!this.complete.compareAndSet(false, true)) break;
                    this.asyncContext.complete();
                    break;
                }
                if (read <= 0) continue;
                this.output.write(this.buffer, 0, read);
            }
        }

        public void onError(Throwable failure) {
            new Throwable("onError", failure).printStackTrace();
            this.asyncContext.complete();
        }
    }
}

