/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.demos;

import java.nio.file.Paths;
import org.eclipse.jetty.demos.ExampleUtil;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.resource.Resource;

public class SplitFileServer {
    public static Server createServer(int port, Resource baseResource0, Resource baseResource1) {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(port);
        server.addConnector((Connector)connector);
        ResourceHandler rh0 = new ResourceHandler();
        rh0.setDirectoriesListed(false);
        ContextHandler context0 = new ContextHandler();
        context0.setContextPath("/");
        context0.setBaseResource(baseResource0);
        context0.setHandler((Handler)rh0);
        ResourceHandler rh1 = new ResourceHandler();
        rh1.setDirectoriesListed(false);
        ContextHandler context1 = new ContextHandler();
        context1.setContextPath("/");
        context1.setBaseResource(baseResource1);
        context1.setHandler((Handler)rh1);
        ContextHandlerCollection contexts = new ContextHandlerCollection(new ContextHandler[]{context0, context1});
        server.setHandler((Handler)contexts);
        return server;
    }

    public static void main(String[] args) throws Exception {
        int port = ExampleUtil.getPort(args, "jetty.http.port", 8080);
        PathResource resource0 = new PathResource(Paths.get("src/test/resources/dir0", new String[0]));
        PathResource resource1 = new PathResource(Paths.get("src/test/resources/dir1", new String[0]));
        Server server = SplitFileServer.createServer(port, (Resource)resource0, (Resource)resource1);
        server.setDumpAfterStart(true);
        server.start();
        server.join();
    }
}

