/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.docs;

import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.ast.Document;
import org.asciidoctor.extension.IncludeProcessor;
import org.asciidoctor.extension.PreprocessorReader;
import org.asciidoctor.jruby.extension.spi.ExtensionRegistry;
import org.eclipse.jetty.tests.hometester.JettyHomeTester;

public class JettyIncludeExtension
implements ExtensionRegistry {
    public void register(Asciidoctor asciidoctor) {
        asciidoctor.javaExtensionRegistry().includeProcessor(JettyIncludeProcessor.class);
    }

    public static class JettyIncludeProcessor
    extends IncludeProcessor {
        public boolean handles(String target) {
            return "jetty".equals(target);
        }

        public void process(Document document, PreprocessorReader reader, String target, Map<String, Object> attributes) {
            try {
                Object args;
                String setupArgs;
                String jettyVersion = (String)document.getAttribute((Object)"project-version");
                Path jettyDocsPath = Path.of((String)document.getAttribute((Object)"project-basedir"), new String[0]);
                Path jettyHome = jettyDocsPath.resolve("target/jetty-home-" + jettyVersion).normalize();
                JettyHomeTester jetty = JettyHomeTester.Builder.newInstance().jettyHome(jettyHome).mavenLocalRepository((String)document.getAttribute((Object)"maven-local-repo")).build();
                String setupModules = (String)attributes.get("setupModules");
                if (setupModules != null) {
                    String[] modules;
                    Path jettyBaseModules = jetty.getJettyBase().resolve("modules");
                    Files.createDirectories(jettyBaseModules, new FileAttribute[0]);
                    for (String module : modules = setupModules.split(",")) {
                        Path sourcePath = jettyDocsPath.resolve(module.trim());
                        Files.copy(sourcePath, jettyBaseModules.resolve(sourcePath.getFileName()), new CopyOption[0]);
                    }
                }
                if ((setupArgs = (String)attributes.get("setupArgs")) != null) {
                    try (JettyHomeTester.Run setupRun = jetty.start(setupArgs.split(" "));){
                        setupRun.awaitFor(15L, TimeUnit.SECONDS);
                    }
                }
                args = (args = (String)attributes.get("args")) == null ? "" : (String)args + " ";
                args = (String)args + String.valueOf(jettyHome.resolve("etc/jetty-halt.xml"));
                try (JettyHomeTester.Run run = jetty.start(((String)args).split(" "));){
                    run.awaitFor(15L, TimeUnit.SECONDS);
                    String output = this.captureOutput(document, attributes, run);
                    reader.pushInclude(output, "jettyHome_run", target, 1, attributes);
                }
            }
            catch (Throwable x) {
                reader.pushInclude(x.toString(), "jettyHome_run", target, 1, attributes);
                x.printStackTrace();
            }
        }

        private String captureOutput(Document document, Map<String, Object> attributes, JettyHomeTester.Run run) {
            Stream<String> lines = run.getLogs().stream().map(line -> this.redact((String)line, System.getProperty("java.home"), "/path/to/java.home")).map(line -> this.redact((String)line, run.getConfig().getMavenLocalRepository(), "/path/to/maven.repository")).map(line -> this.redact((String)line, run.getConfig().getJettyHome().toString(), "/path/to/jetty.home")).map(line -> this.redact((String)line, run.getConfig().getJettyBase().toString(), "/path/to/jetty.base")).map(line -> this.regexpRedact((String)line, "(^| )[^ ]+/etc/jetty-halt\\.xml", "")).map(line -> this.redact((String)line, (String)document.getAttribute((Object)"project-version"), (String)document.getAttribute((Object)"version")));
            lines = this.replace(lines, (String)attributes.get("replace"));
            lines = this.delete(lines, (String)attributes.get("delete"));
            lines = this.denoteLineStart(lines);
            lines = this.highlight(lines, (String)attributes.get("highlight"));
            lines = this.callouts(lines, (String)attributes.get("callouts"));
            return lines.collect(Collectors.joining(System.lineSeparator()));
        }

        private String redact(String line, String target, String replacement) {
            if (target != null && replacement != null) {
                return line.replace(target, replacement);
            }
            return line;
        }

        private String regexpRedact(String line, String regexp, String replacement) {
            if (regexp != null && replacement != null) {
                return line.replaceAll(regexp, replacement);
            }
            return line;
        }

        private Stream<String> replace(Stream<String> lines, String replace) {
            if (replace == null) {
                return lines;
            }
            String[] parts = replace.split(",");
            String regExp = parts[0];
            String replacement = parts[1].replace("\\n", "\n");
            return lines.flatMap(line -> Stream.of(line.replaceAll(regExp, replacement).split("\n")));
        }

        private Stream<String> delete(Stream<String> lines, String delete) {
            if (delete == null) {
                return lines;
            }
            Pattern regExp = Pattern.compile(delete);
            return lines.filter(line -> !regExp.matcher((CharSequence)line).find());
        }

        private Stream<String> denoteLineStart(Stream<String> lines) {
            Pattern regExp = Pattern.compile("(^\\d{4}[^:]+:[^:]+:[^:]+:)");
            return lines.map(line -> {
                Matcher matcher = regExp.matcher((CharSequence)line);
                if (!matcher.find()) {
                    return line;
                }
                return "**" + matcher.group(1) + "**" + line.substring(matcher.end(1));
            });
        }

        private Stream<String> highlight(Stream<String> lines, String highlight) {
            if (highlight == null) {
                return lines;
            }
            Pattern regExp = Pattern.compile(highlight);
            return lines.map(line -> {
                Matcher matcher = regExp.matcher((CharSequence)line);
                if (!matcher.find()) {
                    return line;
                }
                int groupCount = matcher.groupCount();
                if (groupCount == 0) {
                    return "##" + line + "##";
                }
                StringBuilder result = new StringBuilder(line.length() + 4 * groupCount);
                int start = 0;
                for (int groupIndex = 1; groupIndex <= groupCount; ++groupIndex) {
                    int matchBegin = matcher.start(groupIndex);
                    result.append((CharSequence)line, start, matchBegin);
                    result.append("##");
                    int matchEnd = matcher.end(groupIndex);
                    result.append((CharSequence)line, matchBegin, matchEnd);
                    result.append("##");
                    start = matchEnd;
                }
                result.append((CharSequence)line, start, line.length());
                return result.toString();
            });
        }

        private Stream<String> callouts(Stream<String> lines, String callouts) {
            if (callouts == null) {
                return lines;
            }
            String[] parts = callouts.split(",");
            String calloutPattern = parts[0];
            List regExps = Stream.of(parts).skip(1L).map(Pattern::compile).collect(Collectors.toList());
            AtomicInteger index = new AtomicInteger();
            return lines.map(line -> {
                int regExpIndex = index.get();
                if (regExpIndex == regExps.size()) {
                    return line;
                }
                Pattern regExp = (Pattern)regExps.get(regExpIndex);
                if (!regExp.matcher((CharSequence)line).find()) {
                    return line;
                }
                int calloutIndex = index.incrementAndGet();
                return line + calloutPattern.replace("$N", String.valueOf(calloutIndex));
            });
        }
    }
}

