/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.themes;

import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.DataFormatException;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.themes.CascadingColorRegistry;
import org.eclipse.ui.internal.themes.CascadingFontRegistry;
import org.eclipse.ui.internal.themes.CascadingMap;
import org.eclipse.ui.internal.themes.ColorDefinition;
import org.eclipse.ui.internal.themes.FontDefinition;
import org.eclipse.ui.internal.themes.IThemeDescriptor;
import org.eclipse.ui.internal.themes.ThemeElementHelper;
import org.eclipse.ui.internal.themes.ThemeRegistry;
import org.eclipse.ui.internal.themes.WorkbenchThemeManager;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.themes.ITheme;

public class Theme
extends EventManager
implements ITheme {
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(Theme.class.getName());
    private CascadingColorRegistry themeColorRegistry;
    private CascadingFontRegistry themeFontRegistry;
    private final IThemeDescriptor descriptor;
    private IPropertyChangeListener themeListener;
    private CascadingMap dataMap;
    private final ThemeRegistry themeRegistry = (ThemeRegistry)WorkbenchPlugin.getDefault().getThemeRegistry();
    private IPropertyChangeListener propertyListener;

    public Theme(IThemeDescriptor descriptor) {
        this.descriptor = descriptor;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (descriptor != null) {
            ITheme defaultTheme = workbench.getThemeManager().getTheme("org.eclipse.ui.defaultTheme");
            ColorDefinition[] colorDefinitions = this.descriptor.getColors();
            this.themeColorRegistry = new CascadingColorRegistry(defaultTheme.getColorRegistry());
            if (colorDefinitions.length > 0) {
                ThemeElementHelper.populateRegistry((ITheme)this, colorDefinitions, PrefUtil.getInternalPreferenceStore());
            }
            FontDefinition[] fontDefinitions = this.descriptor.getFonts();
            this.themeFontRegistry = new CascadingFontRegistry(defaultTheme.getFontRegistry());
            if (fontDefinitions.length > 0) {
                ThemeElementHelper.populateRegistry((ITheme)this, fontDefinitions, PrefUtil.getInternalPreferenceStore());
            }
            this.dataMap = new CascadingMap(((ThemeRegistry)WorkbenchPlugin.getDefault().getThemeRegistry()).getData(), descriptor.getData());
        }
        this.getColorRegistry().addListener(this.getCascadeListener());
        this.getColorRegistry().addListener(this::registryColorChangeEvent);
        this.getFontRegistry().addListener(this.getCascadeListener());
        PrefUtil.getInternalPreferenceStore().addPropertyChangeListener(this.getPropertyListener());
    }

    private void registryColorChangeEvent(PropertyChangeEvent event) {
        if (event.getNewValue() instanceof RGB) {
            String key = ThemeElementHelper.createPreferenceKey(this, event.getProperty());
            IPreferenceStore store = PrefUtil.getInternalPreferenceStore();
            if (store.contains(key)) {
                RGB newColor = (RGB)event.getNewValue();
                if (store.isDefault(key)) {
                    RGB oldColor = PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key);
                    if (oldColor != PreferenceConverter.COLOR_DEFAULT_DEFAULT && !newColor.equals((Object)oldColor)) {
                        PreferenceConverter.setValue((IPreferenceStore)store, (String)key, (RGB)newColor);
                    }
                } else {
                    RGB oldColor = PreferenceConverter.getColor((IPreferenceStore)store, (String)key);
                    if (!newColor.equals((Object)oldColor)) {
                        oldColor = PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key);
                        if (oldColor != PreferenceConverter.COLOR_DEFAULT_DEFAULT && newColor.equals((Object)oldColor)) {
                            store.setToDefault(key);
                        } else {
                            PreferenceConverter.setValue((IPreferenceStore)store, (String)key, (RGB)newColor);
                        }
                    }
                }
            }
        }
    }

    private static String[] splitPropertyName(String property) {
        IThemeDescriptor[] descriptors;
        IThemeDescriptor[] iThemeDescriptorArray = descriptors = WorkbenchPlugin.getDefault().getThemeRegistry().getThemes();
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IThemeDescriptor themeDescriptor = iThemeDescriptorArray[n2];
            String id = themeDescriptor.getId();
            if (property.startsWith(id + ".")) {
                return new String[]{property.substring(0, id.length()), property.substring(id.length() + 1)};
            }
            ++n2;
        }
        return new String[]{"org.eclipse.ui.defaultTheme", property};
    }

    private IPropertyChangeListener getPropertyListener() {
        if (this.propertyListener == null) {
            this.propertyListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    String[] split = Theme.splitPropertyName(event.getProperty());
                    String key = split[1];
                    String theme = split[0];
                    if (key.equals("CURRENT_THEME_ID")) {
                        return;
                    }
                    try {
                        String thisTheme = Theme.this.getId();
                        if (Objects.equals(thisTheme, theme)) {
                            if (Theme.this.getFontRegistry().hasValueFor(key)) {
                                FontData[] data = event.getNewValue() instanceof String ? PreferenceConverter.basicGetFontData((String)((String)event.getNewValue())) : (FontData[])event.getNewValue();
                                Theme.this.getFontRegistry().put(key, data);
                                this.processDefaultsTo(key, data);
                            } else if (Theme.this.getColorRegistry().hasValueFor(key)) {
                                RGB rgb;
                                RGB rGB = rgb = event.getNewValue() instanceof String ? StringConverter.asRGB((String)((String)event.getNewValue())) : (RGB)event.getNewValue();
                                if (!Objects.equals(Theme.this.getColorRegistry().getRGB(key), rgb)) {
                                    Theme.this.getColorRegistry().put(key, rgb);
                                    this.processDefaultsTo(key, rgb);
                                }
                            }
                        }
                    }
                    catch (DataFormatException dataFormatException) {
                        // empty catch block
                    }
                }

                private void processDefaultsTo(String key, FontData[] fd) {
                    FontDefinition[] defs;
                    FontDefinition[] fontDefinitionArray = defs = WorkbenchPlugin.getDefault().getThemeRegistry().getFontsFor(Theme.this.getId());
                    int n = defs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPreferenceStore store;
                        FontDefinition fontDefinition = fontDefinitionArray[n2];
                        String defaultsTo = fontDefinition.getDefaultsTo();
                        if (defaultsTo != null && defaultsTo.equals(key) && (store = WorkbenchPlugin.getDefault().getPreferenceStore()).isDefault(ThemeElementHelper.createPreferenceKey(Theme.this, fontDefinition.getId()))) {
                            Theme.this.getFontRegistry().put(fontDefinition.getId(), fd);
                            this.processDefaultsTo(fontDefinition.getId(), fd);
                        }
                        ++n2;
                    }
                }

                private void processDefaultsTo(String key, RGB rgb) {
                    ColorDefinition[] defs;
                    ColorDefinition[] colorDefinitionArray = defs = WorkbenchPlugin.getDefault().getThemeRegistry().getColorsFor(Theme.this.getId());
                    int n = defs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String prefkey;
                        IPreferenceStore store;
                        ColorDefinition colorDefinition = colorDefinitionArray[n2];
                        String defaultsTo = colorDefinition.getDefaultsTo();
                        if (defaultsTo != null && defaultsTo.equals(key) && (store = WorkbenchPlugin.getDefault().getPreferenceStore()).isDefault(prefkey = ThemeElementHelper.createPreferenceKey(Theme.this, colorDefinition.getId()))) {
                            PreferenceConverter.setDefault((IPreferenceStore)store, (String)prefkey, (RGB)rgb);
                            Theme.this.getColorRegistry().put(colorDefinition.getId(), rgb);
                            this.processDefaultsTo(colorDefinition.getId(), rgb);
                        }
                        ++n2;
                    }
                }
            };
        }
        return this.propertyListener;
    }

    private IPropertyChangeListener getCascadeListener() {
        if (this.themeListener == null) {
            this.themeListener = this::firePropertyChange;
        }
        return this.themeListener;
    }

    @Override
    public ColorRegistry getColorRegistry() {
        if (this.themeColorRegistry != null) {
            return this.themeColorRegistry;
        }
        return WorkbenchThemeManager.getInstance().getDefaultThemeColorRegistry();
    }

    @Override
    public FontRegistry getFontRegistry() {
        if (this.themeFontRegistry != null) {
            return this.themeFontRegistry;
        }
        return WorkbenchThemeManager.getInstance().getDefaultThemeFontRegistry();
    }

    @Override
    public void dispose() {
        if (this.themeColorRegistry != null) {
            this.themeColorRegistry.removeListener(this.themeListener);
            this.themeColorRegistry.removeListener(this::registryColorChangeEvent);
            this.themeColorRegistry.dispose();
        }
        if (this.themeFontRegistry != null) {
            this.themeFontRegistry.removeListener(this.themeListener);
            this.themeFontRegistry.dispose();
        }
        PrefUtil.getInternalPreferenceStore().removePropertyChangeListener(this.getPropertyListener());
    }

    @Override
    public String getId() {
        return this.descriptor == null ? "org.eclipse.ui.defaultTheme" : this.descriptor.getId();
    }

    @Override
    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.addListenerObject(listener);
    }

    @Override
    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.removeListenerObject(listener);
    }

    private void firePropertyChange(PropertyChangeEvent event) {
        Object[] objectArray = this.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IPropertyChangeListener)listener).propertyChange(event);
            ++n2;
        }
    }

    @Override
    public String getLabel() {
        return this.descriptor == null ? RESOURCE_BUNDLE.getString("DefaultTheme.label") : this.descriptor.getName();
    }

    @Override
    public String getString(String key) {
        if (this.dataMap != null) {
            return (String)this.dataMap.get(key);
        }
        return (String)this.themeRegistry.getData().get(key);
    }

    public Set keySet() {
        if (this.dataMap != null) {
            return this.dataMap.keySet();
        }
        return this.themeRegistry.getData().keySet();
    }

    @Override
    public int getInt(String key) {
        String string = this.getString(key);
        if (string == null) {
            return 0;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    public boolean getBoolean(String key) {
        String string = this.getString(key);
        if (string == null) {
            return false;
        }
        return Boolean.parseBoolean(this.getString(key));
    }
}

