/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.console;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.console.Activator;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.provisional.p2.director.PlanExecutionHelper;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.Collector;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.IRepository;
import org.eclipse.equinox.p2.repository.IRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.osgi.framework.BundleContext;

public class ProvisioningHelper {
    static IRepository<IInstallableUnit> addMetadataRepository(IProvisioningAgent agent, URI location) {
        return ProvisioningHelper.addRepository(IMetadataRepositoryManager.class, agent, location, "metadata", "org.eclipse.equinox.p2.metadata.repository.simpleRepository");
    }

    static IRepository<IInstallableUnit> getMetadataRepository(IProvisioningAgent agent, URI location) {
        return ProvisioningHelper.getRepository(IMetadataRepositoryManager.class, agent, location);
    }

    static void removeMetadataRepository(IProvisioningAgent agent, URI location) {
        ProvisioningHelper.removeRepository(IMetadataRepositoryManager.class, agent, location);
    }

    static IRepository<IArtifactKey> addArtifactRepository(IProvisioningAgent agent, URI location) {
        return ProvisioningHelper.addRepository(IArtifactRepositoryManager.class, agent, location, "artifacts", "org.eclipse.equinox.p2.artifact.repository.simpleRepository");
    }

    static void removeArtifactRepository(IProvisioningAgent agent, URI location) {
        ProvisioningHelper.removeRepository(IArtifactRepositoryManager.class, agent, location);
    }

    static IProfile addProfile(IProvisioningAgent agent, String profileId, Map<String, String> properties) throws ProvisionException {
        IProfileRegistry profileRegistry = (IProfileRegistry)agent.getService(IProfileRegistry.class);
        if (profileRegistry == null) {
            return null;
        }
        IProfile profile = profileRegistry.getProfile(profileId);
        if (profile != null) {
            return profile;
        }
        HashMap<String, String> profileProperties = new HashMap<String, String>(properties);
        if (profileProperties.get("org.eclipse.equinox.p2.environments") == null) {
            EnvironmentInfo info = (EnvironmentInfo)ServiceHelper.getService((BundleContext)Activator.getContext(), EnvironmentInfo.class);
            if (info != null) {
                profileProperties.put("org.eclipse.equinox.p2.environments", "osgi.os=" + info.getOS() + ",osgi.ws=" + info.getWS() + ",osgi.arch=" + info.getOSArch());
            } else {
                profileProperties.put("org.eclipse.equinox.p2.environments", "");
            }
        }
        return profileRegistry.addProfile(profileId, profileProperties);
    }

    static void removeProfile(IProvisioningAgent agent, String profileId) {
        IProfileRegistry profileRegistry = (IProfileRegistry)agent.getService(IProfileRegistry.class);
        if (profileRegistry == null) {
            return;
        }
        profileRegistry.removeProfile(profileId);
    }

    static IProfile[] getProfiles(IProvisioningAgent agent) {
        IProfileRegistry profileRegistry = (IProfileRegistry)agent.getService(IProfileRegistry.class);
        if (profileRegistry == null) {
            return new IProfile[0];
        }
        return profileRegistry.getProfiles();
    }

    static IProfile getProfile(IProvisioningAgent agent, String id) {
        IProfileRegistry profileRegistry = (IProfileRegistry)agent.getService(IProfileRegistry.class);
        if (profileRegistry == null) {
            return null;
        }
        return profileRegistry.getProfile(id);
    }

    static IQueryResult<IInstallableUnit> getInstallableUnits(IProvisioningAgent agent, URI location, IQuery<IInstallableUnit> query, IProgressMonitor monitor) {
        IQueryable queryable = null;
        queryable = location == null ? (IQueryable)agent.getService(IMetadataRepositoryManager.class) : ProvisioningHelper.getMetadataRepository(agent, location);
        if (queryable != null) {
            return queryable.query(query, monitor);
        }
        return Collector.emptyCollector();
    }

    static List<URI> getMetadataRepositories(IProvisioningAgent agent) {
        return ProvisioningHelper.getRepositories(IArtifactRepositoryManager.class, agent);
    }

    static IStatus install(IProvisioningAgent agent, String unitId, String version, IProfile profile, IProgressMonitor progress) throws ProvisionException {
        if (profile == null) {
            return null;
        }
        IQueryResult<IInstallableUnit> units = ProvisioningHelper.getInstallableUnits(agent, null, (IQuery<IInstallableUnit>)QueryUtil.createIUQuery((String)unitId, (Version)Version.create((String)version)), progress);
        if (units.isEmpty()) {
            StringBuilder error = new StringBuilder();
            error.append("Installable unit not found: " + unitId + " " + version + "\n");
            error.append("Repositories searched:\n");
            for (URI repo : ProvisioningHelper.getMetadataRepositories(agent)) {
                error.append(String.valueOf(repo) + "\n");
            }
            throw new ProvisionException(error.toString());
        }
        IPlanner planner = (IPlanner)agent.getService(IPlanner.class);
        if (planner == null) {
            throw new ProvisionException("No planner service found.");
        }
        IEngine engine = (IEngine)agent.getService(IEngine.class);
        if (engine == null) {
            throw new ProvisionException("No director service found.");
        }
        ProvisioningContext context = new ProvisioningContext(agent);
        IProfileChangeRequest request = planner.createChangeRequest(profile);
        request.addAll((Collection)units.toUnmodifiableSet());
        IProvisioningPlan result = planner.getProvisioningPlan(request, context, progress);
        return PlanExecutionHelper.executePlan((IProvisioningPlan)result, (IEngine)engine, (ProvisioningContext)context, (IProgressMonitor)progress);
    }

    static List<URI> getArtifactRepositories(IProvisioningAgent agent) {
        return ProvisioningHelper.getRepositories(IArtifactRepositoryManager.class, agent);
    }

    static IArtifactRepository getArtifactRepository(IProvisioningAgent agent, URI repoURL) {
        return (IArtifactRepository)ProvisioningHelper.getRepository(IArtifactRepositoryManager.class, agent, repoURL);
    }

    static long[] getProfileTimestamps(IProvisioningAgent agent, String profileId) {
        IProfileRegistry profileRegistry;
        if (profileId == null) {
            profileId = "_SELF_";
        }
        if ((profileRegistry = (IProfileRegistry)agent.getService(IProfileRegistry.class)) == null) {
            return null;
        }
        return profileRegistry.listProfileTimestamps(profileId);
    }

    static IStatus revertToPreviousState(IProvisioningAgent agent, IProfile profile, long revertToPreviousState) throws ProvisionException {
        IEngine engine = (IEngine)agent.getService(IEngine.class);
        if (engine == null) {
            throw new ProvisionException("No p2 engine found.");
        }
        IPlanner planner = (IPlanner)agent.getService(IPlanner.class);
        if (planner == null) {
            throw new ProvisionException("No planner found.");
        }
        IProfileRegistry profileRegistry = (IProfileRegistry)agent.getService(IProfileRegistry.class);
        if (profileRegistry == null) {
            throw new ProvisionException("profile registry cannot be null");
        }
        if (profile == null) {
            profile = ProvisioningHelper.getProfile(agent, "_SELF_");
        }
        IProfile targetProfile = null;
        if (revertToPreviousState == 0L) {
            long[] profiles = profileRegistry.listProfileTimestamps(profile.getProfileId());
            if (profiles.length == 0) {
                return Status.OK_STATUS;
            }
            targetProfile = profileRegistry.getProfile(profile.getProfileId(), profiles[profiles.length - 1]);
        } else {
            targetProfile = profileRegistry.getProfile(profile.getProfileId(), revertToPreviousState);
        }
        if (targetProfile == null) {
            throw new ProvisionException("target profile with timestamp=" + revertToPreviousState + " not found");
        }
        URI[] artifactRepos = (URI[])ProvisioningHelper.getArtifactRepositories(agent).toArray(URI[]::new);
        URI[] metadataRepos = (URI[])ProvisioningHelper.getMetadataRepositories(agent).toArray(URI[]::new);
        IProvisioningPlan plan = planner.getDiffPlan(profile, targetProfile, (IProgressMonitor)new NullProgressMonitor());
        ProvisioningContext context = new ProvisioningContext(agent);
        context.setMetadataRepositories(metadataRepos);
        context.setArtifactRepositories(artifactRepos);
        return PlanExecutionHelper.executePlan((IProvisioningPlan)plan, (IEngine)engine, (ProvisioningContext)context, (IProgressMonitor)new NullProgressMonitor());
    }

    static IStatus uninstall(IProvisioningAgent agent, String unitId, String version, IProfile profile, IProgressMonitor progress) throws ProvisionException {
        if (profile == null) {
            return null;
        }
        IQueryResult units = profile.query(QueryUtil.createIUQuery((String)unitId, (Version)Version.create((String)version)), progress);
        if (units.isEmpty()) {
            StringBuilder error = new StringBuilder();
            error.append("Installable unit not found: " + unitId + " " + version + "\n");
            error.append("Repositories searched:\n");
            for (URI repo : ProvisioningHelper.getMetadataRepositories(agent)) {
                error.append(String.valueOf(repo) + "\n");
            }
            throw new ProvisionException(error.toString());
        }
        IPlanner planner = (IPlanner)agent.getService(IPlanner.class);
        if (planner == null) {
            throw new ProvisionException("No planner service found.");
        }
        IEngine engine = (IEngine)agent.getService(IEngine.class);
        if (engine == null) {
            throw new ProvisionException("No engine service found.");
        }
        ProvisioningContext context = new ProvisioningContext(agent);
        IProfileChangeRequest request = planner.createChangeRequest(profile);
        request.removeAll((Collection)units.toUnmodifiableSet());
        IProvisioningPlan result = planner.getProvisioningPlan(request, context, progress);
        return PlanExecutionHelper.executePlan((IProvisioningPlan)result, (IEngine)engine, (ProvisioningContext)context, (IProgressMonitor)progress);
    }

    private static <T> IRepository<T> addRepository(Class<? extends IRepositoryManager<T>> repositoryManager, IProvisioningAgent agent, URI location, String nameSuffix, String repoType) {
        IRepositoryManager<T> manager = ProvisioningHelper.getRepositoryManager(agent, repositoryManager);
        try {
            return manager.loadRepository(location, null);
        }
        catch (ProvisionException e) {
            boolean createRepo = "file".equals(location.getScheme());
            if (!createRepo) {
                return null;
            }
            String repositoryName = String.valueOf(location) + " - " + nameSuffix;
            try {
                return manager.createRepository(location, repositoryName, repoType, null);
            }
            catch (ProvisionException e2) {
                return null;
            }
        }
    }

    private static <T> void removeRepository(Class<? extends IRepositoryManager<T>> repositoryManager, IProvisioningAgent agent, URI location) {
        IRepositoryManager<T> manager = ProvisioningHelper.getRepositoryManager(agent, repositoryManager);
        manager.removeRepository(location);
    }

    private static <T> IRepository<T> getRepository(Class<? extends IRepositoryManager<T>> repositoryManager, IProvisioningAgent agent, URI location) {
        IRepositoryManager<T> manager = ProvisioningHelper.getRepositoryManager(agent, repositoryManager);
        try {
            return manager.loadRepository(location, null);
        }
        catch (ProvisionException e) {
            return null;
        }
    }

    private static <T> List<URI> getRepositories(Class<? extends IRepositoryManager<T>> repositoryManager, IProvisioningAgent agent) {
        IRepositoryManager<T> manager = ProvisioningHelper.getRepositoryManager(agent, repositoryManager);
        URI[] repos = manager.getKnownRepositories(0);
        return Arrays.asList(repos);
    }

    private static <T> IRepositoryManager<T> getRepositoryManager(IProvisioningAgent agent, Class<? extends IRepositoryManager<T>> repositoryManager) {
        IRepositoryManager manager = (IRepositoryManager)agent.getService(repositoryManager);
        if (manager == null) {
            throw new IllegalStateException("No repository manager found for type " + String.valueOf(repositoryManager));
        }
        return manager;
    }
}

