/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.InternalHandlerUtil;
import org.eclipse.ui.internal.SaveablesList;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.handlers.AbstractSaveHandler;

public class SaveAllHandler
extends AbstractSaveHandler {
    public SaveAllHandler() {
        this.registerEnablement();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        EPartService partService;
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked(event);
        IWorkbenchPage page = window.getActivePage();
        if (page != null) {
            ((WorkbenchPage)page).saveAllEditors(false, false, true);
        }
        if ((partService = this.getPartService(window)) != null && partService.getDirtyParts().size() > 0) {
            partService.saveAll(false);
        }
        return null;
    }

    @Override
    protected EvaluationResult evaluate(IEvaluationContext context) {
        IWorkbenchWindow window = InternalHandlerUtil.getActiveWorkbenchWindow(context);
        if (window == null) {
            return EvaluationResult.FALSE;
        }
        WorkbenchPage page = (WorkbenchPage)window.getActivePage();
        if (page == null) {
            return EvaluationResult.FALSE;
        }
        if (page.getDirtyParts().length > 0) {
            return EvaluationResult.TRUE;
        }
        EPartService partService = this.getPartService(window);
        if (partService != null && partService.getDirtyParts().size() > 0) {
            return EvaluationResult.TRUE;
        }
        SaveablesList saveablesList = (SaveablesList)window.getWorkbench().getService(ISaveablesLifecycleListener.class);
        if (saveablesList == null) {
            return EvaluationResult.FALSE;
        }
        ISaveablesSource[] iSaveablesSourceArray = saveablesList.getNonPartSources();
        int n = iSaveablesSourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            Saveable[] saveables;
            ISaveablesSource nonPartSource = iSaveablesSourceArray[n2];
            Saveable[] saveableArray = saveables = nonPartSource.getSaveables();
            int n3 = saveables.length;
            int n4 = 0;
            while (n4 < n3) {
                Saveable saveable = saveableArray[n4];
                if (saveable.isDirty()) {
                    return EvaluationResult.TRUE;
                }
                ++n4;
            }
            ++n2;
        }
        return EvaluationResult.FALSE;
    }

    private EPartService getPartService(IWorkbenchWindow window) {
        EPartService partService = null;
        if (window instanceof WorkbenchWindow) {
            try {
                partService = (EPartService)((WorkbenchWindow)window).getModel().getContext().get(EPartService.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return partService;
    }
}

