/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.di;

import java.lang.annotation.Annotation;
import java.lang.invoke.LambdaMetafactory;
import java.lang.ref.WeakReference;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.e4.core.di.IBinding;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.suppliers.ExtendedObjectSupplier;
import org.eclipse.e4.core.di.suppliers.IObjectDescriptor;
import org.eclipse.e4.core.di.suppliers.IRequestor;
import org.eclipse.e4.core.di.suppliers.PrimaryObjectSupplier;
import org.eclipse.e4.core.internal.di.AnnotationLookup;
import org.eclipse.e4.core.internal.di.Binding;
import org.eclipse.e4.core.internal.di.ClassRequestor;
import org.eclipse.e4.core.internal.di.ConstructorRequestor;
import org.eclipse.e4.core.internal.di.FieldRequestor;
import org.eclipse.e4.core.internal.di.MethodRequestor;
import org.eclipse.e4.core.internal.di.ObjectDescriptor;
import org.eclipse.e4.core.internal.di.Requestor;
import org.eclipse.e4.core.internal.di.osgi.LogHelper;
import org.eclipse.e4.core.internal.di.osgi.ProviderHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class InjectorImpl
implements IInjector {
    private static final boolean shouldDebug = Boolean.getBoolean("org.eclipse.e4.core.di.debug");
    private static final String JAVA_OBJECT = "java.lang.Object";
    private static final Boolean DEFAULT_BOOLEAN = Boolean.FALSE;
    private static final Integer DEFAULT_INTEGER = 0;
    private static final Character DEFAULT_CHAR = Character.valueOf('\u0000');
    private static final Float DEFAULT_FLOAT = Float.valueOf(0.0f);
    private static final Double DEFAULT_DOUBLE = 0.0;
    private static final Long DEFAULT_LONG = 0L;
    private static final Short DEFAULT_SHORT = 0;
    private static final Byte DEFAULT_BYTE = 0;
    private final Map<PrimaryObjectSupplier, Set<IdentityWeakReference<?>>> injectedObjects = new WeakHashMap();
    private final Set<IdentityWeakReference<Class<?>>> injectedClasses = new LinkedHashSet();
    private final Map<Class<?>, Object> singletonCache = new HashMap();
    private final Map<Class<?>, Set<Binding>> bindings = new HashMap();
    private final Map<AnnotationLookup.AnnotationProxy, Map<AnnotatedElement, Boolean>> annotationsPresent = new HashMap<AnnotationLookup.AnnotationProxy, Map<AnnotatedElement, Boolean>>();
    private final Map<Class<?>, Method[]> methodsCache = Collections.synchronizedMap(new WeakHashMap());
    private final Map<Class<?>, Field[]> fieldsCache = Collections.synchronizedMap(new WeakHashMap());
    private final Map<Class<?>, Constructor<?>[]> constructorsCache = Collections.synchronizedMap(new WeakHashMap());
    private final Map<Class<?>, Map<Method, Boolean>> isOverriddenCache = Collections.synchronizedMap(new WeakHashMap());
    private final Set<Class<?>> classesBeingCreated = new HashSet(5);
    private volatile PrimaryObjectSupplier defaultSupplier;

    @Override
    public void inject(Object object, PrimaryObjectSupplier objectSupplier) {
        try {
            this.internalInject(object, objectSupplier, null);
        }
        catch (NoClassDefFoundError | NoSuchMethodError e) {
            throw new InjectionException(e);
        }
    }

    @Override
    public void inject(Object object, PrimaryObjectSupplier objectSupplier, PrimaryObjectSupplier staticSupplier) throws InjectionException {
        try {
            this.internalInject(object, objectSupplier, staticSupplier);
        }
        catch (NoClassDefFoundError | NoSuchMethodError e) {
            throw new InjectionException(e);
        }
    }

    private void internalInject(Object object, PrimaryObjectSupplier objectSupplier, PrimaryObjectSupplier tempSupplier) {
        ArrayList requestors = new ArrayList();
        this.processClassHierarchy(object, objectSupplier, tempSupplier, true, true, requestors);
        boolean haveLink = false;
        for (Requestor<?> requestor : requestors) {
            if (!requestor.shouldTrack()) continue;
            haveLink = true;
        }
        if (!haveLink) {
            requestors.add(new ClassRequestor(object.getClass(), (IInjector)this, objectSupplier, tempSupplier, object, true));
        }
        this.resolveRequestorArgs(requestors, objectSupplier, tempSupplier, false, true, true);
        for (Requestor<?> requestor : requestors) {
            if (!requestor.isResolved()) continue;
            requestor.execute();
        }
        this.rememberInjectedObject(object, objectSupplier);
        this.processAnnotated(AnnotationLookup.POST_CONSTRUCT, object, object.getClass(), objectSupplier, tempSupplier, new ArrayList(5));
        for (Requestor<?> requestor : requestors) {
            requestor.clearTempSupplier();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rememberInjectedObject(Object object, PrimaryObjectSupplier objectSupplier) {
        Map<PrimaryObjectSupplier, Set<IdentityWeakReference<?>>> map = this.injectedObjects;
        synchronized (map) {
            this.injectedObjects.computeIfAbsent(objectSupplier, k -> new LinkedHashSet()).add(new IdentityWeakReference<Object>(object));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean forgetInjectedObject(Object object, PrimaryObjectSupplier objectSupplier) {
        Map<PrimaryObjectSupplier, Set<IdentityWeakReference<?>>> map = this.injectedObjects;
        synchronized (map) {
            Set<IdentityWeakReference<?>> set = this.injectedObjects.get(objectSupplier);
            if (set != null) {
                return set.remove(new IdentityWeakReference<Object>(object));
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<IdentityWeakReference<?>> forgetSupplier(PrimaryObjectSupplier objectSupplier) {
        Map<PrimaryObjectSupplier, Set<IdentityWeakReference<?>>> map = this.injectedObjects;
        synchronized (map) {
            return this.injectedObjects.remove(objectSupplier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<IdentityWeakReference<?>> getSupplierObjects(PrimaryObjectSupplier objectSupplier) {
        Map<PrimaryObjectSupplier, Set<IdentityWeakReference<?>>> map = this.injectedObjects;
        synchronized (map) {
            return this.injectedObjects.get(objectSupplier);
        }
    }

    @Override
    public void uninject(Object object, PrimaryObjectSupplier objectSupplier) {
        try {
            if (!this.forgetInjectedObject(object, objectSupplier)) {
                return;
            }
            this.processAnnotated(AnnotationLookup.PRE_DESTROY, object, object.getClass(), objectSupplier, null, new ArrayList(5));
            ArrayList requestors = new ArrayList();
            this.processClassHierarchy(object, objectSupplier, null, true, false, requestors);
            for (Requestor requestor : requestors) {
                Object[] actualArgs = this.resolveArgs(requestor, null, null, true, false, false);
                int unresolved = this.unresolved(actualArgs);
                if (unresolved == -1) {
                    requestor.setResolvedArgs(actualArgs);
                    requestor.execute();
                    continue;
                }
                if (requestor.isOptional()) {
                    requestor.setResolvedArgs(null);
                    continue;
                }
                if (!shouldDebug) continue;
                StringBuilder tmp = new StringBuilder();
                tmp.append("Uninjecting object \"");
                tmp.append(object.toString());
                tmp.append("\": dependency on \"");
                tmp.append(requestor.getDependentObjects()[unresolved].toString());
                tmp.append("\" is not optional.");
                LogHelper.logError(tmp.toString(), null);
            }
        }
        catch (NoClassDefFoundError | NoSuchMethodError e) {
            throw new InjectionException(e);
        }
    }

    @Override
    public Object invoke(Object object, Class<? extends Annotation> qualifier, PrimaryObjectSupplier objectSupplier) {
        Object result = this.invokeUsingClass(object, object.getClass(), qualifier, IInjector.NOT_A_VALUE, objectSupplier, null, true, true, false);
        if (result == IInjector.NOT_A_VALUE) {
            if (object != null && qualifier != null) {
                throw new InjectionException("Unable to find matching method to invoke. Searching for the annotation \"" + String.valueOf(qualifier) + "\" on an instance of \"" + object.getClass().getSimpleName() + "\"");
            }
            throw new InjectionException("Unable to find matching method to invoke. One of the arguments was null.");
        }
        return result;
    }

    @Override
    public Object invoke(Object object, Class<? extends Annotation> qualifier, Object defaultValue, PrimaryObjectSupplier objectSupplier) {
        return this.invokeUsingClass(object, object.getClass(), qualifier, defaultValue, objectSupplier, null, false, true, false);
    }

    @Override
    public Object invoke(Object object, Class<? extends Annotation> qualifier, Object defaultValue, PrimaryObjectSupplier objectSupplier, PrimaryObjectSupplier localSupplier) {
        return this.invokeUsingClass(object, object.getClass(), qualifier, defaultValue, objectSupplier, localSupplier, false, true, false);
    }

    public Object invoke(Object object, Class<? extends Annotation> qualifier, Object defaultValue, PrimaryObjectSupplier objectSupplier, PrimaryObjectSupplier localSupplier, boolean initial, boolean track) {
        return this.invokeUsingClass(object, object.getClass(), qualifier, defaultValue, objectSupplier, null, false, initial, track);
    }

    private Object invokeUsingClass(Object userObject, Class<?> currentClass, Class<? extends Annotation> qualifier, Object defaultValue, PrimaryObjectSupplier objectSupplier, PrimaryObjectSupplier tempSupplier, boolean throwUnresolved, boolean initial, boolean track) {
        Method[] methods;
        Method[] methodArray = methods = this.getDeclaredMethods(currentClass);
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getAnnotation(qualifier) != null) {
                MethodRequestor requestor = new MethodRequestor(method, (IInjector)this, objectSupplier, tempSupplier, userObject, track);
                Object[] actualArgs = this.resolveArgs(requestor, objectSupplier, tempSupplier, false, initial, track);
                int unresolved = this.unresolved(actualArgs);
                if (unresolved != -1) {
                    if (throwUnresolved) {
                        this.reportUnresolvedArgument(requestor, unresolved);
                    }
                } else {
                    requestor.setResolvedArgs(actualArgs);
                    return requestor.execute();
                }
            }
            ++n2;
        }
        Class<?> superClass = currentClass.getSuperclass();
        if (superClass == null) {
            return defaultValue;
        }
        return this.invokeUsingClass(userObject, superClass, qualifier, defaultValue, objectSupplier, tempSupplier, throwUnresolved, initial, track);
    }

    @Override
    public <T> T make(Class<T> clazz, PrimaryObjectSupplier objectSupplier) {
        Class<?> implementationClass = this.getImplementationClass(clazz);
        return clazz.cast(this.internalMake(implementationClass, objectSupplier, null));
    }

    private Class<?> getImplementationClass(Class<?> clazz) {
        ObjectDescriptor descriptor = new ObjectDescriptor(clazz, null);
        Binding binding = this.findBinding(descriptor);
        if (binding == null) {
            return this.getDesiredClass(descriptor.getDesiredType());
        }
        return binding.getImplementationClass();
    }

    @Override
    public <T> T make(Class<T> clazz, PrimaryObjectSupplier objectSupplier, PrimaryObjectSupplier staticSupplier) {
        Class<?> implementationClass = this.getImplementationClass(clazz);
        return clazz.cast(this.internalMake(implementationClass, objectSupplier, staticSupplier));
    }

    public Object makeFromProvider(IObjectDescriptor descriptor, PrimaryObjectSupplier objectSupplier) {
        Binding binding = this.findBinding(descriptor);
        Class<?> implementationClass = binding == null ? this.getProviderType(descriptor.getDesiredType()) : binding.getImplementationClass();
        if (objectSupplier != null) {
            ObjectDescriptor actualClass = new ObjectDescriptor(implementationClass, null);
            Object[] actualArgs = new Object[]{IInjector.NOT_A_VALUE};
            objectSupplier.get(new IObjectDescriptor[]{actualClass}, actualArgs, null, false, true, false);
            if (actualArgs[0] != IInjector.NOT_A_VALUE) {
                return actualArgs[0];
            }
        }
        return this.internalMake(implementationClass, objectSupplier, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object internalMake(Class<?> clazz, PrimaryObjectSupplier objectSupplier, PrimaryObjectSupplier tempSupplier) {
        if (InjectorImpl.shouldDebug && this.classesBeingCreated.contains(clazz)) {
            LogHelper.logWarning("Possible recursive reference trying to create class \"" + clazz.getName() + "\".", null);
        }
        try {
            if (InjectorImpl.shouldDebug) {
                this.classesBeingCreated.add(clazz);
            }
            if (isSingleton = this.isAnnotationPresent(clazz, AnnotationLookup.SINGLETON)) {
                var5_6 = this.singletonCache;
                synchronized (var5_6) {
                    if (this.singletonCache.containsKey(clazz)) {
                        var15_7 = this.singletonCache.get(clazz);
                        return var15_7;
                    }
                    ** finally { 
                }
            }
            constructors = this.getDeclaredConstructors(clazz);
            sortedConstructors = new ArrayList<Constructor>(constructors.length);
            sortedConstructors.addAll(Arrays.asList(constructors));
            sortedConstructors.sort(Comparator.comparing((Function<Constructor, Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$1(java.lang.reflect.Constructor ), (Ljava/lang/reflect/Constructor;)Ljava/lang/Integer;)(), Comparator.reverseOrder()));
            var8_10 = sortedConstructors.iterator();
            while (true) {
                block22: {
                    if (var8_10.hasNext()) break block22;
                    throw new InjectionException("Could not find satisfiable constructor in " + clazz.getName());
                }
                constructor = (Constructor)var8_10.next();
                modifiers = constructor.getModifiers();
                if ((modifiers & 2) != 0 || (modifiers & 4) != 0 || !this.isAnnotationPresent(constructor, AnnotationLookup.INJECT) && constructor.getParameterTypes().length != 0 || this.unresolved(actualArgs = this.resolveArgs(requestor = new ConstructorRequestor(constructor, this, objectSupplier, tempSupplier), objectSupplier, tempSupplier, false, true, false)) != -1) continue;
                requestor.setResolvedArgs(actualArgs);
                newInstance = requestor.execute();
                if (newInstance != null) break;
            }
            this.internalInject(newInstance, objectSupplier, tempSupplier);
            if (isSingleton) {
                var13_16 = this.singletonCache;
                synchronized (var13_16) {
                    this.singletonCache.put(clazz, newInstance);
                }
            }
            var15_8 = newInstance;
            return var15_8;
        }
        catch (NoClassDefFoundError | NoSuchMethodError e) {
            throw new InjectionException(e);
        }
        finally {
            if (InjectorImpl.shouldDebug) {
                this.classesBeingCreated.remove(clazz);
            }
        }
    }

    public void resolveArguments(IRequestor requestor, boolean initial) {
        Requestor internalRequestor = (Requestor)requestor;
        Object[] actualArgs = this.resolveArgs(internalRequestor, internalRequestor.getPrimarySupplier(), internalRequestor.getTempSupplier(), false, initial, internalRequestor.shouldTrack());
        int unresolved = this.unresolved(actualArgs);
        if (unresolved == -1) {
            internalRequestor.setResolvedArgs(actualArgs);
        } else if (internalRequestor.isOptional()) {
            internalRequestor.setResolvedArgs(null);
        } else {
            String msg = this.resolutionError(internalRequestor, unresolved);
            LogHelper.logError(msg, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void disposed(PrimaryObjectSupplier objectSupplier) {
        void var5_8;
        Set<IdentityWeakReference<?>> references = this.getSupplierObjects(objectSupplier);
        if (references == null) {
            return;
        }
        Object[] objects = new Object[references.size()];
        int count = 0;
        for (WeakReference weakReference : references) {
            Object object = weakReference.get();
            if (object == null) continue;
            objects[count] = object;
            ++count;
        }
        boolean bl = false;
        while (var5_8 < count) {
            Object object = objects[var5_8];
            if (this.forgetInjectedObject(object, objectSupplier)) {
                this.processAnnotated(AnnotationLookup.PRE_DESTROY, object, object.getClass(), objectSupplier, null, new ArrayList(5));
            }
            ++var5_8;
        }
        this.forgetSupplier(objectSupplier);
    }

    private void resolveRequestorArgs(ArrayList<Requestor<?>> requestors, PrimaryObjectSupplier objectSupplier, PrimaryObjectSupplier tempSupplier, boolean uninject, boolean initial, boolean track) {
        for (Requestor<?> requestor : requestors) {
            Object[] actualArgs = this.resolveArgs(requestor, objectSupplier, tempSupplier, uninject, initial, track);
            int unresolved = this.unresolved(actualArgs);
            if (unresolved == -1) {
                requestor.setResolvedArgs(actualArgs);
                continue;
            }
            if (requestor.isOptional()) {
                requestor.setResolvedArgs(null);
                continue;
            }
            this.reportUnresolvedArgument(requestor, unresolved);
        }
    }

    private void reportUnresolvedArgument(Requestor<?> requestor, int argIndex) {
        String msg = this.resolutionError(requestor, argIndex);
        if (shouldDebug) {
            LogHelper.logError(msg, null);
        }
        throw new InjectionException(msg);
    }

    private String resolutionError(Requestor<?> requestor, int argIndex) {
        StringBuilder tmp = new StringBuilder();
        tmp.append("Unable to process \"");
        tmp.append(requestor.toString());
        tmp.append("\": no actual value was found for the argument \"");
        tmp.append(requestor.getDependentObjects()[argIndex].toString());
        tmp.append("\".");
        return tmp.toString();
    }

    private Object[] resolveArgs(Requestor<?> requestor, PrimaryObjectSupplier objectSupplier, PrimaryObjectSupplier tempSupplier, boolean uninject, boolean initial, boolean track) {
        Object EOS_NOT_A_VALUE = new Object();
        IObjectDescriptor[] descriptors = requestor.getDependentObjects();
        Object[] actualArgs = new Object[descriptors.length];
        Arrays.fill(actualArgs, NOT_A_VALUE);
        int i = 0;
        while (i < actualArgs.length) {
            Class<?> providerClass = this.getProviderType(descriptors[i].getDesiredType());
            if (providerClass != null) {
                actualArgs[i] = AnnotationLookup.getProvider(descriptors[i], this, objectSupplier);
            }
            ++i;
        }
        i = 0;
        while (i < actualArgs.length) {
            ExtendedObjectSupplier extendedSupplier;
            if (actualArgs[i] == NOT_A_VALUE && (extendedSupplier = this.findExtendedSupplier(descriptors[i])) != null) {
                actualArgs[i] = extendedSupplier.get(descriptors[i], requestor, requestor.shouldTrack() && track, requestor.shouldGroupUpdates());
                if (actualArgs[i] == NOT_A_VALUE) {
                    actualArgs[i] = EOS_NOT_A_VALUE;
                }
            }
            ++i;
        }
        if (tempSupplier != null) {
            tempSupplier.get(descriptors, actualArgs, requestor, initial, false, requestor.shouldGroupUpdates());
        }
        if (objectSupplier != null) {
            objectSupplier.get(descriptors, actualArgs, requestor, initial, requestor.shouldTrack() && track, requestor.shouldGroupUpdates());
        }
        i = 0;
        while (i < actualArgs.length) {
            Binding binding;
            if (actualArgs[i] == NOT_A_VALUE && (binding = this.findBinding(descriptors[i])) != null) {
                actualArgs[i] = this.internalMake(binding.getImplementationClass(), objectSupplier, tempSupplier);
            }
            ++i;
        }
        if (!uninject && !requestor.isOptional()) {
            i = 0;
            while (i < actualArgs.length) {
                if (actualArgs[i] == NOT_A_VALUE && !descriptors[i].hasQualifier(Optional.class)) {
                    try {
                        Class<?> desiredClass = this.getDesiredClass(descriptors[i].getDesiredType());
                        Creatable creatableAnnotation = desiredClass.getAnnotation(Creatable.class);
                        if (creatableAnnotation != null) {
                            actualArgs[i] = this.internalMake(this.getDesiredClass(descriptors[i].getDesiredType()), objectSupplier, tempSupplier);
                        }
                    }
                    catch (InjectionException e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
        }
        i = 0;
        while (i < descriptors.length) {
            Class<Object> descriptorsClass;
            if (actualArgs[i] != null && actualArgs[i] != IInjector.NOT_A_VALUE && actualArgs[i] != EOS_NOT_A_VALUE) {
                descriptorsClass = this.getDesiredClass(descriptors[i].getDesiredType());
                if (descriptorsClass.isPrimitive()) {
                    if (descriptorsClass.equals(Boolean.TYPE)) {
                        descriptorsClass = Boolean.class;
                    } else if (descriptorsClass.equals(Integer.TYPE)) {
                        descriptorsClass = Integer.class;
                    } else if (descriptorsClass.equals(Character.TYPE)) {
                        descriptorsClass = Character.class;
                    } else if (descriptorsClass.equals(Float.TYPE)) {
                        descriptorsClass = Float.class;
                    } else if (descriptorsClass.equals(Double.TYPE)) {
                        descriptorsClass = Double.class;
                    } else if (descriptorsClass.equals(Long.TYPE)) {
                        descriptorsClass = Long.class;
                    } else if (descriptorsClass.equals(Short.TYPE)) {
                        descriptorsClass = Short.class;
                    } else if (descriptorsClass.equals(Byte.TYPE)) {
                        descriptorsClass = Byte.class;
                    }
                }
                if (!descriptorsClass.isAssignableFrom(actualArgs[i].getClass())) {
                    actualArgs[i] = IInjector.NOT_A_VALUE;
                }
            }
            if (actualArgs[i] == IInjector.NOT_A_VALUE || actualArgs[i] == EOS_NOT_A_VALUE) {
                if (descriptors[i].hasQualifier(Optional.class)) {
                    descriptorsClass = this.getDesiredClass(descriptors[i].getDesiredType());
                    if (descriptorsClass.isPrimitive()) {
                        if (descriptorsClass.equals(Boolean.TYPE)) {
                            actualArgs[i] = DEFAULT_BOOLEAN;
                        } else if (descriptorsClass.equals(Integer.TYPE)) {
                            actualArgs[i] = DEFAULT_INTEGER;
                        } else if (descriptorsClass.equals(Character.TYPE)) {
                            actualArgs[i] = DEFAULT_CHAR;
                        } else if (descriptorsClass.equals(Float.TYPE)) {
                            actualArgs[i] = DEFAULT_FLOAT;
                        } else if (descriptorsClass.equals(Double.TYPE)) {
                            actualArgs[i] = DEFAULT_DOUBLE;
                        } else if (descriptorsClass.equals(Long.TYPE)) {
                            actualArgs[i] = DEFAULT_LONG;
                        } else if (descriptorsClass.equals(Short.TYPE)) {
                            actualArgs[i] = DEFAULT_SHORT;
                        } else if (descriptorsClass.equals(Byte.TYPE)) {
                            actualArgs[i] = DEFAULT_BYTE;
                        }
                    } else {
                        actualArgs[i] = null;
                    }
                } else if (actualArgs[i] == EOS_NOT_A_VALUE) {
                    actualArgs[i] = IInjector.NOT_A_VALUE;
                }
            }
            ++i;
        }
        return actualArgs;
    }

    private ExtendedObjectSupplier findExtendedSupplier(IObjectDescriptor descriptor) {
        Annotation[] qualifiers = descriptor.getQualifiers();
        if (qualifiers == null) {
            return null;
        }
        Annotation[] annotationArray = qualifiers;
        int n = qualifiers.length;
        int n2 = 0;
        while (n2 < n) {
            ExtendedObjectSupplier supplier;
            Annotation qualifier = annotationArray[n2];
            Class<? extends Annotation> type = qualifier.annotationType();
            String key = type.getName();
            try {
                supplier = ProviderHelper.findProvider(key, this.defaultSupplier);
            }
            catch (NoClassDefFoundError e) {
                return null;
            }
            if (supplier != null) {
                return supplier;
            }
            ++n2;
        }
        return null;
    }

    private int unresolved(Object[] actualArgs) {
        int i = 0;
        while (i < actualArgs.length) {
            if (actualArgs[i] == IInjector.NOT_A_VALUE) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void processClassHierarchy(Object userObject, PrimaryObjectSupplier objectSupplier, PrimaryObjectSupplier tempSupplier, boolean track, boolean normalOrder, List<Requestor<?>> requestors) {
        this.processClass(userObject, objectSupplier, tempSupplier, userObject == null ? null : userObject.getClass(), new ArrayList(5), track, normalOrder, requestors);
    }

    private void processClass(Object userObject, PrimaryObjectSupplier objectSupplier, PrimaryObjectSupplier tempSupplier, Class<?> objectsClass, ArrayList<Class<?>> classHierarchy, boolean track, boolean normalOrder, List<Requestor<?>> requestors) {
        boolean injectedStaticMethods;
        boolean injectedStaticFields;
        Class<?> superClass;
        if (objectsClass != null && (superClass = objectsClass.getSuperclass()) != null && !superClass.getName().equals(JAVA_OBJECT)) {
            classHierarchy.add(objectsClass);
            this.processClass(userObject, objectSupplier, tempSupplier, superClass, classHierarchy, track, normalOrder, requestors);
            classHierarchy.remove(objectsClass);
        }
        if (normalOrder) {
            injectedStaticFields = this.processFields(userObject, objectSupplier, tempSupplier, objectsClass, track, requestors);
            injectedStaticMethods = this.processMethods(userObject, objectSupplier, tempSupplier, objectsClass, classHierarchy, track, requestors);
        } else {
            injectedStaticMethods = this.processMethods(userObject, objectSupplier, tempSupplier, objectsClass, classHierarchy, track, requestors);
            injectedStaticFields = this.processFields(userObject, objectSupplier, tempSupplier, objectsClass, track, requestors);
        }
        if (injectedStaticFields || injectedStaticMethods) {
            this.rememberInjectedStatic(objectsClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasInjectedStatic(Class<?> objectsClass) {
        Set<IdentityWeakReference<Class<?>>> set = this.injectedClasses;
        synchronized (set) {
            return this.injectedClasses.contains(new IdentityWeakReference(objectsClass));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rememberInjectedStatic(Class<?> objectsClass) {
        Set<IdentityWeakReference<Class<?>>> set = this.injectedClasses;
        synchronized (set) {
            this.injectedClasses.add(new IdentityWeakReference(objectsClass));
        }
    }

    private boolean processFields(Object userObject, PrimaryObjectSupplier objectSupplier, PrimaryObjectSupplier tempSupplier, Class<?> objectsClass, boolean track, List<Requestor<?>> requestors) {
        Field[] fields;
        boolean injectedStatic = false;
        Field[] fieldArray = fields = this.getDeclaredFields(objectsClass);
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                Field field;
                block5: {
                    field = fieldArray[n2];
                    if (!Modifier.isStatic(field.getModifiers())) break block5;
                    if (this.hasInjectedStatic(objectsClass)) break block6;
                    injectedStatic = true;
                }
                if (this.isAnnotationPresent(field, AnnotationLookup.INJECT)) {
                    requestors.add(new FieldRequestor(field, (IInjector)this, objectSupplier, tempSupplier, userObject, track));
                }
            }
            ++n2;
        }
        return injectedStatic;
    }

    private boolean processMethods(Object userObject, PrimaryObjectSupplier objectSupplier, PrimaryObjectSupplier tempSupplier, Class<?> objectsClass, ArrayList<Class<?>> classHierarchy, boolean track, List<Requestor<?>> requestors) {
        Method[] methods;
        boolean injectedStatic = false;
        Method[] methodArray = methods = this.getDeclaredMethods(objectsClass);
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            block8: {
                Method method;
                block9: {
                    method = methodArray[n2];
                    Boolean isOverridden = null;
                    Class<?> originalClass = userObject.getClass();
                    Map<Method, Boolean> methodMap = this.isOverriddenCache.get(originalClass);
                    if (methodMap != null) {
                        isOverridden = methodMap.get(method);
                    }
                    if (isOverridden == null) {
                        isOverridden = this.isOverridden(method, classHierarchy);
                        if (methodMap == null) {
                            methodMap = Collections.synchronizedMap(new WeakHashMap());
                            this.isOverriddenCache.put(originalClass, methodMap);
                        }
                        methodMap.put(method, isOverridden);
                    }
                    if (isOverridden.booleanValue()) break block8;
                    if (!Modifier.isStatic(method.getModifiers())) break block9;
                    if (this.hasInjectedStatic(objectsClass)) break block8;
                    injectedStatic = true;
                }
                if (this.isAnnotationPresent(method, AnnotationLookup.INJECT)) {
                    requestors.add(new MethodRequestor(method, (IInjector)this, objectSupplier, tempSupplier, userObject, track));
                }
            }
            ++n2;
        }
        return injectedStatic;
    }

    private boolean isOverridden(Method method, List<Class<?>> classHierarchy) {
        int modifiers = method.getModifiers();
        if (Modifier.isPrivate(modifiers)) {
            return false;
        }
        if (Modifier.isStatic(modifiers)) {
            return false;
        }
        boolean isDefault = !Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers);
        String methodName = method.getName();
        Class<?>[] methodParams = method.getParameterTypes();
        int methodParamsLength = method.getParameterTypes().length;
        for (Class<?> subClass : classHierarchy) {
            Method[] methods = this.getDeclaredMethods(subClass);
            Method matchingMethod = null;
            Method[] methodArray = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?>[] candidateParams;
                Method candidate = methodArray[n2];
                if (methodName.equals(candidate.getName()) && (candidateParams = candidate.getParameterTypes()).length == methodParamsLength) {
                    boolean paramsMatch = true;
                    int i = 0;
                    while (i < methodParamsLength) {
                        if (!candidateParams[i].equals(methodParams[i])) {
                            paramsMatch = false;
                        }
                        ++i;
                    }
                    if (paramsMatch) {
                        matchingMethod = candidate;
                        break;
                    }
                }
                ++n2;
            }
            if (matchingMethod == null) continue;
            if (isDefault) {
                Package originalPackage = method.getDeclaringClass().getPackage();
                Package overridePackage = subClass.getPackage();
                if (originalPackage == null && overridePackage == null) {
                    return true;
                }
                if (originalPackage == null || overridePackage == null) {
                    return false;
                }
                if (!originalPackage.equals(overridePackage)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private Constructor<?>[] getDeclaredConstructors(Class<?> c) {
        Constructor<?>[] constructors = this.constructorsCache.get(c);
        if (constructors == null) {
            constructors = c.getDeclaredConstructors();
            Arrays.sort(constructors, (c1, c2) -> {
                int l1 = c1.getParameterTypes().length;
                int l2 = c2.getParameterTypes().length;
                return l2 - l1;
            });
            this.constructorsCache.put(c, constructors);
        }
        return constructors;
    }

    private Method[] getDeclaredMethods(Class<?> c) {
        Method[] methods = this.methodsCache.get(c);
        if (methods == null) {
            methods = (Method[])Stream.of(c.getDeclaredMethods()).filter(m -> !m.isBridge()).toArray(Method[]::new);
            this.methodsCache.put(c, methods);
        }
        return methods;
    }

    private Field[] getDeclaredFields(Class<?> c) {
        Field[] fields = this.fieldsCache.get(c);
        if (fields == null) {
            fields = c.getDeclaredFields();
            this.fieldsCache.put(c, fields);
        }
        return fields;
    }

    private Class<?> getDesiredClass(Type desiredType) {
        Type rawType;
        if (desiredType instanceof Class) {
            return (Class)desiredType;
        }
        if (desiredType instanceof ParameterizedType && (rawType = ((ParameterizedType)desiredType).getRawType()) instanceof Class) {
            return (Class)rawType;
        }
        return null;
    }

    private Class<?> getProviderType(Type type) {
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        Type rawType = ((ParameterizedType)type).getRawType();
        if (!AnnotationLookup.isProvider(rawType)) {
            return null;
        }
        Type[] actualTypes = ((ParameterizedType)type).getActualTypeArguments();
        if (actualTypes.length != 1) {
            return null;
        }
        if (!(actualTypes[0] instanceof Class)) {
            return null;
        }
        return (Class)actualTypes[0];
    }

    @Override
    public IBinding addBinding(Class<?> clazz) {
        return this.addBinding(new Binding(clazz, this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBinding addBinding(IBinding binding) {
        Binding internalBinding = (Binding)binding;
        Class<?> clazz = internalBinding.getDescribedClass();
        Map<Class<?>, Set<Binding>> map = this.bindings;
        synchronized (map) {
            if (this.bindings.containsKey(clazz)) {
                Set<Binding> collection = this.bindings.get(clazz);
                String desiredQualifierName = internalBinding.getQualifierName();
                Iterator<Binding> i = collection.iterator();
                while (i.hasNext()) {
                    Binding collectionBinding = i.next();
                    if (!this.eq(collectionBinding.getQualifierName(), desiredQualifierName)) continue;
                    i.remove();
                    break;
                }
                collection.add(internalBinding);
            } else {
                HashSet<Binding> collection = new HashSet<Binding>(1);
                collection.add(internalBinding);
                this.bindings.put(clazz, collection);
            }
        }
        return binding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Binding findBinding(IObjectDescriptor descriptor) {
        Class<?> desiredClass = this.getProviderType(descriptor.getDesiredType());
        if (desiredClass == null) {
            desiredClass = this.getDesiredClass(descriptor.getDesiredType());
        }
        Map<Class<?>, Set<Binding>> map = this.bindings;
        synchronized (map) {
            Annotation[] annotations;
            Set<Binding> collection;
            block9: {
                collection = this.bindings.get(desiredClass);
                if (collection != null) break block9;
                return null;
            }
            String desiredQualifierName = AnnotationLookup.getQualifierValue(descriptor);
            if (desiredQualifierName == null && (annotations = descriptor.getQualifiers()) != null) {
                Annotation[] annotationArray = annotations;
                if (annotations.length != 0) {
                    Annotation annotation = annotationArray[0];
                    desiredQualifierName = annotation.annotationType().getName();
                }
            }
            for (Binding collectionBinding : collection) {
                if (!this.eq(collectionBinding.getQualifierName(), desiredQualifierName)) continue;
                return collectionBinding;
            }
            desiredQualifierName = desiredClass.getName();
            for (Binding collectionBinding : collection) {
                String simpleClassName;
                Class<?> bindingClass = collectionBinding.getDescribedClass();
                if (bindingClass == null || !this.eq(simpleClassName = bindingClass.getName(), desiredQualifierName)) continue;
                return collectionBinding;
            }
        }
        return null;
    }

    private boolean eq(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return true;
        }
        if (str1 == null || str2 == null) {
            return false;
        }
        return str1.equals(str2);
    }

    private void processAnnotated(AnnotationLookup.AnnotationProxy annotation, Object userObject, Class<?> objectClass, PrimaryObjectSupplier objectSupplier, PrimaryObjectSupplier tempSupplier, List<Class<?>> classHierarchy) {
        Method[] methods;
        Class<?> superClass = objectClass.getSuperclass();
        if (superClass != null && !superClass.getName().equals(JAVA_OBJECT)) {
            classHierarchy.add(objectClass);
            this.processAnnotated(annotation, userObject, superClass, objectSupplier, tempSupplier, classHierarchy);
            classHierarchy.remove(objectClass);
        }
        Method[] methodArray = methods = this.getDeclaredMethods(objectClass);
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            block10: {
                Object[] actualArgs;
                MethodRequestor requestor;
                block11: {
                    Method method;
                    block9: {
                        method = methodArray[n2];
                        if (this.isAnnotationPresent(method, annotation)) break block9;
                        if (shouldDebug) {
                            Annotation[] annotationArray = method.getAnnotations();
                            int n3 = annotationArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                Annotation a = annotationArray[n4];
                                if (annotation.classes().stream().map(Class::getName).anyMatch(a.annotationType().getName()::equals)) {
                                    StringBuilder tmp = new StringBuilder();
                                    tmp.append("Possbible annotation mismatch: method \"");
                                    tmp.append(method.toString());
                                    tmp.append("\" annotated with \"");
                                    tmp.append(InjectorImpl.describeClass(a.annotationType()));
                                    tmp.append("\" but was looking for \"");
                                    tmp.append(annotation.classes().stream().map(InjectorImpl::describeClass).collect(Collectors.joining(System.lineSeparator() + " or ")));
                                    tmp.append("\"");
                                    LogHelper.logWarning(tmp.toString(), null);
                                }
                                ++n4;
                            }
                        }
                        break block10;
                    }
                    if (this.isOverridden(method, classHierarchy)) break block10;
                    requestor = new MethodRequestor(method, (IInjector)this, objectSupplier, tempSupplier, userObject, false);
                    actualArgs = this.resolveArgs(requestor, objectSupplier, tempSupplier, false, false, false);
                    int unresolved = this.unresolved(actualArgs);
                    if (unresolved == -1) break block11;
                    if (this.isAnnotationPresent(method, AnnotationLookup.OPTIONAL)) break block10;
                    this.reportUnresolvedArgument(requestor, unresolved);
                }
                requestor.setResolvedArgs(actualArgs);
                requestor.execute();
            }
            ++n2;
        }
    }

    private static String describeClass(Class<?> cl) {
        Bundle b = FrameworkUtil.getBundle(cl);
        if (b != null) {
            return b.getSymbolicName() + ":" + String.valueOf(b.getVersion()) + ":" + cl.getName();
        }
        CodeSource clazzCS = cl.getProtectionDomain().getCodeSource();
        if (clazzCS != null) {
            return String.valueOf(clazzCS.getLocation()) + ">" + cl.getName();
        }
        if (cl.getClassLoader() == null) {
            return cl.getName() + " [via bootstrap classloader]";
        }
        return cl.getName();
    }

    @Override
    public void setDefaultSupplier(PrimaryObjectSupplier objectSupplier) {
        this.defaultSupplier = objectSupplier;
    }

    private boolean isAnnotationPresent(AnnotatedElement annotatedElement, AnnotationLookup.AnnotationProxy lookUp) {
        Map cache = this.annotationsPresent.computeIfAbsent(lookUp, a -> Collections.synchronizedMap(new WeakHashMap()));
        return cache.computeIfAbsent(annotatedElement, lookUp::isPresent);
    }

    private static /* synthetic */ Integer lambda$1(Constructor c) {
        return c.getParameterTypes().length;
    }

    private static class IdentityWeakReference<T>
    extends WeakReference<T> {
        private final int hashCode;

        IdentityWeakReference(T referent) {
            super(referent);
            this.hashCode = System.identityHashCode(referent);
        }

        public boolean equals(Object obj) {
            if (obj instanceof IdentityWeakReference) {
                IdentityWeakReference other = (IdentityWeakReference)obj;
                return other.get() == this.get();
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

