/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.projectconfig.presentation;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.MarkerHelper;
import org.eclipse.emf.common.ui.editor.ProblemEditorPart;
import org.eclipse.emf.common.ui.viewer.ColumnViewerInformationControlToolTipSupport;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.DecoratingColumLabelProvider;
import org.eclipse.emf.edit.ui.provider.DiagnosticDecorator;
import org.eclipse.emf.edit.ui.provider.UnwrappingSelectionProvider;
import org.eclipse.emf.edit.ui.util.EditUIMarkerHelper;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.emf.edit.ui.view.ExtendedPropertySheetPage;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.oomph.predicates.Predicate;
import org.eclipse.oomph.predicates.PredicatesPackage;
import org.eclipse.oomph.predicates.provider.PredicatesItemProviderAdapterFactory;
import org.eclipse.oomph.preferences.PreferenceNode;
import org.eclipse.oomph.preferences.presentation.PreferencesEditor;
import org.eclipse.oomph.preferences.provider.PreferencesItemProviderAdapterFactory;
import org.eclipse.oomph.projectconfig.PreferenceFilter;
import org.eclipse.oomph.projectconfig.ProjectConfigPackage;
import org.eclipse.oomph.projectconfig.WorkspaceConfiguration;
import org.eclipse.oomph.projectconfig.impl.ProjectConfigURIHandlerImpl;
import org.eclipse.oomph.projectconfig.presentation.ProjectConfigEditorPlugin;
import org.eclipse.oomph.projectconfig.provider.ProjectConfigItemProviderAdapterFactory;
import org.eclipse.oomph.projectconfig.util.ProjectConfigUtil;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectConfigEditor
extends MultiPageEditorPart
implements IEditingDomainProvider,
ISelectionProvider,
IMenuListener,
IViewerProvider,
IGotoMarker {
    protected AdapterFactoryEditingDomain editingDomain;
    protected ComposedAdapterFactory adapterFactory;
    protected PreferencesEditor.OutlinePage contentOutlinePage;
    protected IStatusLineManager contentOutlineStatusLineManager;
    protected TreeViewer contentOutlineViewer;
    protected List<PropertySheetPage> propertySheetPages = new ArrayList<PropertySheetPage>();
    protected TreeViewer selectionViewer;
    protected Viewer currentViewer;
    protected ISelectionChangedListener selectionChangedListener;
    protected Collection<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    protected ISelection editorSelection = StructuredSelection.EMPTY;
    protected MarkerHelper markerHelper = new EditUIMarkerHelper();
    protected IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart p) {
            if (p instanceof ContentOutline) {
                if (((ContentOutline)p).getCurrentPage() == ProjectConfigEditor.this.contentOutlinePage) {
                    ProjectConfigEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)ProjectConfigEditor.this);
                    ProjectConfigEditor.this.setCurrentViewer((Viewer)ProjectConfigEditor.this.contentOutlineViewer);
                }
            } else if (p instanceof PropertySheet) {
                if (ProjectConfigEditor.this.propertySheetPages.contains(((PropertySheet)p).getCurrentPage())) {
                    ProjectConfigEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)ProjectConfigEditor.this);
                    ProjectConfigEditor.this.handleActivate();
                }
            } else if (p == ProjectConfigEditor.this) {
                ProjectConfigEditor.this.handleActivate();
                ProjectConfigEditor.this.setCurrentViewer((Viewer)ProjectConfigEditor.this.selectionViewer);
            }
        }

        public void partBroughtToTop(IWorkbenchPart p) {
        }

        public void partClosed(IWorkbenchPart p) {
        }

        public void partDeactivated(IWorkbenchPart p) {
        }

        public void partOpened(IWorkbenchPart p) {
        }
    };
    protected Collection<Resource> removedResources = new ArrayList<Resource>();
    protected Collection<Resource> changedResources = new LinkedHashSet<Resource>();
    protected Collection<Resource> savedResources = new ArrayList<Resource>();
    protected Map<Resource, Diagnostic> resourceToDiagnosticMap = new LinkedHashMap<Resource, Diagnostic>();
    protected boolean updateProblemIndication = true;
    protected EContentAdapter problemIndicationAdapter = new EContentAdapter(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void notifyChanged(Notification notification) {
            if (notification.getNotifier() instanceof Resource) {
                switch (notification.getFeatureID(Resource.class)) {
                    case 4: 
                    case 6: 
                    case 7: {
                        Resource resource = (Resource)notification.getNotifier();
                        Diagnostic diagnostic = ProjectConfigEditor.this.analyzeResourceProblems(resource, null);
                        if (diagnostic.getSeverity() != 0) {
                            ProjectConfigEditor.this.resourceToDiagnosticMap.put(resource, diagnostic);
                        } else {
                            ProjectConfigEditor.this.resourceToDiagnosticMap.remove(resource);
                        }
                        if (!ProjectConfigEditor.this.updateProblemIndication) return;
                        ProjectConfigEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                ProjectConfigEditor.this.updateProblemIndication();
                            }
                        });
                    }
                    default: {
                        return;
                    }
                }
            } else {
                super.notifyChanged(notification);
            }
        }

        protected void setTarget(Resource target) {
            this.basicSetTarget((Notifier)target);
        }

        protected void unsetTarget(Resource target) {
            this.basicUnsetTarget((Notifier)target);
            ProjectConfigEditor.this.resourceToDiagnosticMap.remove(target);
            if (ProjectConfigEditor.this.updateProblemIndication) {
                ProjectConfigEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        ProjectConfigEditor.this.updateProblemIndication();
                    }
                });
            }
        }
    };
    protected IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class ResourceDeltaVisitor
                implements IResourceDeltaVisitor {
                    protected ResourceSet resourceSet;
                    protected Collection<Resource> changedResources;
                    protected Collection<Resource> removedResources;
                    protected Resource mainResource;

                    ResourceDeltaVisitor() {
                        this.resourceSet = (this).ProjectConfigEditor.this.editingDomain.getResourceSet();
                        this.changedResources = new LinkedHashSet<Resource>();
                        this.removedResources = new ArrayList<Resource>();
                        this.mainResource = (Resource)this.resourceSet.getResources().get(0);
                    }

                    public boolean visit(IResourceDelta delta) {
                        if (delta.getResource().getType() == 1) {
                            Resource resource;
                            IPath fullPath = delta.getFullPath();
                            if (".settings".equals(fullPath.segment(1))) {
                                this.changedResources.add(this.mainResource);
                            }
                            if ((delta.getKind() == 2 || delta.getKind() == 4) && (resource = this.resourceSet.getResource(URI.createPlatformResourceURI((String)fullPath.toString(), (boolean)true), false)) != null) {
                                if (delta.getKind() == 2) {
                                    this.removedResources.add(resource);
                                } else {
                                    if ((delta.getFlags() & 0x20000) != 0) {
                                        DiagnosticDecorator.DiagnosticAdapter.update((Notifier)resource, (Diagnostic)(this).ProjectConfigEditor.this.markerHelper.getMarkerDiagnostics((Object)resource, (IFile)delta.getResource()));
                                    }
                                    if ((delta.getFlags() & 0x100) != 0 && !(this).ProjectConfigEditor.this.savedResources.remove(resource)) {
                                        this.changedResources.add(resource);
                                    }
                                }
                            }
                            return false;
                        }
                        return true;
                    }

                    public Collection<Resource> getChangedResources() {
                        return this.changedResources;
                    }

                    public Collection<Resource> getRemovedResources() {
                        return this.removedResources;
                    }
                }
                final ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
                delta.accept((IResourceDeltaVisitor)visitor);
                if (!visitor.getRemovedResources().isEmpty()) {
                    ProjectConfigEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){
                        {
                        }

                        public void run() {
                            (this).ProjectConfigEditor.this.removedResources.addAll(visitor.getRemovedResources());
                            if (!ProjectConfigEditor.this.isDirty()) {
                                ProjectConfigEditor.this.getSite().getPage().closeEditor((IEditorPart)ProjectConfigEditor.this, false);
                            }
                        }
                    });
                }
                if (!visitor.getChangedResources().isEmpty()) {
                    ProjectConfigEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){
                        {
                        }

                        public void run() {
                            (this).ProjectConfigEditor.this.changedResources.addAll(visitor.getChangedResources());
                            if (ProjectConfigEditor.this.getSite().getPage().getActiveEditor() == ProjectConfigEditor.this) {
                                ProjectConfigEditor.this.handleActivate();
                            }
                        }
                    });
                }
            }
            catch (CoreException exception) {
                ProjectConfigEditorPlugin.INSTANCE.log((Object)exception);
            }
        }
    };

    protected void handleActivate() {
        if (this.editingDomain.getResourceToReadOnlyMap() != null) {
            this.editingDomain.getResourceToReadOnlyMap().clear();
            this.setSelection(this.getSelection());
        }
        if (!this.removedResources.isEmpty()) {
            if (this.handleDirtyConflict()) {
                this.getSite().getPage().closeEditor((IEditorPart)this, false);
            } else {
                this.removedResources.clear();
                this.changedResources.clear();
                this.savedResources.clear();
            }
        } else if (!this.changedResources.isEmpty()) {
            this.changedResources.removeAll(this.savedResources);
            this.handleChangedResources();
            this.changedResources.clear();
            this.savedResources.clear();
        }
    }

    protected void handleChangedResources() {
        if (!this.changedResources.isEmpty()) {
            boolean discard;
            List expandedElements = this.selectionViewer == null ? Collections.emptyList() : Arrays.asList(this.selectionViewer.getExpandedElements());
            ISelection selection = this.selectionViewer == null ? null : this.selectionViewer.getSelection();
            boolean bl = discard = !this.isDirty() || this.handleDirtyConflict();
            if (this.isDirty()) {
                this.changedResources.addAll((Collection<Resource>)this.editingDomain.getResourceSet().getResources());
            }
            this.editingDomain.getCommandStack().flush();
            this.updateProblemIndication = false;
            for (final Resource resource : this.changedResources) {
                block8: {
                    WorkspaceConfiguration workspaceConfiguration;
                    PreferenceNode cache;
                    EObject object;
                    if (!resource.isLoaded()) continue;
                    WorkspaceConfiguration cachedWorkspaceConfiguration = null;
                    EList contents = resource.getContents();
                    if (!discard && !contents.isEmpty() && (object = (EObject)contents.get(0)) instanceof WorkspaceConfiguration && (cache = ProjectConfigUtil.cacheWorkspaceConfiguration((WorkspaceConfiguration)(workspaceConfiguration = (WorkspaceConfiguration)object))) != null) {
                        cachedWorkspaceConfiguration = ProjectConfigUtil.getWorkspaceConfiguration((PreferenceNode)cache);
                    }
                    resource.unload();
                    try {
                        resource.load(Collections.EMPTY_MAP);
                        if (cachedWorkspaceConfiguration != null) {
                            final WorkspaceConfiguration workspaceConfiguration2 = cachedWorkspaceConfiguration;
                            CompoundCommand command = new CompoundCommand("Restore Contents", "Restore the contents of the resource with the editor's previous changes"){

                                protected boolean prepare() {
                                    EList contents = resource.getContents();
                                    return this.appendIfCanExecute((Command)new RemoveCommand((EditingDomain)ProjectConfigEditor.this.editingDomain, contents, (Collection)contents)) && this.appendIfCanExecute((Command)new AddCommand((EditingDomain)ProjectConfigEditor.this.editingDomain, contents, new ArrayList(workspaceConfiguration2.eResource().getContents())));
                                }
                            };
                            this.editingDomain.getCommandStack().execute((Command)command);
                        }
                    }
                    catch (IOException exception) {
                        if (this.resourceToDiagnosticMap.containsKey(resource)) break block8;
                        this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
                    }
                }
                if (this.contentOutlinePage == null) continue;
                this.contentOutlinePage.update();
            }
            if (this.selectionViewer != null) {
                class DummyNotification
                extends ViewerNotification {
                    boolean trigger;
                    private final /* synthetic */ List val$expandedElements;
                    private final /* synthetic */ ISelection val$selection;

                    public DummyNotification(List list, ISelection iSelection) {
                        this.val$expandedElements = list;
                        this.val$selection = iSelection;
                        super(null, (Object)ProjectConfigEditor.this.editingDomain.getResourceSet(), false, false);
                    }

                    public Object getElement() {
                        if (this.trigger) {
                            Display display = ProjectConfigEditor.this.getSite().getShell().getDisplay();
                            display.asyncExec(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void run() {
                                    Resource resource = (Resource)((DummyNotification)this).ProjectConfigEditor.this.editingDomain.getResourceSet().getResources().get(0);
                                    synchronized (resource) {
                                        ResourceSet resourceSet = ((DummyNotification)this).ProjectConfigEditor.this.editingDomain.getResourceSet();
                                        synchronized (resourceSet) {
                                            for (Object object : val$expandedElements) {
                                                EObject eObject;
                                                if (!(object instanceof EObject) || !(eObject = (EObject)object).eIsProxy()) continue;
                                                eObject.eAdapters().clear();
                                            }
                                            ((DummyNotification)this).ProjectConfigEditor.this.selectionViewer.setExpandedElements(((DummyNotification)this).ProjectConfigEditor.this.editingDomain.resolve((Collection)val$expandedElements).toArray());
                                            if (val$selection != null) {
                                                List selectedObjects = ((IStructuredSelection)val$selection).toList();
                                                for (Object object : selectedObjects) {
                                                    EObject eObject;
                                                    if (!(object instanceof EObject) || !(eObject = (EObject)object).eIsProxy()) continue;
                                                    eObject.eAdapters().clear();
                                                }
                                                ProjectConfigEditor.this.setSelectionToViewer(((DummyNotification)this).ProjectConfigEditor.this.editingDomain.resolve((Collection)selectedObjects));
                                            }
                                        }
                                    }
                                }
                            });
                        }
                        return super.getElement();
                    }
                }
                DummyNotification notification = new DummyNotification(expandedElements, selection);
                this.adapterFactory.fireNotifyChanged((Notification)notification);
                notification.trigger = true;
            }
            this.updateProblemIndication = true;
            this.updateProblemIndication();
        }
    }

    protected void updateProblemIndication() {
        if (this.updateProblemIndication) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(0, "org.eclipse.oomph.projectconfig.editor", 0, null, new Object[]{this.editingDomain.getResourceSet()});
            for (Diagnostic childDiagnostic : this.resourceToDiagnosticMap.values()) {
                if (childDiagnostic.getSeverity() == 0) continue;
                diagnostic.add(childDiagnostic);
            }
            int lastEditorPage = this.getPageCount() - 1;
            if (lastEditorPage >= 0 && this.getEditor(lastEditorPage) instanceof ProblemEditorPart) {
                ((ProblemEditorPart)this.getEditor(lastEditorPage)).setDiagnostic((Diagnostic)diagnostic);
                if (diagnostic.getSeverity() != 0) {
                    this.setActivePage(lastEditorPage);
                }
            } else if (diagnostic.getSeverity() != 0) {
                ProblemEditorPart problemEditorPart = new ProblemEditorPart();
                problemEditorPart.setDiagnostic((Diagnostic)diagnostic);
                problemEditorPart.setMarkerHelper(this.markerHelper);
                try {
                    this.addPage(++lastEditorPage, (IEditorPart)problemEditorPart, this.getEditorInput());
                    this.setPageText(lastEditorPage, problemEditorPart.getPartName());
                    this.setActivePage(lastEditorPage);
                    this.showTabs();
                }
                catch (PartInitException exception) {
                    ProjectConfigEditorPlugin.INSTANCE.log((Object)exception);
                }
            }
            if (this.markerHelper.hasMarkers((Object)this.editingDomain.getResourceSet())) {
                this.markerHelper.deleteMarkers((Object)this.editingDomain.getResourceSet());
                if (diagnostic.getSeverity() != 0) {
                    try {
                        this.markerHelper.createMarkers((Diagnostic)diagnostic);
                    }
                    catch (CoreException exception) {
                        ProjectConfigEditorPlugin.INSTANCE.log((Object)exception);
                    }
                }
            }
        }
    }

    protected boolean handleDirtyConflict() {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)ProjectConfigEditor.getString("_UI_FileConflict_label"), (String)ProjectConfigEditor.getString("_WARN_FileConflict"));
    }

    public ProjectConfigEditor() {
        this.initializeEditingDomain();
    }

    protected void initializeEditingDomain() {
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ProjectConfigItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new PredicatesItemProviderAdapterFactory(){
            {
                this.childCreationExtenderManager.getChildCreationExtenders().add(new ProjectConfigItemProviderAdapterFactory.PredicatesChildCreationExtender());
            }
        });
        this.adapterFactory.addAdapterFactory((AdapterFactory)new PreferencesItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        BasicCommandStack commandStack = new BasicCommandStack(){

            public void execute(Command command) {
                EList resources = ProjectConfigEditor.this.editingDomain.getResourceSet().getResources();
                if (!resources.isEmpty()) {
                    final WorkspaceConfiguration workspaceConfiguration = (WorkspaceConfiguration)((Resource)resources.get(0)).getContents().get(0);
                    CompoundCommand compoundCommand = new CompoundCommand(0);
                    compoundCommand.append(command);
                    compoundCommand.append((Command)new ChangeCommand((Notifier)workspaceConfiguration){

                        public String getDescription() {
                            return "Updates preference profile references based on the preference profile predicates";
                        }

                        public String getLabel() {
                            return "Update References";
                        }

                        protected void doExecute() {
                            workspaceConfiguration.updatePreferenceProfileReferences();
                        }
                    });
                    command = compoundCommand;
                }
                super.execute(command);
            }
        };
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(final EventObject event) {
                ProjectConfigEditor.this.getContainer().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        ProjectConfigEditor.this.firePropertyChange(257);
                        Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                        if (mostRecentCommand != null) {
                            ProjectConfigEditor.this.setSelectionToViewer(mostRecentCommand.getAffectedObjects());
                        }
                        Iterator<PropertySheetPage> i = (this).ProjectConfigEditor.this.propertySheetPages.iterator();
                        while (i.hasNext()) {
                            PropertySheetPage propertySheetPage = i.next();
                            if (propertySheetPage.getControl().isDisposed()) {
                                i.remove();
                                continue;
                            }
                            propertySheetPage.refresh();
                        }
                    }
                });
            }
        });
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)commandStack, new HashMap()){

            public Collection<?> getNewChildDescriptors(Object object, Object sibling) {
                ArrayList newChildDescriptors = new ArrayList(super.getNewChildDescriptors(object, sibling));
                Iterator it = newChildDescriptors.iterator();
                while (it.hasNext()) {
                    EObject eObject;
                    EPackage ePackage;
                    CommandParameter commandParameter;
                    Object child;
                    Object value = it.next();
                    if (!(value instanceof CommandParameter) || !((child = (commandParameter = (CommandParameter)value).getValue()) instanceof Predicate) || (ePackage = (eObject = (EObject)child).eClass().getEPackage()) == PredicatesPackage.eINSTANCE || ePackage == ProjectConfigPackage.eINSTANCE) continue;
                    it.remove();
                }
                return newChildDescriptors;
            }
        };
    }

    protected void firePropertyChange(int action) {
        super.firePropertyChange(action);
    }

    public void setSelectionToViewer(Collection<?> collection) {
        final Collection<?> theSelection = collection;
        if (theSelection != null && !theSelection.isEmpty()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    if (ProjectConfigEditor.this.currentViewer != null) {
                        ProjectConfigEditor.this.currentViewer.setSelection((ISelection)new StructuredSelection(theSelection.toArray()), true);
                    }
                }
            };
            this.getSite().getShell().getDisplay().asyncExec(runnable);
        }
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void setCurrentViewer(Viewer viewer) {
        if (this.currentViewer != viewer) {
            if (this.selectionChangedListener == null) {
                this.selectionChangedListener = new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                        ProjectConfigEditor.this.setSelection(selectionChangedEvent.getSelection());
                    }
                };
            }
            if (this.currentViewer != null) {
                this.currentViewer.removeSelectionChangedListener(this.selectionChangedListener);
            }
            if (viewer != null) {
                viewer.addSelectionChangedListener(this.selectionChangedListener);
            }
            this.currentViewer = viewer;
            this.setSelection((ISelection)(this.currentViewer == null ? StructuredSelection.EMPTY : this.currentViewer.getSelection()));
        }
    }

    public Viewer getViewer() {
        return this.currentViewer;
    }

    protected void createContextMenuFor(StructuredViewer viewer) {
        this.createContextMenuForGen(viewer);
        viewer.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                if (event.button == 1) {
                    try {
                        ProjectConfigEditor.this.getEditorSite().getPage().showView("org.eclipse.ui.views.PropertySheet");
                    }
                    catch (PartInitException exception) {
                        ProjectConfigEditorPlugin.INSTANCE.log((Object)exception);
                    }
                }
            }
        });
    }

    protected void createContextMenuForGen(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)new UnwrappingSelectionProvider((ISelectionProvider)viewer));
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance(), LocalSelectionTransfer.getTransfer(), FileTransfer.getInstance()};
        viewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)viewer));
        viewer.addDropSupport(dndOperations, transfers, (DropTargetListener)new EditingDomainViewerDropAdapter((EditingDomain)this.editingDomain, (Viewer)viewer));
    }

    public void reload() {
        ResourceSet resourceSet = this.editingDomain.getResourceSet();
        this.editingDomain.getCommandStack().flush();
        EList resources = resourceSet.getResources();
        resources.clear();
        Exception exception = null;
        Resource resource = null;
        URI resourceURI = EditUIUtil.getURI((IEditorInput)this.getEditorInput());
        try {
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, true);
        }
        catch (Exception e) {
            exception = e;
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, false);
        }
        Diagnostic diagnostic = this.analyzeResourceProblems(resource, exception);
        if (diagnostic.getSeverity() != 0) {
            this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
        }
        this.selectionViewer.setInput((Object)resource);
        this.selectionViewer.expandToLevel(resource.getContents().get(0), 1);
        if (this.contentOutlinePage != null) {
            this.contentOutlinePage.update();
        }
    }

    public void createModel() {
        Resource resource;
        ResourceSet resourceSet = this.editingDomain.getResourceSet();
        resourceSet.getURIConverter().getURIHandlers().add(0, (Object)new ProjectConfigURIHandlerImpl());
        this.createModelGen();
        URI resourceURI = EditUIUtil.getURI((IEditorInput)this.getEditorInput());
        if ("configuration".equals(resourceURI.scheme()) && resourceURI.segmentCount() == 1 && (resource = resourceSet.getResource(resourceURI, false)) != null) {
            EObject object;
            resourceSet.getURIConverter().getURIMap().put(ProjectConfigUtil.PROJECT_CONFIG_URI, resource.getURI());
            EList contents = resource.getContents();
            if (!contents.isEmpty() && (object = (EObject)contents.get(0)) instanceof WorkspaceConfiguration) {
                WorkspaceConfiguration workspaceConfiguration = (WorkspaceConfiguration)object;
                new ProjectConfigUtil.CompletenessChecker(workspaceConfiguration){

                    protected void complete() {
                        ProjectConfigEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                ProjectConfigEditor.this.reload();
                            }
                        });
                    }
                };
            }
        }
    }

    public void createModelGen() {
        URI resourceURI = EditUIUtil.getURI((IEditorInput)this.getEditorInput());
        Exception exception = null;
        Resource resource = null;
        try {
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, true);
        }
        catch (Exception e) {
            exception = e;
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, false);
        }
        Diagnostic diagnostic = this.analyzeResourceProblems(resource, exception);
        if (diagnostic.getSeverity() != 0) {
            this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
        }
        this.editingDomain.getResourceSet().eAdapters().add((Object)this.problemIndicationAdapter);
    }

    public Diagnostic analyzeResourceProblems(Resource resource, Exception exception) {
        boolean hasErrors;
        boolean bl = hasErrors = !resource.getErrors().isEmpty();
        if (hasErrors || !resource.getWarnings().isEmpty()) {
            BasicDiagnostic basicDiagnostic = new BasicDiagnostic(hasErrors ? 4 : 2, "org.eclipse.oomph.projectconfig.editor", 0, ProjectConfigEditor.getString("_UI_CreateModelError_message", resource.getURI()), new Object[]{exception == null ? resource : exception});
            basicDiagnostic.merge(EcoreUtil.computeDiagnostic((Resource)resource, (boolean)true));
            return basicDiagnostic;
        }
        if (exception != null) {
            return new BasicDiagnostic(4, "org.eclipse.oomph.projectconfig.editor", 0, ProjectConfigEditor.getString("_UI_CreateModelError_message", resource.getURI()), new Object[]{exception});
        }
        return Diagnostic.OK_INSTANCE;
    }

    public void createPages() {
        this.createPagesGen();
        EList resources = this.getEditingDomain().getResourceSet().getResources();
        if (!resources.isEmpty()) {
            Resource resource = (Resource)resources.get(0);
            this.selectionViewer.setInput((Object)resource);
            this.selectionViewer.expandToLevel(resource.getContents().get(0), 1);
        }
        DiagnosticDecorator labelDecorator = new DiagnosticDecorator((EditingDomain)this.editingDomain, (StructuredViewer)this.selectionViewer, ProjectConfigEditorPlugin.getPlugin().getDialogSettings());
        DecoratingColumLabelProvider labelProvider = new DecoratingColumLabelProvider((ILabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory), (ILabelDecorator)labelDecorator);
        this.selectionViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
    }

    public void createPagesGen() {
        this.createModel();
        if (!this.getEditingDomain().getResourceSet().getResources().isEmpty()) {
            Tree tree = new Tree(this.getContainer(), 2);
            this.selectionViewer = new TreeViewer(tree);
            this.setCurrentViewer((Viewer)this.selectionViewer);
            this.selectionViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
            this.selectionViewer.setLabelProvider((IBaseLabelProvider)new DecoratingColumLabelProvider((ILabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory), (ILabelDecorator)new DiagnosticDecorator((EditingDomain)this.editingDomain, (StructuredViewer)this.selectionViewer, ProjectConfigEditorPlugin.getPlugin().getDialogSettings())));
            this.selectionViewer.setInput((Object)this.editingDomain.getResourceSet());
            this.selectionViewer.setSelection((ISelection)new StructuredSelection(this.editingDomain.getResourceSet().getResources().get(0)), true);
            new AdapterFactoryTreeEditor(this.selectionViewer.getTree(), (AdapterFactory)this.adapterFactory);
            new ColumnViewerInformationControlToolTipSupport((ColumnViewer)this.selectionViewer, (LocationListener)new DiagnosticDecorator.EditingDomainLocationListener((EditingDomain)this.editingDomain, (StructuredViewer)this.selectionViewer));
            this.createContextMenuFor((StructuredViewer)this.selectionViewer);
            int pageIndex = this.addPage((Control)tree);
            this.setPageText(pageIndex, ProjectConfigEditor.getString("_UI_SelectionPage_label"));
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ProjectConfigEditor.this.setActivePage(0);
                }
            });
        }
        this.getContainer().addControlListener((ControlListener)new ControlAdapter(){
            boolean guard = false;

            public void controlResized(ControlEvent event) {
                if (!this.guard) {
                    this.guard = true;
                    ProjectConfigEditor.this.hideTabs();
                    this.guard = false;
                }
            }
        });
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                ProjectConfigEditor.this.updateProblemIndication();
            }
        });
    }

    protected void hideTabs() {
        if (this.getPageCount() <= 1) {
            this.setPageText(0, "");
            if (this.getContainer() instanceof CTabFolder) {
                ((CTabFolder)this.getContainer()).setTabHeight(1);
                Point point = this.getContainer().getSize();
                this.getContainer().setSize(point.x, point.y + 6);
            }
        }
    }

    protected void showTabs() {
        if (this.getPageCount() > 1) {
            this.setPageText(0, ProjectConfigEditor.getString("_UI_SelectionPage_label"));
            if (this.getContainer() instanceof CTabFolder) {
                ((CTabFolder)this.getContainer()).setTabHeight(-1);
                Point point = this.getContainer().getSize();
                this.getContainer().setSize(point.x, point.y - 6);
            }
        }
    }

    protected void pageChange(int pageIndex) {
        super.pageChange(pageIndex);
        if (this.contentOutlinePage != null) {
            this.handleContentOutlineSelection(this.contentOutlinePage.getSelection());
        }
    }

    public Object getAdapter(Class key) {
        if (key.equals(IContentOutlinePage.class)) {
            return this.showOutlineView() ? this.getContentOutlinePage() : null;
        }
        if (key.equals(IPropertySheetPage.class)) {
            return this.getPropertySheetPage();
        }
        if (key.equals(IGotoMarker.class)) {
            return this;
        }
        return super.getAdapter(key);
    }

    public IContentOutlinePage getContentOutlinePage() {
        if (this.contentOutlinePage == null) {
            this.contentOutlinePage = new PreferencesEditor.OutlinePage(this.editingDomain, this.selectionViewer){

                public void createControl(Composite parent) {
                    super.createControl(parent);
                    ProjectConfigEditor.this.contentOutlineViewer = this.getTreeViewer();
                }

                protected void createContextMenuFor(StructuredViewer viewer) {
                    ProjectConfigEditor.this.createContextMenuFor(viewer);
                }

                public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
                    super.makeContributions(menuManager, toolBarManager, statusLineManager);
                    ProjectConfigEditor.this.contentOutlineStatusLineManager = statusLineManager;
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    ProjectConfigEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                }

                protected void handleContentOutlineSelection(ISelection selection) {
                    ProjectConfigEditor.this.handleContentOutlineSelection(selection);
                }

                protected void collectSelection(List<Object> selection, Object object) {
                    if (object instanceof IWrapperItemProvider) {
                        object = ((IWrapperItemProvider)object).getValue();
                    } else if (object instanceof PreferenceFilter) {
                        object = ((PreferenceFilter)object).getPreferenceNode();
                    }
                    super.collectSelection(selection, object);
                }

                protected void setSelection(IStructuredSelection selection) {
                    TreeViewer oldSelectionViewer = ProjectConfigEditor.this.selectionViewer;
                    ProjectConfigEditor.this.selectionViewer = null;
                    this.getTreeViewer().setSelection((ISelection)selection);
                    ProjectConfigEditor.this.selectionViewer = oldSelectionViewer;
                }
            };
        }
        return this.contentOutlinePage;
    }

    public IPropertySheetPage getPropertySheetPage() {
        ExtendedPropertySheetPage propertySheetPage = new ExtendedPropertySheetPage(this.editingDomain, ExtendedPropertySheetPage.Decoration.LIVE, ProjectConfigEditorPlugin.getPlugin().getDialogSettings()){

            public void setSelectionToViewer(List<?> selection) {
                ProjectConfigEditor.this.setSelectionToViewer(selection);
                ProjectConfigEditor.this.setFocus();
            }

            public void setActionBars(IActionBars actionBars) {
                super.setActionBars(actionBars);
                ProjectConfigEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
            }
        };
        propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
        this.propertySheetPages.add((PropertySheetPage)propertySheetPage);
        return propertySheetPage;
    }

    public void handleContentOutlineSelection(ISelection selection) {
        Iterator selectedElements;
        if (this.selectionViewer != null && !selection.isEmpty() && selection instanceof IStructuredSelection && (selectedElements = ((IStructuredSelection)selection).iterator()).hasNext()) {
            Object selectedElement = selectedElements.next();
            ArrayList<Object> selectionList = new ArrayList<Object>();
            selectionList.addAll(this.unwrap(selectedElement));
            while (selectedElements.hasNext()) {
                selectionList.add(this.unwrap(selectedElements.next()));
            }
            this.selectionViewer.setSelection((ISelection)new StructuredSelection(selectionList));
        }
    }

    private List<? extends Object> unwrap(Object object) {
        if (object instanceof PreferencesEditor.OutlinePage.Wrapper) {
            return ((PreferencesEditor.OutlinePage.Wrapper)object).getWrappedObjects();
        }
        return Collections.singletonList(object);
    }

    public boolean isDirty() {
        return ((BasicCommandStack)this.editingDomain.getCommandStack()).isSaveNeeded();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        final HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("LINE_DELIMITER", "");
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                boolean first = true;
                for (Resource resource : ProjectConfigEditor.this.editingDomain.getResourceSet().getResources()) {
                    if (!first && resource.getContents().isEmpty() && !ProjectConfigEditor.this.isPersisted(resource) || ProjectConfigEditor.this.editingDomain.isReadOnly(resource)) continue;
                    try {
                        long timeStamp = resource.getTimeStamp();
                        resource.save(saveOptions);
                        if (resource.getTimeStamp() != timeStamp) {
                            ProjectConfigEditor.this.savedResources.add(resource);
                        }
                    }
                    catch (Exception exception) {
                        ProjectConfigEditor.this.resourceToDiagnosticMap.put(resource, ProjectConfigEditor.this.analyzeResourceProblems(resource, exception));
                    }
                    first = false;
                }
            }
        };
        this.updateProblemIndication = false;
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(false, false, (IRunnableWithProgress)operation);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.firePropertyChange(257);
        }
        catch (Exception exception) {
            ProjectConfigEditorPlugin.INSTANCE.log(exception);
        }
        this.updateProblemIndication = true;
        this.updateProblemIndication();
    }

    protected boolean isPersisted(Resource resource) {
        boolean result = false;
        try {
            InputStream stream = this.editingDomain.getResourceSet().getURIConverter().createInputStream(resource.getURI());
            if (stream != null) {
                result = true;
                stream.close();
            }
        }
        catch (IOException iOException) {}
        return result;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        IFile file;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null) {
            this.doSaveAs(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), (IEditorInput)new FileEditorInput(file));
        }
    }

    protected void doSaveAs(URI uri, IEditorInput editorInput) {
        ((Resource)this.editingDomain.getResourceSet().getResources().get(0)).setURI(uri);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        NullProgressMonitor progressMonitor = this.getActionBars().getStatusLineManager() != null ? this.getActionBars().getStatusLineManager().getProgressMonitor() : new NullProgressMonitor();
        this.doSave((IProgressMonitor)progressMonitor);
    }

    public void gotoMarker(IMarker marker) {
        List targetObjects = this.markerHelper.getTargetObjects((Object)this.editingDomain, marker);
        if (!targetObjects.isEmpty()) {
            this.setSelectionToViewer(targetObjects);
        }
    }

    public void init(IEditorSite site, IEditorInput editorInput) {
        this.initGen(site, editorInput);
        IContextService contextService = (IContextService)site.getService(IContextService.class);
        contextService.activateContext("org.eclipse.oomph.projectconfig.editor.context");
    }

    public void initGen(IEditorSite site, IEditorInput editorInput) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        site.setSelectionProvider((ISelectionProvider)this);
        site.getPage().addPartListener(this.partListener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
    }

    public void setFocus() {
        this.getControl(this.getActivePage()).setFocus();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.editorSelection;
    }

    public void setSelection(ISelection selection) {
        this.editorSelection = selection;
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        }
        this.setStatusLineManager(selection);
    }

    public void setStatusLineManager(ISelection selection) {
        IStatusLineManager statusLineManager;
        IStatusLineManager iStatusLineManager = statusLineManager = this.currentViewer != null && this.currentViewer == this.contentOutlineViewer ? this.contentOutlineStatusLineManager : this.getActionBars().getStatusLineManager();
        if (statusLineManager != null) {
            if (selection instanceof IStructuredSelection) {
                List collection = ((IStructuredSelection)selection).toList();
                switch (collection.size()) {
                    case 0: {
                        statusLineManager.setMessage(ProjectConfigEditor.getString("_UI_NoObjectSelected"));
                        break;
                    }
                    case 1: {
                        String text = new AdapterFactoryItemDelegator((AdapterFactory)this.adapterFactory).getText(collection.iterator().next());
                        statusLineManager.setMessage(ProjectConfigEditor.getString("_UI_SingleObjectSelected", text));
                        break;
                    }
                    default: {
                        statusLineManager.setMessage(ProjectConfigEditor.getString("_UI_MultiObjectSelected", Integer.toString(collection.size())));
                        break;
                    }
                }
            } else {
                statusLineManager.setMessage("");
            }
        }
    }

    private static String getString(String key) {
        return ProjectConfigEditorPlugin.INSTANCE.getString(key);
    }

    private static String getString(String key, Object s1) {
        return ProjectConfigEditorPlugin.INSTANCE.getString(key, new Object[]{s1});
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        ((IMenuListener)this.getEditorSite().getActionBarContributor()).menuAboutToShow(menuManager);
    }

    public EditingDomainActionBarContributor getActionBarContributor() {
        return (EditingDomainActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    public IActionBars getActionBars() {
        return this.getActionBarContributor().getActionBars();
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void dispose() {
        this.updateProblemIndication = false;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.getSite().getPage().removePartListener(this.partListener);
        this.adapterFactory.dispose();
        if (this.getActionBarContributor().getActiveEditor() == this) {
            this.getActionBarContributor().setActiveEditor(null);
        }
        for (PropertySheetPage propertySheetPage : this.propertySheetPages) {
            propertySheetPage.dispose();
        }
        if (this.contentOutlinePage != null) {
            this.contentOutlinePage.dispose();
        }
        super.dispose();
    }

    protected boolean showOutlineView() {
        return true;
    }

    public class ReverseAdapterFactoryContentProvider
    extends AdapterFactoryContentProvider {
        public ReverseAdapterFactoryContentProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Object[] getElements(Object object) {
            Object parent = super.getParent(object);
            return (parent == null ? Collections.EMPTY_SET : Collections.singleton(parent)).toArray();
        }

        public Object[] getChildren(Object object) {
            Object parent = super.getParent(object);
            return (parent == null ? Collections.EMPTY_SET : Collections.singleton(parent)).toArray();
        }

        public boolean hasChildren(Object object) {
            Object parent = super.getParent(object);
            return parent != null;
        }

        public Object getParent(Object object) {
            return null;
        }
    }
}

