/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.natives;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Activator;
import org.eclipse.equinox.internal.p2.touchpoint.natives.ClosedBackupStoreException;
import org.eclipse.equinox.internal.p2.touchpoint.natives.IBackupStore;
import org.eclipse.equinox.internal.p2.touchpoint.natives.LazyBackupStore;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Messages;
import org.eclipse.equinox.internal.p2.touchpoint.natives.NativePackageEntry;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Util;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.core.UIServices;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.spi.Touchpoint;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class NativeTouchpoint
extends Touchpoint {
    public static final String PARM_BACKUP = "backup";
    public static final String PARM_ARTIFACT = "artifact";
    public static final String PARM_ARTIFACT_LOCATION = "artifact.location";
    private static final String FOLDER = "nativePackageScripts";
    private static final String INSTALL_COMMANDS = "installCommands.txt";
    private static final String INSTALL_PREFIX = "installPrefix";
    private static Map<IProfile, IBackupStore> backups = new WeakHashMap<IProfile, IBackupStore>();
    private final List<NativePackageToInstallInfo> packagesToInstall = new ArrayList<NativePackageToInstallInfo>();
    private final Properties installCommandsProperties = new Properties();
    private IProvisioningAgent agent;
    private String distro;

    public IStatus initializeOperand(IProfile profile, Map<String, Object> parameters) {
        this.agent = (IProvisioningAgent)parameters.get("agent");
        IArtifactKey artifactKey = (IArtifactKey)parameters.get(PARM_ARTIFACT);
        if (!parameters.containsKey(PARM_ARTIFACT_LOCATION) && artifactKey != null) {
            try {
                IFileArtifactRepository downloadCache = Util.getDownloadCacheRepo(this.agent);
                File fileLocation = downloadCache.getArtifactFile(artifactKey);
                if (fileLocation != null && fileLocation.exists()) {
                    parameters.put(PARM_ARTIFACT_LOCATION, fileLocation.getAbsolutePath());
                }
            }
            catch (ProvisionException e) {
                return e.getStatus();
            }
        }
        return Status.OK_STATUS;
    }

    public IStatus initializePhase(IProgressMonitor monitor, IProfile profile, String phaseId, Map<String, Object> touchpointParameters) {
        touchpointParameters.put(PARM_BACKUP, NativeTouchpoint.getBackupStore(profile));
        return null;
    }

    public String qualifyAction(String actionId) {
        return "org.eclipse.equinox.p2.touchpoint.natives." + actionId;
    }

    public IStatus prepare(IProfile profile) {
        return super.prepare(profile);
    }

    public IStatus commit(IProfile profile) {
        this.promptForNativePackage();
        IBackupStore store = NativeTouchpoint.getBackupStore(profile);
        store.discard();
        NativeTouchpoint.clearProfileState(profile);
        return Status.OK_STATUS;
    }

    private void promptForNativePackage() {
        if (this.packagesToInstall.size() == 0) {
            return;
        }
        NativeTouchpoint.loadInstallCommandsProperties(this.installCommandsProperties, this.distro);
        UIServices serviceUI = (UIServices)this.agent.getService(UIServices.class);
        Object text = Messages.PromptForNative_IntroText;
        Object downloadLinks = "";
        ArrayList<NativePackageEntry> entriesWithoutDownloadLink = new ArrayList<NativePackageEntry>(this.packagesToInstall.size());
        for (NativePackageToInstallInfo nativePackageEntry : this.packagesToInstall) {
            String name;
            text = (String)text + "\t" + nativePackageEntry.entry.name + " " + this.formatVersion(nativePackageEntry.entry);
            if (nativePackageEntry.iu != null && (name = nativePackageEntry.iu.getProperty("org.eclipse.equinox.p2.name", null)) != null && !name.isEmpty()) {
                text = (String)text + " ";
                text = (String)text + NLS.bind((String)Messages.NativeTouchpoint_PromptForNative_RequiredBy, (Object)name);
            }
            text = (String)text + "\n";
            if (nativePackageEntry.entry.getDownloadLink() != null) {
                downloadLinks = (String)downloadLinks + "    <a>" + nativePackageEntry.entry.getDownloadLink() + "</a>\n";
                continue;
            }
            entriesWithoutDownloadLink.add(nativePackageEntry.entry);
        }
        String installCommands = this.createCommand(entriesWithoutDownloadLink);
        if (installCommands != null) {
            text = (String)text + Messages.PromptForNative_InstallText + installCommands;
        }
        String downloadText = null;
        if (((String)downloadLinks).length() > 0) {
            downloadText = Messages.NativeTouchpoint_PromptForNative_YouCanDownloadFrom + (String)downloadLinks;
        }
        serviceUI.showInformationMessage(Messages.PromptForNative_DialogTitle, (String)text, downloadText);
    }

    private String formatVersion(NativePackageEntry entry) {
        if (entry.getVersion() == null) {
            return null;
        }
        return this.getUserFriendlyComparator(entry.comparator) + " " + entry.version + " ";
    }

    private String getUserFriendlyComparator(String comparator) {
        if (comparator == null) {
            return "";
        }
        return this.installCommandsProperties.getProperty(comparator, "");
    }

    public static void loadInstallCommandsProperties(Properties properties, String distro) {
        File f = NativeTouchpoint.getFileFromBundle(distro, INSTALL_COMMANDS);
        if (f == null) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(f));){
                properties.load(is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String getInstallCommad() {
        return this.installCommandsProperties.getProperty(INSTALL_PREFIX, "");
    }

    private String createCommand(List<NativePackageEntry> packageEntries) {
        if (packageEntries.isEmpty()) {
            return null;
        }
        String text = this.getInstallCommad() + " ";
        for (NativePackageEntry nativePackageEntry : packageEntries) {
            text = text + nativePackageEntry.name + " ";
        }
        return text;
    }

    public void addPackageToInstall(NativePackageEntry entry, IInstallableUnit iu) {
        this.packagesToInstall.add(new NativePackageToInstallInfo(entry, iu));
    }

    public List<NativePackageEntry> getPackagesToInstall() {
        return Collections.unmodifiableList(this.packagesToInstall.stream().map(e -> e.entry).collect(Collectors.toList()));
    }

    public void setDistro(String distro) {
        this.distro = distro;
    }

    public static String escape(String toEscape) {
        StringBuffer buffer = new StringBuffer();
        int length = toEscape.length();
        int i = 0;
        while (i < length) {
            char ch = toEscape.charAt(i);
            switch (ch) {
                case '\"': 
                case '%': 
                case '*': 
                case '/': 
                case ':': 
                case '<': 
                case '>': 
                case '?': 
                case '\\': 
                case '|': {
                    buffer.append("%" + ch + ";");
                    break;
                }
                default: {
                    buffer.append(ch);
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    public IStatus rollback(IProfile profile) {
        IStatus returnStatus = Status.OK_STATUS;
        IBackupStore store = NativeTouchpoint.getBackupStore(profile);
        try {
            store.restore();
        }
        catch (IOException e) {
            returnStatus = new Status(4, "org.eclipse.equinox.p2.touchpoint.natives", NLS.bind((String)Messages.failed_backup_restore, (Object)store.getBackupName()), (Throwable)e);
        }
        catch (ClosedBackupStoreException e) {
            returnStatus = new Status(4, "org.eclipse.equinox.p2.touchpoint.natives", NLS.bind((String)Messages.failed_backup_restore, (Object)store.getBackupName()), (Throwable)e);
        }
        NativeTouchpoint.clearProfileState(profile);
        return returnStatus;
    }

    public static File getFileFromBundle(String distro, String file) {
        URL[] installScripts = FileLocator.findEntries((Bundle)Activator.getContext().getBundle(), (IPath)IPath.fromOSString((String)("nativePackageScripts/" + distro + "/" + file)));
        if (installScripts.length == 0) {
            return null;
        }
        try {
            return URIUtil.toFile((URI)URIUtil.toURI((URL)FileLocator.toFileURL((URL)installScripts[0])));
        }
        catch (URISyntaxException uRISyntaxException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static synchronized void clearProfileState(IProfile profile) {
        backups.remove(profile);
    }

    private static synchronized IBackupStore getBackupStore(IProfile profile) {
        IBackupStore store = backups.get(profile);
        if (store == null) {
            store = new LazyBackupStore(NativeTouchpoint.escape(profile.getProfileId()));
            backups.put(profile, store);
        }
        return store;
    }

    private static class NativePackageToInstallInfo {
        NativePackageEntry entry;
        IInstallableUnit iu;

        public NativePackageToInstallInfo(NativePackageEntry entry, IInstallableUnit iu) {
            this.entry = entry;
            this.iu = iu;
        }
    }
}

