/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.RecordPattern;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public abstract class Pattern
extends Expression {
    boolean isTotalTypeNode = false;
    private Pattern enclosingPattern;
    protected MethodBinding accessorMethod;
    public int index = -1;
    public boolean isUnguarded = true;

    public Pattern getEnclosingPattern() {
        return this.enclosingPattern;
    }

    public void setEnclosingPattern(RecordPattern enclosingPattern) {
        this.enclosingPattern = enclosingPattern;
    }

    public boolean isUnnamed() {
        return false;
    }

    public boolean coversType(TypeBinding type) {
        if (!this.isUnguarded()) {
            return false;
        }
        if (type == null || this.resolvedType == null) {
            return false;
        }
        return type.isSubtypeOf(this.resolvedType, false);
    }

    public boolean matchFailurePossible() {
        return false;
    }

    public boolean isUnconditional(TypeBinding t) {
        return this.isUnguarded() && this.coversType(t);
    }

    public abstract void generateCode(BlockScope var1, CodeStream var2, BranchLabel var3, BranchLabel var4);

    @Override
    public boolean checkUnsafeCast(Scope scope, TypeBinding castType, TypeBinding expressionType, TypeBinding match, boolean isNarrowing) {
        if (!castType.isReifiable()) {
            return CastExpression.checkUnsafeCast(this, scope, castType, expressionType, match, isNarrowing);
        }
        return super.checkUnsafeCast(scope, castType, expressionType, match, isNarrowing);
    }

    public TypeReference getType() {
        return null;
    }

    protected boolean isApplicable(TypeBinding other, BlockScope scope) {
        TypeBinding patternType = this.resolvedType;
        if (patternType == null) {
            return false;
        }
        if (patternType.isBaseType() != other.isBaseType()) {
            scope.problemReporter().incompatiblePatternType(this, other, patternType);
            return false;
        }
        if (patternType.isBaseType()) {
            if (!TypeBinding.equalsEquals(other, patternType)) {
                scope.problemReporter().incompatiblePatternType(this, other, patternType);
                return false;
            }
        } else if (!this.checkCastTypesCompatibility(scope, other, patternType, null, true)) {
            scope.problemReporter().incompatiblePatternType(this, other, patternType);
            return false;
        }
        return true;
    }

    public abstract boolean dominates(Pattern var1);

    @Override
    public StringBuilder print(int indent, StringBuilder output) {
        return this.printExpression(indent, output);
    }

    public Pattern[] getAlternatives() {
        return new Pattern[]{this};
    }

    public abstract void setIsEitherOrPattern();

    public boolean isUnguarded() {
        return this.isUnguarded;
    }

    public void setIsGuarded() {
        this.isUnguarded = false;
    }
}

